/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thebetweenlands.client.gui.GuiFirefly;
import thebetweenlands.client.render.shader.ShaderHelper;
import thebetweenlands.client.render.shader.effect.StarfieldEffect;

@SideOnly(value=Side.CLIENT)
public class GuiBLMainMenu
extends GuiMainMenu {
    public static final ResourceLocation LOGO_TEXTURE = new ResourceLocation("thebetweenlands", "textures/gui/main/logo.png");
    public static final int LAYER_COUNT = 4;
    private List<GuiFirefly> fireFlies = new ArrayList<GuiFirefly>();
    private ResourceLocation[] layerTextures = new ResourceLocation[4];
    private int layerTick;
    private Random random = new Random();
    private StarfieldEffect starfieldEffect;
    private Framebuffer starfieldTextureFBO = null;

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(1, 5, this.field_146295_m - 25, 80, 20, I18n.func_135052_a((String)"menu.singleplayer", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(2, 90, this.field_146295_m - 25, 80, 20, I18n.func_135052_a((String)"menu.multiplayer", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(14, 175, this.field_146295_m - 25, 80, 20, "Realms"));
        this.field_146292_n.add(new GuiButton(6, this.field_146294_l - 100, this.field_146295_m - 25, 20, 20, "M"));
        this.field_146292_n.add(new GuiButton(5, this.field_146294_l - 75, this.field_146295_m - 25, 20, 20, "L"));
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l - 50, this.field_146295_m - 25, 20, 20, "O"));
        this.field_146292_n.add(new GuiButton(4, this.field_146294_l - 25, this.field_146295_m - 25, 20, 20, "Q"));
        for (int i = 0; i < this.layerTextures.length; ++i) {
            this.layerTextures[i] = new ResourceLocation("thebetweenlands", "textures/gui/main/layer" + i + ".png");
        }
        if (ShaderHelper.INSTANCE.canUseShaders()) {
            if (this.starfieldTextureFBO != null) {
                this.starfieldTextureFBO.func_147608_a();
            }
            this.starfieldTextureFBO = new Framebuffer(this.field_146294_l, this.field_146295_m, false);
            if (this.starfieldEffect == null) {
                this.starfieldEffect = (StarfieldEffect)new StarfieldEffect(false).init();
            }
        }
    }

    public void func_73876_c() {
        ++this.layerTick;
        if (this.random.nextInt(32) == 0) {
            this.fireFlies.add(new GuiFirefly(this.field_146294_l + 50, this.random.nextInt(this.field_146295_m), this.random.nextFloat() - this.random.nextFloat(), this.random.nextFloat() - this.random.nextFloat()));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i;
        GuiBLMainMenu.func_73734_a((int)0, (int)0, (int)this.field_146294_l, (int)this.field_146295_m, (int)-16773120);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawStarfield();
        for (i = 0; i < this.layerTextures.length; ++i) {
            if (i == this.layerTextures.length - 1) {
                for (GuiFirefly firefly : this.fireFlies) {
                    if (!(firefly.posY < (float)(this.field_146295_m + 40))) continue;
                    firefly.drawFireFly(this.field_146297_k);
                }
            }
            ResourceLocation layerTexture = this.layerTextures[i];
            this.field_146297_k.func_110434_K().func_110577_a(layerTexture);
            double u = ((float)this.layerTick / (float)(this.layerTextures.length - i) + partialTicks / (float)(i + 1) + (float)(1024 * i) / 4.0f) / 4000.0f;
            double v = 0.0;
            double visibleU = (double)this.field_146294_l / (double)this.field_146295_m * (256.0 / (1024.0 * (double)i));
            double x = 0.0;
            double y = 0.0;
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78374_a(x + 0.0, y + (double)this.field_146295_m, (double)this.field_73735_i, u, 1.0);
            tessellator.func_78374_a(x + (double)this.field_146294_l, y + (double)this.field_146295_m, (double)this.field_73735_i, u + visibleU, 1.0);
            tessellator.func_78374_a(x + (double)this.field_146294_l, y + 0.0, (double)this.field_73735_i, u + visibleU, 0.0);
            tessellator.func_78374_a(x + 0.0, y + 0.0, (double)this.field_73735_i, u, 0.0);
            tessellator.func_78381_a();
        }
        for (i = 0; i < this.fireFlies.size(); ++i) {
            if (!(this.fireFlies.get((int)i).posY >= (float)(this.field_146295_m + 40))) continue;
            this.fireFlies.remove(i);
        }
        GL11.glDisable((int)3553);
        GuiBLMainMenu.func_73734_a((int)0, (int)(this.field_146295_m - 30), (int)this.field_146294_l, (int)this.field_146295_m, (int)0x60000000);
        GL11.glEnable((int)3553);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        this.field_146297_k.func_110434_K().func_110577_a(LOGO_TEXTURE);
        this.drawTexturedModalRect(this.field_146294_l / 2 - 80, 20.0f + MathHelper.func_76126_a((float)(((float)this.layerTick + partialTicks) / 16.0f)) * 6.0f, 0.0, 0.0, 161.0, 79.0, 256.0, 256.0, this.field_73735_i);
        this.func_73729_b(0, 0, 239, 0, 17, 16);
        for (GuiButton button : this.field_146292_n) {
            button.func_146112_a(this.field_146297_k, mouseX, mouseY);
        }
    }

    protected void drawStarfield() {
        if (ShaderHelper.INSTANCE.canUseShaders() && this.starfieldEffect != null && this.starfieldTextureFBO != null) {
            this.starfieldEffect.setTimeScale(5.0E-7f).setZoom(4.8f);
            this.starfieldEffect.setOffset((float)this.layerTick / 8000.0f, 0.0f, 0.0f);
            int renderDimension = Math.max(this.field_146294_l, this.field_146295_m);
            this.starfieldEffect.create(this.starfieldTextureFBO).setPreviousFBO(Minecraft.func_71410_x().func_147110_a()).setRenderDimensions(renderDimension, renderDimension).render();
            GL11.glBindTexture((int)3553, (int)this.starfieldTextureFBO.field_147617_g);
            GL11.glBegin((int)4);
            GL11.glTexCoord2d((double)0.0, (double)1.0);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glTexCoord2d((double)0.0, (double)0.0);
            GL11.glVertex2d((double)0.0, (double)this.field_146295_m);
            GL11.glTexCoord2d((double)1.0, (double)0.0);
            GL11.glVertex2d((double)this.field_146294_l, (double)this.field_146295_m);
            GL11.glTexCoord2d((double)1.0, (double)0.0);
            GL11.glVertex2d((double)this.field_146294_l, (double)this.field_146295_m);
            GL11.glTexCoord2d((double)1.0, (double)1.0);
            GL11.glVertex2d((double)this.field_146294_l, (double)0.0);
            GL11.glTexCoord2d((double)0.0, (double)1.0);
            GL11.glVertex2d((double)0.0, (double)0.0);
            GL11.glEnd();
        }
    }

    public void drawTexturedModalRect(double x, double y, double u, double v, double width, double height, double textureWidth, double textureHeight, double zLevel) {
        double f = 1.0 / textureWidth;
        double f1 = 1.0 / textureHeight;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(x + 0.0, y + height, zLevel, u * f, (v + height) * f1);
        tessellator.func_78374_a(x + width, y + height, zLevel, (u + width) * f, (v + height) * f1);
        tessellator.func_78374_a(x + width, y + 0.0, zLevel, (u + width) * f, v * f1);
        tessellator.func_78374_a(x + 0.0, y + 0.0, zLevel, u * f, v * f1);
        tessellator.func_78381_a();
    }
}

