/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.client.audio.EntityMusicSound;
import thebetweenlands.entities.IEntityMusic;
import thebetweenlands.lib.ModInfo;

public class BLMusicHandler {
    private MusicTicker prevMusicTicker;
    private Field mcMusicTickerField;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mcMusicTickerField == null) {
            this.mcMusicTickerField = ReflectionHelper.findField(Minecraft.class, (String[])new String[]{"mcMusicTicker", "field_147126_aw", "ax"});
        }
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e != null) {
                if (mc.field_71441_e.field_73011_w.field_76574_g == ModInfo.DIMENSION_ID && this.prevMusicTicker == null) {
                    this.prevMusicTicker = this.getMcMusicTicker();
                    this.setMcMusicTicker(new BLMusicTicker(mc));
                } else if (mc.field_71441_e.field_73011_w.field_76574_g != ModInfo.DIMENSION_ID && this.prevMusicTicker != null) {
                    this.setMcMusicTicker(this.prevMusicTicker);
                    this.prevMusicTicker = null;
                }
            } else if (this.prevMusicTicker != null) {
                this.setMcMusicTicker(this.prevMusicTicker);
                this.prevMusicTicker = null;
            }
        }
    }

    private void setMcMusicTicker(MusicTicker musicTicker) {
        try {
            this.mcMusicTickerField.set(Minecraft.func_71410_x(), musicTicker);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private MusicTicker getMcMusicTicker() {
        try {
            return (MusicTicker)this.mcMusicTickerField.get(Minecraft.func_71410_x());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class BLMusicTicker
    extends MusicTicker {
        private final Random RNG = new Random();
        private final Minecraft mc;
        private ISound currentSound;
        private int timeUntilMusic = 100;
        private static final ResourceLocation BL_MUSIC_RES = new ResourceLocation("thebetweenlands:music.blDimension");
        private static final int MIN_WAIT = 6000;
        private static final int MAX_WAIT = 12000;
        private EntityMusicSound currentlyPlayingEntityMusic = null;

        public BLMusicTicker(Minecraft minecraft) {
            super(minecraft);
            this.mc = minecraft;
        }

        public void func_73660_a() {
            Entity closestMusicEntity = null;
            if (this.mc.field_71441_e != null) {
                for (Entity entity : this.mc.field_71441_e.field_72996_f) {
                    if (!(entity instanceof IEntityMusic) || closestMusicEntity != null && !(entity.func_70032_d((Entity)this.mc.field_71439_g) < closestMusicEntity.func_70032_d((Entity)this.mc.field_71439_g)) || !((double)entity.func_70032_d((Entity)this.mc.field_71439_g) <= ((IEntityMusic)entity).getMusicRange((EntityPlayer)this.mc.field_71439_g)) || !((IEntityMusic)entity).isMusicActive((EntityPlayer)this.mc.field_71439_g)) continue;
                    closestMusicEntity = entity;
                }
            }
            if (this.currentlyPlayingEntityMusic != null && !this.mc.func_147118_V().func_147692_c((ISound)this.currentlyPlayingEntityMusic)) {
                this.currentlyPlayingEntityMusic = null;
            }
            if (closestMusicEntity != null) {
                if (this.mc.func_147118_V().func_147692_c(this.currentSound)) {
                    this.mc.func_147118_V().func_147683_b(this.currentSound);
                    this.currentSound = null;
                    this.timeUntilMusic = Math.min(MathHelper.func_76136_a((Random)this.RNG, (int)6000, (int)12000), this.timeUntilMusic);
                }
                if (this.currentlyPlayingEntityMusic != null && this.currentlyPlayingEntityMusic.entity != closestMusicEntity && !this.currentlyPlayingEntityMusic.func_147667_k() && this.mc.func_147118_V().func_147692_c(this.currentSound)) {
                    this.currentlyPlayingEntityMusic.stop();
                    this.currentlyPlayingEntityMusic = null;
                }
                if (this.currentlyPlayingEntityMusic == null) {
                    this.currentlyPlayingEntityMusic = new EntityMusicSound(closestMusicEntity, new ResourceLocation(((IEntityMusic)closestMusicEntity).getMusicFile((EntityPlayer)this.mc.field_71439_g)), 1.0f, 1.0f);
                    this.mc.func_147118_V().func_147682_a((ISound)this.currentlyPlayingEntityMusic);
                }
            }
            if (this.currentlyPlayingEntityMusic != null && !this.currentlyPlayingEntityMusic.func_147667_k()) {
                if (!((IEntityMusic)this.currentlyPlayingEntityMusic.entity).isMusicActive((EntityPlayer)this.mc.field_71439_g) && this.mc.func_147118_V().func_147692_c(this.currentSound)) {
                    this.currentlyPlayingEntityMusic.stop();
                    this.currentlyPlayingEntityMusic = null;
                }
            } else {
                if (this.currentSound != null) {
                    if (!BL_MUSIC_RES.equals((Object)this.currentSound.func_147650_b())) {
                        this.mc.func_147118_V().func_147683_b(this.currentSound);
                        this.timeUntilMusic = MathHelper.func_76136_a((Random)this.RNG, (int)0, (int)3000);
                    }
                    if (!this.mc.func_147118_V().func_147692_c(this.currentSound)) {
                        this.currentSound = null;
                        this.timeUntilMusic = Math.min(MathHelper.func_76136_a((Random)this.RNG, (int)6000, (int)12000), this.timeUntilMusic);
                    }
                }
                if (this.currentSound == null && this.timeUntilMusic-- <= 0) {
                    this.currentSound = PositionedSoundRecord.func_147673_a((ResourceLocation)BL_MUSIC_RES);
                    this.mc.func_147118_V().func_147682_a(this.currentSound);
                    this.timeUntilMusic = Integer.MAX_VALUE;
                }
            }
        }
    }
}

