/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.audio.ambience;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.client.audio.ambience.AmbienceManager;
import thebetweenlands.client.audio.ambience.AmbienceType;

@SideOnly(value=Side.CLIENT)
public class AmbienceSound
extends MovingSound {
    private boolean fadeOut = false;
    private boolean isLowPriority = false;
    public final EntityPlayer player;
    public final AmbienceType type;
    public final AmbienceManager mgr;

    public AmbienceSound(AmbienceType type, EntityPlayer player, ResourceLocation sound, AmbienceManager mgr) {
        super(sound);
        this.type = type;
        this.player = player;
        this.field_147659_g = true;
        this.field_147666_i = ISound.AttenuationType.NONE;
        this.field_147662_b = 0.1f;
        this.field_147663_c = this.type.getPitch();
        this.mgr = mgr;
    }

    public void func_73660_a() {
        if (!this.field_147668_j) {
            this.field_147663_c = this.type.getPitch();
        }
        float desiredVolume = this.type.getVolume();
        int fadeTicks = Math.max(this.type.getFadeTime(), 1);
        float incr = Math.max(desiredVolume / (float)fadeTicks, 0.001f);
        if (this.isStopping()) {
            desiredVolume = 0.0f;
        }
        if (this.isLowPriority) {
            desiredVolume = Math.min(desiredVolume, this.mgr.getLowerPriorityVolume());
        }
        if (this.field_147662_b > desiredVolume) {
            this.field_147662_b -= incr;
            if (this.field_147662_b < desiredVolume) {
                this.field_147662_b = desiredVolume;
                if (this.isStopping()) {
                    this.field_147668_j = true;
                }
            }
        } else if (this.field_147662_b < desiredVolume) {
            this.field_147662_b += incr;
            if (this.field_147662_b > desiredVolume) {
                this.field_147662_b = desiredVolume;
            }
        }
    }

    public void stop() {
        this.fadeOut = true;
    }

    public boolean isFadingOut() {
        return this.fadeOut;
    }

    public void cancelFade() {
        this.fadeOut = false;
    }

    public void stopImmediately() {
        this.field_147668_j = true;
    }

    public boolean isStopping() {
        return this.field_147668_j || this.fadeOut || !this.type.isActive();
    }

    void setLowPriority(boolean lowPriority) {
        this.isLowPriority = lowPriority;
    }
}

