/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.audio.ambience;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.client.audio.ambience.AmbienceSound;
import thebetweenlands.client.audio.ambience.AmbienceType;

@SideOnly(value=Side.CLIENT)
public class AmbienceManager {
    public static final AmbienceManager INSTANCE = new AmbienceManager();
    private static final Comparator<AmbienceType> PRIORITY_COMPARATOR = new Comparator<AmbienceType>(){

        @Override
        public int compare(AmbienceType a1, AmbienceType a2) {
            return Integer.compare(a2.getPriority(), a1.getPriority());
        }
    };
    private final Map<AmbienceType.EnumAmbienceLayer, List<AmbienceType>> ambienceRegistry = new HashMap<AmbienceType.EnumAmbienceLayer, List<AmbienceType>>();
    private final List<AmbienceSound> delayedAmbiences = new ArrayList<AmbienceSound>();
    private final List<AmbienceSound> playingAmbiences = new ArrayList<AmbienceSound>();

    public void registerAmbience(AmbienceType type) {
        List<AmbienceType> types = this.ambienceRegistry.get((Object)type.getAmbienceLayer());
        if (types == null) {
            types = new ArrayList<AmbienceType>();
            this.ambienceRegistry.put(type.getAmbienceLayer(), types);
        }
        types.add(type);
    }

    private List<AmbienceType> getTypes(AmbienceType.EnumAmbienceLayer layer) {
        List<AmbienceType> types = this.ambienceRegistry.get((Object)layer);
        if (types == null) {
            types = new ArrayList<AmbienceType>();
        }
        return types;
    }

    private List<AmbienceType> getTypes() {
        ArrayList<AmbienceType> types = new ArrayList<AmbienceType>();
        for (Map.Entry<AmbienceType.EnumAmbienceLayer, List<AmbienceType>> entry : this.ambienceRegistry.entrySet()) {
            types.addAll((Collection<AmbienceType>)entry.getValue());
        }
        return types;
    }

    private List<AmbienceType> sortByPriority(List<AmbienceType> types) {
        ArrayList<AmbienceType> copy = new ArrayList<AmbienceType>();
        copy.addAll(types);
        Collections.sort(copy, PRIORITY_COMPARATOR);
        return copy;
    }

    public void update() {
        Iterator<AmbienceSound> delayedAmbiencesIT = this.delayedAmbiences.iterator();
        while (delayedAmbiencesIT.hasNext()) {
            AmbienceSound sound = delayedAmbiencesIT.next();
            boolean soundPlaying = Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)sound) || sound.func_147667_k();
            if (!soundPlaying) continue;
            delayedAmbiencesIT.remove();
        }
        Iterator<AmbienceSound> playingAmbiencesIT = this.playingAmbiences.iterator();
        while (playingAmbiencesIT.hasNext()) {
            boolean soundPlaying;
            AmbienceSound sound = playingAmbiencesIT.next();
            boolean bl = soundPlaying = Minecraft.func_71410_x().func_147118_V().func_147692_c((ISound)sound) || this.delayedAmbiences.contains((Object)sound);
            if (!sound.func_147667_k() && soundPlaying) continue;
            if (soundPlaying) {
                Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)sound);
            }
            playingAmbiencesIT.remove();
        }
        EntityPlayer player = TheBetweenlands.proxy.getClientPlayer();
        if (player != null) {
            for (AmbienceType.EnumAmbienceLayer layer : AmbienceType.EnumAmbienceLayer.TYPES) {
                List<AmbienceType> availableAmbiences = this.getTypes(layer);
                for (AmbienceType type : availableAmbiences) {
                    type.setPlayer(player);
                }
                int tracks = layer.tracks;
                if (availableAmbiences.isEmpty()) continue;
                List<AmbienceType> sorted = this.sortByPriority(availableAmbiences);
                boolean lowerOthers = true;
                int typeIndex = 0;
                for (int i = 0; i < sorted.size() && typeIndex < tracks; ++i) {
                    AmbienceType type = sorted.get(i);
                    if (!type.isActive()) continue;
                    ++typeIndex;
                    boolean isPlaying = false;
                    for (AmbienceSound sound : this.playingAmbiences) {
                        if (!type.equals(sound.type)) continue;
                        sound.setLowPriority(false);
                        isPlaying = true;
                        if (!sound.isFadingOut()) break;
                        sound.cancelFade();
                        break;
                    }
                    if (!isPlaying) {
                        this.playSound(new AmbienceSound(type, player, type.getSound(), this), type.getDelay());
                    }
                    if (!(type.getLowerPriorityVolume() < 0.0f)) continue;
                    lowerOthers = false;
                }
                for (AmbienceSound sound : this.playingAmbiences) {
                    if (sound.isStopping()) continue;
                    boolean hasPriority = false;
                    int index = 0;
                    for (int i = 0; i < sorted.size() && index < tracks; ++i) {
                        AmbienceType type = sorted.get(i);
                        if (!type.isActive()) continue;
                        ++index;
                        if (!sound.type.equals(type)) continue;
                        hasPriority = true;
                        break;
                    }
                    if (hasPriority) continue;
                    if (!lowerOthers) {
                        sound.stop();
                        continue;
                    }
                    sound.setLowPriority(true);
                }
            }
        }
    }

    float getLowerPriorityVolume() {
        float lowest = Float.MAX_VALUE;
        for (AmbienceSound sound : this.playingAmbiences) {
            if (!(sound.type.getLowerPriorityVolume() > 0.0f) || !(sound.type.getLowerPriorityVolume() < lowest)) continue;
            lowest = sound.type.getLowerPriorityVolume();
        }
        return lowest;
    }

    private void playSound(AmbienceSound sound, int delay) {
        this.playingAmbiences.add(sound);
        if (sound.type.getSound() != null) {
            if (delay == 0) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
            } else {
                this.delayedAmbiences.add(sound);
                Minecraft.func_71410_x().func_147118_V().func_147681_a((ISound)sound, delay);
            }
        }
    }

    public boolean shouldStopMusic() {
        EntityPlayer player = TheBetweenlands.proxy.getClientPlayer();
        if (player != null) {
            for (AmbienceSound sound : this.playingAmbiences) {
                if (!sound.type.stopsMusic()) continue;
                return true;
            }
        }
        return false;
    }

    public void stopAll() {
        for (AmbienceSound sound : this.playingAmbiences) {
            sound.stopImmediately();
        }
        this.playingAmbiences.clear();
    }
}

