/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.audio;

import com.google.common.base.Throwables;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.audio.ISoundEventAccessor;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundEventAccessorComposite;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundPoolEntry;
import net.minecraft.client.audio.SoundRegistry;
import net.minecraft.util.ResourceLocation;

public class SuperbSoundRegistry
extends SoundRegistry {
    private static final Field SOUNDS_FIELD = ReflectionHelper.findField(SoundEventAccessorComposite.class, (String[])new String[]{"soundPool", "field_148736_a", "a"});
    private static final Field VOLUME_FIELD = ReflectionHelper.findField(SoundEventAccessorComposite.class, (String[])new String[]{"eventVolume", "field_148731_f", "f"});
    private static final Field PITCH_FIELD = ReflectionHelper.findField(SoundEventAccessorComposite.class, (String[])new String[]{"eventPitch", "field_148733_e", "e"});
    private Map heresTheFieldYoureLookingForPixelmon;

    protected Map func_148740_a() {
        this.heresTheFieldYoureLookingForPixelmon = super.func_148740_a();
        return this.heresTheFieldYoureLookingForPixelmon;
    }

    public void func_148762_a(SoundEventAccessorComposite sound) {
        super.func_148762_a((SoundEventAccessorComposite)new SuperbSoundEventAccessorComposite(sound));
    }

    private static class SuperbSoundEventAccessorComposite
    extends SoundEventAccessorComposite {
        private List<ISoundEventAccessor> sounds = new ArrayList<ISoundEventAccessor>();
        private ISoundEventAccessor lastEntry;
        private Random rand = new Random();
        private ResourceLocation location;
        private SoundCategory category;
        private double volume;
        private double pitch;

        public SuperbSoundEventAccessorComposite(SoundEventAccessorComposite sound) {
            super(null, 0.0, 0.0, null);
            try {
                this.sounds = (List)SOUNDS_FIELD.get(sound);
                this.volume = VOLUME_FIELD.getDouble(sound);
                this.pitch = PITCH_FIELD.getDouble(sound);
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
            }
            this.location = sound.func_148729_c();
            this.category = sound.func_148728_d();
        }

        public int func_148721_a() {
            return this.calculateWeight(this.getSoundsExcludingLastEntry());
        }

        private int calculateWeight(List<ISoundEventAccessor> sounds) {
            int weight = 0;
            Iterator<ISoundEventAccessor> soundIter = sounds.iterator();
            while (soundIter.hasNext()) {
                weight += soundIter.next().func_148721_a();
            }
            return weight;
        }

        private List<ISoundEventAccessor> getSoundsExcludingLastEntry() {
            if (this.lastEntry == null) {
                return this.sounds;
            }
            ArrayList<ISoundEventAccessor> newSounds = new ArrayList<ISoundEventAccessor>(this.sounds);
            newSounds.remove(this.lastEntry);
            return newSounds;
        }

        public SoundPoolEntry func_148720_g() {
            List<ISoundEventAccessor> soundChoices = this.getSoundsExcludingLastEntry();
            int weight = this.calculateWeight(soundChoices);
            if (!soundChoices.isEmpty() && weight != 0) {
                ISoundEventAccessor entry;
                int choice = this.rand.nextInt(weight);
                Iterator<ISoundEventAccessor> entryIter = soundChoices.iterator();
                do {
                    if (entryIter.hasNext()) continue;
                    return SoundHandler.field_147700_a;
                } while ((choice -= (entry = entryIter.next()).func_148721_a()) >= 0);
                if (this.sounds.size() > 1) {
                    this.lastEntry = entry;
                }
                SoundPoolEntry poolEntry = (SoundPoolEntry)entry.func_148720_g();
                poolEntry.func_148651_a(poolEntry.func_148650_b() * this.pitch);
                poolEntry.func_148647_b(poolEntry.func_148649_c() * this.volume);
                return poolEntry;
            }
            return SoundHandler.field_147700_a;
        }

        public void func_148727_a(ISoundEventAccessor sound) {
            this.sounds.add(sound);
        }

        public ResourceLocation func_148729_c() {
            return this.location;
        }

        public SoundCategory func_148728_d() {
            return this.category;
        }
    }
}

