/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.tree;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.creativetabs.BLCreativeTabs;
import thebetweenlands.world.events.impl.EventSpoopy;

public class BlockBLLeaves
extends BlockLeaves {
    private int[] decayBlockCache;
    private String type;
    @SideOnly(value=Side.CLIENT)
    private IIcon fastIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon spoopyIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon spoopyFastIcon;
    private boolean placedByPlayer;
    private boolean hasSpoopyTexture = false;

    public BlockBLLeaves(String blockName) {
        this.func_149711_c(0.2f);
        this.func_149713_g(1);
        this.func_149647_a(BLCreativeTabs.plants);
        this.func_149672_a(Block.field_149779_h);
        this.type = blockName;
        this.func_149663_c("thebetweenlands." + this.type);
        this.func_149658_d("thebetweenlands:" + this.type);
    }

    public BlockBLLeaves setHasSpoopyTexture(boolean spoopyTexture) {
        this.hasSpoopyTexture = spoopyTexture;
        return this;
    }

    public boolean isLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public String func_149732_F() {
        return String.format(StatCollector.func_74838_a((String)("tile.thebetweenlands." + this.type)), new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (EventSpoopy.isSpoopy((World)Minecraft.func_71410_x().field_71441_e) && this.hasSpoopyTexture) {
            return Minecraft.func_71410_x().field_71474_y.field_74347_j ? this.spoopyIcon : this.spoopyFastIcon;
        }
        return Minecraft.func_71410_x().field_71474_y.field_74347_j ? this.field_149761_L : this.fastIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return Minecraft.func_71410_x().field_71474_y.field_74347_j || world.func_147439_a(x, y, z) != this;
    }

    public boolean func_149662_c() {
        return Blocks.field_150362_t.func_149662_c();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a(this.func_149641_N() + "Fancy");
        this.fastIcon = reg.func_94245_a(this.func_149641_N() + "Fast");
        if (this.hasSpoopyTexture) {
            this.spoopyIcon = reg.func_94245_a(this.func_149641_N() + "FancySpoopy");
            this.spoopyFastIcon = reg.func_94245_a(this.func_149641_N() + "FastSpoopy");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        return 0xFFFFFF;
    }

    public String[] func_150125_e() {
        return null;
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float chance, int fortune) {
        if (!world.field_72995_K) {
            int dropChance = 35;
            if (fortune > 0) {
                dropChance -= 2 * fortune;
            }
            if (world.field_73012_v.nextInt(dropChance) == 0) {
                this.func_149642_a(world, x, y, z, new ItemStack(this.func_149650_a(meta, world.field_73012_v, fortune), 1));
            }
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        world.func_72921_c(x, y, z, 1, 2);
    }

    public void beginLeavesDecay(World world, int x, int y, int z) {
        if (world.func_72805_g(x, y, z) != 1) {
            int i2 = world.func_72805_g(x, y, z);
            if ((i2 & 8) == 0) {
                world.func_72921_c(x, y, z, i2 | 8, 4);
            }
            world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) | 8, 4);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (world.field_73012_v.nextInt(200) == 0 && world.func_147437_c(x, y - 1, z)) {
            BLParticle.LEAF.spawn(world, (float)x + rand.nextFloat(), y, (float)z + rand.nextFloat());
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int blockMeta;
        if (!world.field_72995_K && ((blockMeta = world.func_72805_g(x, y, z)) & 8) != 0 && (blockMeta & 4) == 0) {
            int distanceToLog;
            int logReach = 5;
            int checkRadius = logReach + 1;
            int cacheSize = 32;
            int cacheSquared = cacheSize * cacheSize;
            int cacheHalf = cacheSize / 2;
            if (this.decayBlockCache == null) {
                this.decayBlockCache = new int[cacheSize * cacheSize * cacheSize];
            }
            if (world.func_72904_c(x - checkRadius, y - checkRadius, z - checkRadius, x + checkRadius, y + checkRadius, z + checkRadius)) {
                for (int xo = -logReach; xo <= logReach; ++xo) {
                    for (int yo = -logReach; yo <= logReach; ++yo) {
                        for (int zo = -logReach; zo <= logReach; ++zo) {
                            Block block = world.func_147439_a(x + xo, y + yo, z + zo);
                            if (!block.canSustainLeaves((IBlockAccess)world, x + xo, y + yo, z + zo)) {
                                if (block.isLeaves((IBlockAccess)world, x + xo, y + yo, z + zo)) {
                                    this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] = -2;
                                    continue;
                                }
                                this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] = -1;
                                continue;
                            }
                            this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] = 0;
                        }
                    }
                }
                for (int distancePass = 1; distancePass <= logReach; ++distancePass) {
                    for (int xo = -logReach; xo <= logReach; ++xo) {
                        for (int yo = -logReach; yo <= logReach; ++yo) {
                            for (int zo = -logReach; zo <= logReach; ++zo) {
                                if (this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] != distancePass - 1) continue;
                                if (this.decayBlockCache[(xo + cacheHalf - 1) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] == -2) {
                                    this.decayBlockCache[(xo + cacheHalf - 1) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] = distancePass;
                                }
                                if (this.decayBlockCache[(xo + cacheHalf + 1) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] == -2) {
                                    this.decayBlockCache[(xo + cacheHalf + 1) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf] = distancePass;
                                }
                                if (this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf - 1) * cacheSize + zo + cacheHalf] == -2) {
                                    this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf - 1) * cacheSize + zo + cacheHalf] = distancePass;
                                }
                                if (this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf + 1) * cacheSize + zo + cacheHalf] == -2) {
                                    this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf + 1) * cacheSize + zo + cacheHalf] = distancePass;
                                }
                                if (this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + (zo + cacheHalf - 1)] == -2) {
                                    this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + (zo + cacheHalf - 1)] = distancePass;
                                }
                                if (this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf + 1] != -2) continue;
                                this.decayBlockCache[(xo + cacheHalf) * cacheSquared + (yo + cacheHalf) * cacheSize + zo + cacheHalf + 1] = distancePass;
                            }
                        }
                    }
                }
            }
            if ((distanceToLog = this.decayBlockCache[cacheHalf * cacheSquared + cacheHalf * cacheSize + cacheHalf]) >= 0) {
                world.func_72921_c(x, y, z, blockMeta & 0xFFFFFFF7, 4);
            } else {
                this.removeLeaves(world, x, y, z);
            }
        }
    }

    private void removeLeaves(World world, int x, int y, int z) {
        this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
        world.func_147468_f(x, y, z);
    }
}

