/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.terrain;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.BLFluidRegistry;
import thebetweenlands.entities.mobs.EntityTarBeast;
import thebetweenlands.items.BLMaterial;

public class BlockTarFluid
extends BlockFluidClassic {
    @SideOnly(value=Side.CLIENT)
    protected IIcon stillIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon flowingIcon;

    public BlockTarFluid() {
        super(BLFluidRegistry.tarFluid, BLMaterial.tar);
        this.func_149663_c("thebetweenlands.tarFluid");
    }

    public IIcon func_149691_a(int side, int meta) {
        return side == 0 || side == 1 ? this.stillIcon : this.flowingIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.stillIcon = register.func_94245_a("thebetweenlands:tar");
        this.flowingIcon = register.func_94245_a("thebetweenlands:tarFlowing");
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return false;
        }
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return false;
        }
        return super.displaceIfPossible(world, x, y, z);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (entity instanceof EntityLivingBase && !(entity instanceof EntityTarBeast)) {
            Block blockAbove;
            entity.field_70159_w *= 0.005;
            entity.field_70179_y *= 0.005;
            if (entity.field_70181_x < 0.0) {
                entity.field_70181_x *= 0.005;
            }
            if ((blockAbove = world.func_147439_a(x, y + 1, z)).func_149688_o() == BLMaterial.tar && entity.func_70055_a(BLMaterial.tar)) {
                ((EntityLivingBase)entity).func_70097_a(DamageSource.field_76369_e, 2.0f);
            }
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.solidifyTar(world, x, y, z);
        super.func_149726_b(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.solidifyTar(world, x, y, z);
        super.func_149695_a(world, x, y, z, block);
    }

    private void solidifyTar(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) == this) {
            boolean placeTar = false;
            if (!placeTar && world.func_147439_a(x, y, z - 1).func_149688_o() == Material.field_151586_h) {
                placeTar = true;
            }
            if (!placeTar && world.func_147439_a(x, y, z + 1).func_149688_o() == Material.field_151586_h) {
                placeTar = true;
            }
            if (!placeTar && world.func_147439_a(x - 1, y, z).func_149688_o() == Material.field_151586_h) {
                placeTar = true;
            }
            if (!placeTar && world.func_147439_a(x + 1, y, z).func_149688_o() == Material.field_151586_h) {
                placeTar = true;
            }
            if (!placeTar && world.func_147439_a(x, y + 1, z).func_149688_o() == Material.field_151586_h) {
                placeTar = true;
            }
            if (!placeTar && world.func_147439_a(x, y - 1, z).func_149688_o() == Material.field_151586_h) {
                world.func_147449_b(x, y - 1, z, BLBlockRegistry.solidTar);
            }
            if (placeTar) {
                world.func_147449_b(x, y, z, BLBlockRegistry.solidTar);
                if (world.field_72995_K) {
                    this.playEffects(world, x, y, z);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void playEffects(World world, int x, int y, int z) {
        world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.fizz", 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        for (int l = 0; l < 8; ++l) {
            world.func_72869_a("largesmoke", (double)x + Math.random(), (double)y + 1.2, (double)z + Math.random(), 0.0, 0.0, 0.0);
        }
    }
}

