/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.terrain;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.BLFluidRegistry;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.client.render.block.water.IWaterRenderer;
import thebetweenlands.items.armor.ItemImprovedRubberBoots;
import thebetweenlands.proxy.ClientProxy;

public class BlockSwampWater
extends BlockFluidClassic {
    private static final int DEEP_COLOR_R = 19;
    private static final int DEEP_COLOR_G = 24;
    private static final int DEEP_COLOR_B = 68;
    @SideOnly(value=Side.CLIENT)
    protected IIcon stillIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon flowingIcon;
    protected boolean canSpread = true;
    protected boolean hasBoundingBox = false;
    protected boolean canCollide = false;
    protected boolean canReplenish = true;
    private static final HashMap<Block, IWaterRenderer> SPECIAL_RENDERERS = new HashMap();

    public BlockSwampWater(Fluid fluid, Material material) {
        super(fluid, material);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        this.func_149663_c("thebetweenlands.swampWater");
        this.setMaxScaledLight(0);
    }

    public BlockSwampWater() {
        this(BLFluidRegistry.swampWater, Material.field_151586_h);
    }

    public BlockSwampWater setSpecialRenderer(IWaterRenderer renderer) {
        SPECIAL_RENDERERS.put((Block)this, renderer);
        return this;
    }

    public IWaterRenderer getSpecialRenderer() {
        if (SPECIAL_RENDERERS.containsKey((Object)this)) {
            return SPECIAL_RENDERERS.get((Object)this);
        }
        return null;
    }

    public IIcon func_149691_a(int side, int meta) {
        IWaterRenderer renderer = this.getSpecialRenderer();
        if (renderer != null) {
            return renderer.getIcon();
        }
        return side == 0 || side == 1 ? this.stillIcon : this.flowingIcon;
    }

    public IIcon getWaterIcon(int side) {
        return side == 0 || side == 1 ? this.stillIcon : this.flowingIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.stillIcon = register.func_94245_a("thebetweenlands:swampWater");
        this.flowingIcon = register.func_94245_a("thebetweenlands:swampWaterFlowing");
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).isAir(world, x, y, z) || !this.canSpread) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (this.canConnectTo(block)) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            return (Boolean)this.displacements.get(block);
        }
        Material material = block.func_149688_o();
        if (material.func_76230_c() || material == Material.field_151567_E) {
            return false;
        }
        int density = BlockSwampWater.getDensity((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess blockAccess, int x, int y, int z) {
        int r = 0;
        int g = 0;
        int b = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                int colorMultiplier = blockAccess.func_72807_a(x + dz, z + dx).getWaterColorMultiplier();
                r += (colorMultiplier & 0xFF0000) >> 16;
                g += (colorMultiplier & 0xFF00) >> 8;
                b += colorMultiplier & 0xFF;
            }
        }
        r /= 9;
        g /= 9;
        b /= 9;
        float depth = 0.0f;
        depth = y > 70 ? 1.0f : (y < 20 ? 0.0f : (float)(y - 20) / 50.0f);
        r = (int)((float)r * depth + 19.0f * (1.0f - depth) + 0.5f);
        g = (int)((float)g * depth + 24.0f * (1.0f - depth) + 0.5f);
        b = (int)((float)b * depth + 68.0f * (1.0f - depth) + 0.5f);
        return r << 16 | g << 8 | b;
    }

    public boolean isFlowingVertically(IBlockAccess world, int x, int y, int z) {
        return this.canConnectTo(world.func_147439_a(x, y + this.densityDir, z)) || this.canConnectTo(world.func_147439_a(x, y, z)) && this.canFlowInto(world, x, y + this.densityDir, z);
    }

    public boolean isSourceBlock(IBlockAccess world, int x, int y, int z) {
        return this.canConnectTo(world.func_147439_a(x, y, z)) && world.func_72805_g(x, y, z) == 0;
    }

    protected boolean canFlowInto(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).isAir(world, x, y, z)) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (this.canConnectTo(block)) {
            return true;
        }
        if (this.displacements.containsKey(block)) {
            return (Boolean)this.displacements.get(block);
        }
        Material material = block.func_149688_o();
        if (material.func_76230_c() || material == Material.field_151586_h || material == Material.field_151587_i || material == Material.field_151567_E) {
            return false;
        }
        int density = BlockSwampWater.getDensity((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (density == Integer.MAX_VALUE) {
            return true;
        }
        return this.density > density;
    }

    protected void flowIntoBlock(World world, int x, int y, int z, int meta) {
        if (!this.canSpread) {
            return;
        }
        if (meta < 0) {
            return;
        }
        if (this.displaceIfPossible(world, x, y, z) && this.canSpread) {
            world.func_147465_d(x, y, z, (Block)this, meta, 3);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!this.canSpread) {
            return;
        }
        if (this.canReplenish && !world.func_147437_c(x, y - 1, z)) {
            int adjacentSources = 0;
            if (this.isSourceBlock((IBlockAccess)world, x + 1, y, z)) {
                ++adjacentSources;
            }
            if (this.isSourceBlock((IBlockAccess)world, x - 1, y, z)) {
                ++adjacentSources;
            }
            if (this.isSourceBlock((IBlockAccess)world, x, y, z + 1)) {
                ++adjacentSources;
            }
            if (this.isSourceBlock((IBlockAccess)world, x, y, z - 1)) {
                ++adjacentSources;
            }
            if (adjacentSources >= 2) {
                world.func_72921_c(x, y, z, 0, 2);
            }
        }
        int quantaRemaining = this.quantaPerBlock - world.func_72805_g(x, y, z);
        int expQuanta = -101;
        if (quantaRemaining < this.quantaPerBlock) {
            int y2 = y - this.densityDir;
            if (this.canConnectTo(world.func_147439_a(x, y2, z)) || this.canConnectTo(world.func_147439_a(x - 1, y2, z)) || this.canConnectTo(world.func_147439_a(x + 1, y2, z)) || this.canConnectTo(world.func_147439_a(x, y2, z - 1)) || this.canConnectTo(world.func_147439_a(x, y2, z + 1))) {
                expQuanta = this.quantaPerBlock - 1;
            } else {
                int maxQuanta = -100;
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x - 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x + 1, y, z, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x, y, z - 1, maxQuanta);
                maxQuanta = this.getLargerQuanta((IBlockAccess)world, x, y, z + 1, maxQuanta);
                expQuanta = maxQuanta - 1;
            }
            if (expQuanta != quantaRemaining) {
                quantaRemaining = expQuanta;
                if (expQuanta <= 0) {
                    world.func_147449_b(x, y, z, Blocks.field_150350_a);
                } else {
                    world.func_72921_c(x, y, z, this.quantaPerBlock - expQuanta, 3);
                    world.func_147464_a(x, y, z, (Block)this, this.tickRate);
                    world.func_147459_d(x, y, z, (Block)this);
                }
            }
        } else if (quantaRemaining >= this.quantaPerBlock) {
            world.func_72921_c(x, y, z, 0, 2);
        }
        if (this.canDisplace((IBlockAccess)world, x, y + this.densityDir, z)) {
            this.flowIntoBlock(world, x, y + this.densityDir, z, 1);
            return;
        }
        int flowMeta = this.quantaPerBlock - quantaRemaining + 1;
        if (flowMeta >= this.quantaPerBlock) {
            return;
        }
        if (this.isSourceBlock((IBlockAccess)world, x, y, z) || !this.isFlowingVertically((IBlockAccess)world, x, y, z)) {
            boolean[] flowTo;
            if (this.canConnectTo(world.func_147439_a(x, y - this.densityDir, z))) {
                flowMeta = 1;
            }
            if ((flowTo = this.getOptimalFlowDirections(world, x, y, z))[0]) {
                this.flowIntoBlock(world, x - 1, y, z, flowMeta);
            }
            if (flowTo[1]) {
                this.flowIntoBlock(world, x + 1, y, z, flowMeta);
            }
            if (flowTo[2]) {
                this.flowIntoBlock(world, x, y, z - 1, flowMeta);
            }
            if (flowTo[3]) {
                this.flowIntoBlock(world, x, y, z + 1, flowMeta);
            }
        }
    }

    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        Block block = world.func_147439_a(x, y, z);
        if (side == 0 && block != BLBlockRegistry.swampWater) {
            return true;
        }
        if (!this.canConnectTo(block)) {
            if (side == 1) {
                return true;
            }
            return !block.func_149662_c() && !block.isSideSolid(world, x, y, z, ForgeDirection.getOrientation((int)side));
        }
        return block.func_149688_o() == this.func_149688_o() || this.canConnectTo(block) ? false : super.func_149646_a(world, x, y, z, side);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (!this.canSpread) {
            return false;
        }
        if (world.func_147439_a(x, y, z).isAir((IBlockAccess)world, x, y, z)) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        if (this.canConnectTo(block)) {
            return false;
        }
        if (this.displacements.containsKey(block)) {
            if (((Boolean)this.displacements.get(block)).booleanValue()) {
                block.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                return true;
            }
            return false;
        }
        Material material = block.func_149688_o();
        if (material.func_76230_c() || material == Material.field_151567_E) {
            return false;
        }
        int density = BlockSwampWater.getDensity((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (density == Integer.MAX_VALUE) {
            block.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            return true;
        }
        return this.density > density;
    }

    public Vec3 getFlowVector(IBlockAccess world, int x, int y, int z) {
        if (!this.canSpread) {
            return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        }
        Vec3 vec = Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
        int decay = this.quantaPerBlock - this.getQuantaValue(world, x, y, z);
        for (int side = 0; side < 4; ++side) {
            int power;
            int x2 = x;
            int z2 = z;
            switch (side) {
                case 0: {
                    --x2;
                    break;
                }
                case 1: {
                    --z2;
                    break;
                }
                case 2: {
                    ++x2;
                    break;
                }
                case 3: {
                    ++z2;
                }
            }
            Block otherBlock = world.func_147439_a(x2, y, z2);
            if (!(otherBlock instanceof BlockSwampWater) || !((BlockSwampWater)otherBlock).canSpread) continue;
            int otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x2, y, z2);
            if (otherDecay >= this.quantaPerBlock) {
                if (world.func_147439_a(x2, y, z2).func_149688_o().func_76230_c() || this.canConnectTo(world.func_147439_a(x2, y, z2)) || (otherDecay = this.quantaPerBlock - this.getQuantaValue(world, x2, y - 1, z2)) < 0) continue;
                power = otherDecay - (decay - this.quantaPerBlock);
                vec = vec.func_72441_c((double)((x2 - x) * power), (double)((y - y) * power), (double)((z2 - z) * power));
                continue;
            }
            if (otherDecay < 0) continue;
            power = otherDecay - decay;
            vec = vec.func_72441_c((double)((x2 - x) * power), (double)((y - y) * power), (double)((z2 - z) * power));
        }
        if (this.canConnectTo(world.func_147439_a(x, y + 1, z))) {
            boolean flag;
            boolean bl = flag = this.func_149747_d(world, x, y, z - 1, 2) || this.func_149747_d(world, x, y, z + 1, 3) || this.func_149747_d(world, x - 1, y, z, 4) || this.func_149747_d(world, x + 1, y, z, 5) || this.func_149747_d(world, x, y + 1, z - 1, 2) || this.func_149747_d(world, x, y + 1, z + 1, 3) || this.func_149747_d(world, x - 1, y + 1, z, 4) || this.func_149747_d(world, x + 1, y + 1, z, 5);
            if (flag) {
                vec = vec.func_72432_b().func_72441_c(0.0, -6.0, 0.0);
            }
        }
        vec = vec.func_72432_b();
        return vec;
    }

    public int getQuantaValue(IBlockAccess world, int x, int y, int z) {
        if (this.canSpread) {
            return super.getQuantaValue(world, x, y, z);
        }
        return this.quantaPerBlock;
    }

    public int func_149645_b() {
        return ClientProxy.BlockRenderIDs.SWAMP_WATER.id();
    }

    public boolean func_149678_a(int meta, boolean fullHit) {
        return this.hasBoundingBox || fullHit && (!this.canSpread || meta == 0);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB bb, List bbList, Entity entity) {
        AxisAlignedBB blockBB;
        if (this.canCollide) {
            AxisAlignedBB blockBB2 = this.func_149668_a(world, x, y, z);
            if (blockBB2 != null && bb.func_72326_a(blockBB2)) {
                bbList.add(blockBB2);
            }
        } else if (entity instanceof EntityPlayer && ItemImprovedRubberBoots.checkPlayerEffect((EntityPlayer)entity) && (blockBB = AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)((float)y + (float)this.getQuantaValue((IBlockAccess)world, x, y, z) / (float)this.quantaPerBlock * 0.8f), (double)(z + 1))) != null && bb.func_72326_a(blockBB)) {
            bbList.add(blockBB);
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        if (this.canCollide) {
            return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
        }
        return null;
    }

    public boolean func_149703_v() {
        return this.canCollide;
    }

    public boolean canConnectTo(Block block) {
        return block == this || block == BLBlockRegistry.swampWater || block instanceof BlockSwampWater || SPECIAL_RENDERERS.containsKey(block);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (rand.nextInt(2500) == 0) {
            if (world.func_147439_a(x, y + 2, z) == BLBlockRegistry.swampWater) {
                BLParticle.FISH.spawn(world, x, y, z);
            } else if (world.func_147439_a(x, y - 1, z) == BLBlockRegistry.mud) {
                if (rand.nextInt(2) == 0) {
                    BLParticle.MOSQUITO.spawn(world, x, (double)y + 1.5, z);
                } else {
                    BLParticle.FLY.spawn(world, x, (double)y + 1.5, z);
                }
            }
        }
    }
}

