/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.terrain;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.plants.crops.BlockBLGenericCrop;
import thebetweenlands.blocks.terrain.BlockSwampWater;
import thebetweenlands.creativetabs.BLCreativeTabs;
import thebetweenlands.world.WorldProviderBetweenlands;
import thebetweenlands.world.events.EnvironmentEventRegistry;

public class BlockPuddle
extends Block {
    public BlockPuddle() {
        super(Material.field_151578_c);
        this.func_149711_c(0.1f);
        this.func_149647_a(BLCreativeTabs.blocks);
        this.func_149663_c("thebetweenlands.puddle");
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.07f, 1.0f);
        this.func_149675_a(true);
        this.func_149658_d("thebetweenlands:betweenstone");
    }

    public void func_149674_a(World world, int x, int y, int z, Random rnd) {
        if (!world.field_72995_K) {
            if (world.field_73011_w instanceof WorldProviderBetweenlands) {
                WorldProviderBetweenlands provider = (WorldProviderBetweenlands)world.field_73011_w;
                EnvironmentEventRegistry eeRegistry = provider.getWorldData().getEnvironmentEventRegistry();
                if (!eeRegistry.HEAVY_RAIN.isActive()) {
                    world.func_147449_b(x, y, z, Blocks.field_150350_a);
                } else if (world.func_72937_j(x, y, z)) {
                    world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) + rnd.nextInt(6), 2);
                }
            } else {
                world.func_147449_b(x, y, z, Blocks.field_150350_a);
            }
            if (world.func_72805_g(x, y, z) > 2) {
                world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) - 3, 2);
                for (int xo = -1; xo <= 1; ++xo) {
                    for (int zo = -1; zo <= 1; ++zo) {
                        if (xo == 0 && zo == 0 || xo * xo == zo * zo) continue;
                        if ((world.func_147437_c(x + xo, y, z + zo) || world.func_147439_a(x + xo, y, z + zo) instanceof BlockBLGenericCrop) && BLBlockRegistry.puddle.func_149742_c(world, x + xo, y, z + zo)) {
                            world.func_147449_b(x + xo, y, z + zo, BLBlockRegistry.puddle);
                            continue;
                        }
                        if (world.func_147439_a(x + xo, y, z + zo) != BLBlockRegistry.puddle) continue;
                        world.func_72921_c(x + xo, y, z + zo, world.func_72805_g(x + xo, y, z + zo) + rnd.nextInt(6), 2);
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        if (blockAccess.func_147439_a(x, y, z) == this) {
            return false;
        }
        return super.func_149646_a(blockAccess, x, y, z, side);
    }

    public boolean func_149662_c() {
        return false;
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return null;
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z)) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        }
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_) {
        return ((BlockSwampWater)BLBlockRegistry.swampWater).stillIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess blockAccess, int x, int y, int z) {
        int avgRed = 0;
        int avgGreen = 0;
        int avgBlue = 0;
        for (int xOff = -1; xOff <= 1; ++xOff) {
            for (int yOff = -1; yOff <= 1; ++yOff) {
                int colorMultiplier = blockAccess.func_72807_a(x + yOff, z + xOff).getWaterColorMultiplier();
                avgRed += (colorMultiplier & 0xFF0000) >> 16;
                avgGreen += (colorMultiplier & 0xFF00) >> 8;
                avgBlue += colorMultiplier & 0xFF;
            }
        }
        return (avgRed / 9 & 0xFF) << 16 | (avgGreen / 9 & 0xFF) << 8 | avgBlue / 9 & 0xFF;
    }

    public boolean func_149678_a(int meta, boolean fullHit) {
        return false;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149703_v() {
        return false;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return true;
    }
}

