/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.terrain;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.plants.crops.BlockBLGenericCrop;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.creativetabs.BLCreativeTabs;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.block.ItemBlockGeneric;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.items.tools.ItemSpadeBL;
import thebetweenlands.proxy.ClientProxy;

public class BlockFarmedDirt
extends Block
implements BLBlockRegistry.ISubBlocksBlock {
    public static final String[] iconPaths = new String[]{"purifiedSwampDirt", "dugSwampDirt", "dugSwampGrass", "dugPurifiedSwampDirt", "fertDirt", "fertGrass", "fertPurifiedSwampDirt", "fertDirtDecayed", "fertGrassDecayed"};
    public static final int PURE_SWAMP_DIRT = 0;
    public static final int DUG_SWAMP_DIRT = 1;
    public static final int DUG_SWAMP_GRASS = 2;
    public static final int DUG_PURE_SWAMP_DIRT = 3;
    public static final int FERT_DIRT = 4;
    public static final int FERT_GRASS = 5;
    public static final int FERT_PURE_SWAMP_DIRT_MIN = 6;
    public static final int FERT_DIRT_DECAYED = 7;
    public static final int FERT_GRASS_DECAYED = 8;
    public static final int FERT_PURE_SWAMP_DIRT_MID = 9;
    public static final int FERT_PURE_SWAMP_DIRT_MAX = 10;
    public static final int COMPOSTING_MODIFIER = 3;
    public static final int DECAY_CURE = 3;
    public static final int DECAY_CAUSE = 3;
    public static final int DECAY_CHANCE = 180;
    public static final int INFECTION_CHANCE = 6;
    public static final int DUG_SOIL_REVERT_CHANCE = 12;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconPureSwampDirt;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconDugSwampGrassMap;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconDugSwampDirtMap;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconDugPurifiedSwampDirtMap;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconCompostedSwampGrassMap;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconCompostedSwampDirtMap;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconCompostedPurifiedSwampDirtMap;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconDecayedSwampGrassMap;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconDecayedSwampDirtMap;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconDecayedPurifiedSwampDirtMap;

    public BlockFarmedDirt() {
        super(Material.field_151578_c);
        this.func_149711_c(0.5f);
        this.func_149672_a(field_149767_g);
        this.setHarvestLevel("shovel", 0);
        this.func_149647_a(BLCreativeTabs.blocks);
        this.func_149663_c("thebetweenlands.farmedDirt");
        this.func_149675_a(true);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int metadata, float hitX, float hitY, float hitZ) {
        int meta = this.func_149643_k(world, x, y, z);
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b() instanceof ItemSpadeBL) {
            if (!world.field_72995_K && meta == 0) {
                world.func_72921_c(x, y, z, 3, 3);
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.field_149762_H.func_150498_e(), (this.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.field_149762_H.func_150494_d() * 0.8f);
                world.func_72889_a(null, 2001, x, y + 1, z, Block.func_149682_b((Block)world.func_147439_a(x, y, z)));
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            return true;
        }
        if (stack != null && stack.func_77973_b() == BLItemRegistry.itemsGeneric && stack.func_77960_j() == ItemGeneric.EnumItemGeneric.COMPOST.id) {
            if (!world.field_72995_K) {
                if (meta == 1 || meta == 2) {
                    world.func_72921_c(x, y, z, meta + 3, 3);
                    this.playCompostEffects(world, x, y, z);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                }
                if (meta == 3) {
                    world.func_72921_c(x, y, z, 10, 3);
                    this.playCompostEffects(world, x, y, z);
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                }
            }
            return true;
        }
        if (stack != null && stack.func_77973_b() == BLItemRegistry.itemsGeneric && stack.func_77960_j() == ItemGeneric.EnumItemGeneric.PLANT_TONIC.id) {
            if (!world.field_72995_K) {
                for (int xo = -1; xo <= 1; ++xo) {
                    for (int zo = -1; zo <= 1; ++zo) {
                        if (!(world.func_147439_a(x + xo, y, z + zo) instanceof BlockFarmedDirt)) continue;
                        ((BlockFarmedDirt)world.func_147439_a(x + xo, y, z + zo)).setDecayed(world, x + xo, y, z + zo, false);
                    }
                }
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
                if (!player.field_71071_by.func_70441_a(new ItemStack(BLItemRegistry.weedwoodBucket))) {
                    player.func_71019_a(new ItemStack(BLItemRegistry.weedwoodBucket), false);
                }
            }
            return true;
        }
        return false;
    }

    public void setDecayed(World world, int x, int y, int z, boolean decayed) {
        if (!decayed) {
            int currentMeta = world.func_72805_g(x, y, z);
            if (currentMeta == 7 || currentMeta == 8) {
                world.func_72921_c(x, y, z, currentMeta - 3, 3);
            }
            if (world.func_147439_a(x, y + 1, z) instanceof BlockBLGenericCrop && world.func_72805_g(x, y + 1, z) == 8) {
                ((BlockBLGenericCrop)world.func_147439_a(x, y + 1, z)).setDecayed(world, x, y + 1, z, false);
            }
        } else {
            int currentMeta = world.func_72805_g(x, y, z);
            if (currentMeta == 4 || currentMeta == 5) {
                world.func_72921_c(x, y, z, currentMeta + 3, 3);
            }
            if (world.func_147439_a(x, y + 1, z) instanceof BlockBLGenericCrop && world.func_72805_g(x, y + 1, z) == 7) {
                ((BlockBLGenericCrop)world.func_147439_a(x, y + 1, z)).setDecayed(world, x, y + 1, z, true);
            }
        }
    }

    public void playCompostEffects(World world, int x, int y, int z) {
        world.func_72926_e(2005, x, y + 1, z, 0);
        world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), this.field_149762_H.func_150498_e(), (this.field_149762_H.func_150497_c() + 1.0f) / 2.0f, this.field_149762_H.func_150494_d() * 0.8f);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (meta == 0 || meta == 3 || meta == 6 || meta == 9 || meta == 10) {
            drops.add(new ItemStack(Item.func_150898_a((Block)this), 1, 0));
        }
        if (meta == 1 || meta == 4 || meta == 7 || meta == 2 || meta == 5 || meta == 8) {
            drops.add(new ItemStack(Item.func_150898_a((Block)BLBlockRegistry.swampDirt), 1, 0));
        }
        return drops;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        int meta = this.func_149643_k(world, x, y, z);
        if (meta != 6 && meta != 9 && meta != 10 && this.shouldDecay(world, x, y, z)) {
            this.setDecayed(world, x, y, z, true);
        }
        if (BlockFarmedDirt.isDecayed(meta) && rand.nextInt(6) == 0) {
            for (int xo = -1; xo <= 1; ++xo) {
                for (int zo = -1; zo <= 1; ++zo) {
                    if (xo == 0 && zo == 0 || zo != 0 && xo != 0 || rand.nextInt(3) != 0) continue;
                    Block adjacentBlock = world.func_147439_a(x + xo, y, z + zo);
                    int adjacentMeta = world.func_72805_g(x + xo, y, z + zo);
                    if (!(adjacentBlock instanceof BlockFarmedDirt)) continue;
                    ((BlockFarmedDirt)adjacentBlock).setDecayed(world, x + xo, y, z + zo, true);
                }
            }
        }
        if (world.field_73012_v.nextInt(12) == 0) {
            if (meta == 1 || meta == 3) {
                world.func_147465_d(x, y, z, BLBlockRegistry.swampDirt, 0, 3);
            }
            if (meta == 2) {
                world.func_147465_d(x, y, z, BLBlockRegistry.swampGrass, 0, 3);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.iconPureSwampDirt = reg.func_94245_a("thebetweenlands:dugDirt/purifiedSwampDirt");
        this.iconDugSwampGrassMap = reg.func_94245_a("thebetweenlands:dugDirt/dugSwampGrassMap");
        this.iconDugSwampDirtMap = reg.func_94245_a("thebetweenlands:dugDirt/dugSwampDirtMap");
        this.iconDugPurifiedSwampDirtMap = reg.func_94245_a("thebetweenlands:dugDirt/dugPurifiedSwampDirtMap");
        this.iconCompostedSwampGrassMap = reg.func_94245_a("thebetweenlands:dugDirt/fertSwampGrassMap");
        this.iconCompostedSwampDirtMap = reg.func_94245_a("thebetweenlands:dugDirt/fertSwampDirtMap");
        this.iconCompostedPurifiedSwampDirtMap = reg.func_94245_a("thebetweenlands:dugDirt/fertPurifiedSwampDirtMap");
        this.iconDecayedSwampGrassMap = reg.func_94245_a("thebetweenlands:dugDirt/decayedSwampGrassMap");
        this.iconDecayedSwampDirtMap = reg.func_94245_a("thebetweenlands:dugDirt/decayedSwampDirtMap");
        this.iconDecayedPurifiedSwampDirtMap = reg.func_94245_a("thebetweenlands:dugDirt/decayedPurifiedSwampDirtMap");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (meta) {
            case 0: {
                return this.iconPureSwampDirt;
            }
            case 3: {
                return side == 1 ? this.iconDugPurifiedSwampDirtMap : this.iconPureSwampDirt;
            }
            case 6: 
            case 9: 
            case 10: {
                return side == 1 ? this.iconCompostedPurifiedSwampDirtMap : this.iconPureSwampDirt;
            }
            case 1: {
                return side == 1 ? this.iconDugSwampDirtMap : BLBlockRegistry.swampDirt.func_149691_a(side, 0);
            }
            case 4: {
                return side == 1 ? this.iconCompostedSwampDirtMap : BLBlockRegistry.swampDirt.func_149691_a(side, 0);
            }
            case 7: {
                return side == 1 ? this.iconDecayedSwampDirtMap : BLBlockRegistry.swampDirt.func_149691_a(side, 0);
            }
            case 2: {
                return side == 1 ? this.iconDugSwampGrassMap : BLBlockRegistry.swampGrass.func_149691_a(side, 0);
            }
            case 5: {
                return side == 1 ? this.iconCompostedSwampGrassMap : BLBlockRegistry.swampGrass.func_149691_a(side, 0);
            }
            case 8: {
                return side == 1 ? this.iconDecayedSwampGrassMap : BLBlockRegistry.swampGrass.func_149691_a(side, 0);
            }
        }
        return BLBlockRegistry.swampDirt.func_149691_a(side, 0);
    }

    public void useCompost(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) == this) {
            int metaDirt = world.func_72805_g(x, y, z);
            switch (metaDirt) {
                case 10: {
                    world.func_72921_c(x, y, z, 9, 3);
                    break;
                }
                case 9: {
                    world.func_72921_c(x, y, z, 6, 3);
                    break;
                }
                case 6: {
                    world.func_72921_c(x, y, z, 1, 3);
                    break;
                }
                case 8: {
                    world.func_72921_c(x, y, z, 2, 3);
                    break;
                }
                case 7: {
                    world.func_72921_c(x, y, z, 1, 3);
                    break;
                }
                case 5: {
                    world.func_72921_c(x, y, z, 2, 3);
                    break;
                }
                case 4: {
                    world.func_72921_c(x, y, z, 1, 3);
                }
            }
        }
    }

    public boolean shouldDecay(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y + 1, z) instanceof BlockBLGenericCrop) {
            return ((BlockBLGenericCrop)world.func_147439_a(x, y + 1, z)).shouldDecay(world, x, y + 1, z);
        }
        return world.field_73012_v.nextInt(180) == 0;
    }

    public static boolean isDecayed(int meta) {
        return meta == 8 || meta == 7;
    }

    public static boolean isFertilized(int meta) {
        return meta == 6 || meta == 9 || meta == 10 || meta == 4 || meta == 5;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item id, CreativeTabs tab, List list) {
        for (int i = 0; i < 9; ++i) {
            list.add(new ItemStack(id, 1, i));
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    private Block getCropAboveBlock(World world, int x, int y, int z) {
        return world.func_147439_a(x, y + 1, z);
    }

    private int getCropAboveBlockDamageValue(World world, int x, int y, int z) {
        return world.func_72805_g(x, y + 1, z);
    }

    @Override
    public Class<? extends ItemBlock> getItemBlockClass() {
        return ItemBlockGeneric.class;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        double pixel = 0.0625;
        int meta = this.func_149643_k(world, x, y, z);
        if ((meta == 7 || meta == 8) && rand.nextInt(10) == 0) {
            for (int l = 0; l <= 5; ++l) {
                double particleX = (float)x + rand.nextFloat();
                double particleY = (float)y + rand.nextFloat();
                double particleZ = (float)z + rand.nextFloat();
                if (l == 0 && !world.func_147439_a(x, y + 2, z).func_149662_c()) {
                    particleY = (double)(y + 1) + pixel;
                }
                if (l == 1 && !world.func_147439_a(x, y - 1, z).func_149662_c()) {
                    particleY = (double)y - pixel;
                }
                if (l == 2 && !world.func_147439_a(x, y, z + 1).func_149662_c()) {
                    particleZ = (double)(z + 1) + pixel;
                }
                if (l == 3 && !world.func_147439_a(x, y, z - 1).func_149662_c()) {
                    particleZ = (double)z - pixel;
                }
                if (l == 4 && !world.func_147439_a(x + 1, y, z).func_149662_c()) {
                    particleX = (double)(x + 1) + pixel;
                }
                if (l == 5 && !world.func_147439_a(x - 1, y, z).func_149662_c()) {
                    particleX = (double)x - pixel;
                }
                if (!(particleX < (double)x || particleX > (double)(x + 1) || particleY < (double)y || particleY > (double)(y + 1) || particleZ < (double)z) && !(particleZ > (double)(z + 1))) continue;
                BLParticle.DIRT_DECAY.spawn(world, particleX, particleY, particleZ, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
            }
        }
    }

    public int func_149645_b() {
        return ClientProxy.BlockRenderIDs.FARMED_DIRT.id();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return side == 1 ? false : super.func_149646_a(world, x, y, z, side);
    }
}

