/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.stalactite;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.blocks.stalactite.StalactiteData;
import thebetweenlands.blocks.stalactite.StalactiteHelper;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.proxy.ClientProxy;
import thebetweenlands.utils.Point2D;

public class BlockStalactite
extends Block {
    private static final int TOP = 0;
    private static final int BOTTOM = 1;
    private static final int MIDDLE = 2;
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon bottomIcon;

    public BlockStalactite(Material material) {
        super(material);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 0;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && (this.canPlaceBlockOn(world.func_147439_a(x, y - 1, z)) || this.canPlaceBlockOn(world.func_147439_a(x, y + 1, z)));
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        StalactiteData info = StalactiteData.getData((IBlockAccess)world, x, y, z);
        return !info.noBottom || !info.noTop;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.checkAndDropBlock(world, x, y, z);
    }

    protected void checkAndDropBlock(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            world.func_147444_c(x, y, z, Blocks.field_150350_a);
        }
    }

    protected boolean canPlaceBlockOn(Block block) {
        return block == this || block.func_149662_c();
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.BlockRenderIDs.STALACTITE.id();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a("thebetweenlands:stalacmite_middle");
        this.topIcon = iconRegister.func_94245_a("thebetweenlands:stalacmite_top");
        this.bottomIcon = iconRegister.func_94245_a("thebetweenlands:stalacmite_bottom");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return side == 0 ? this.topIcon : (side == 1 ? this.bottomIcon : this.field_149761_L);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        int md = world.func_72805_g(x, y, z);
        if (md == 1 && random.nextInt(10) == 0) {
            StalactiteHelper core = StalactiteHelper.getValsFor(x, y, z);
            double midHeight = 0.2 + random.nextDouble() * 0.4;
            Point2D mid = core.getMidway(midHeight);
            float dripRange = 0.1f;
            double sx = (double)x + mid.x + (double)StalactiteHelper.randRange(random, -dripRange, dripRange);
            double sy = (double)y + midHeight;
            double sz = (double)z + mid.y + (double)StalactiteHelper.randRange(random, -dripRange, dripRange);
            BLParticle.CAVE_WATER_DRIP.spawn(world, sx, sy, sz);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y - 1, z) == Blocks.field_150350_a) {
            world.func_72921_c(x, y, z, 1, 2);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        this.checkAndDropBlock(world, x, y, z);
        StalactiteData info = StalactiteData.getData((IBlockAccess)world, x, y, z);
        int md = world.func_72805_g(x, y, z);
        if (md == 0 && info.noBottom && info.distDown == 0) {
            world.func_72921_c(x, y, z, 1, 2);
        } else if (!(md != 1 || info.noBottom && info.distDown <= 0)) {
            world.func_72921_c(x, y, z, 0, 2);
        }
    }

    public static boolean renderBlock(Block block, int x, int y, int z, IBlockAccess world) {
        StalactiteData info = StalactiteData.getData(world, x, y, z);
        return BlockStalactite.renderBlock(block, info.posX, info.posY, info.posZ, info.noBottom, info.distDown, info.noTop, info.distUp, block.func_149677_c(world, x, y, z));
    }

    public static boolean renderBlock(Block block, int x, int y, int z, boolean noBottom, int distDown, boolean noTop, int distUp, int brightness) {
        boolean hasBottom;
        float distToMidTop;
        float distToMidBottom;
        double scale;
        int height = 1 + distDown + distUp;
        double exp = 1.2;
        if (noTop) {
            scale = Math.pow(height, exp);
            distToMidBottom = distUp + 1;
            distToMidTop = distUp;
        } else if (noBottom) {
            scale = Math.pow(height, exp);
            distToMidBottom = distDown;
            distToMidTop = distDown + 1;
        } else {
            float halfTotalHeight = (float)height * 0.5f;
            scale = Math.pow(halfTotalHeight, exp);
            distToMidBottom = Math.abs(halfTotalHeight - (float)distUp - 1.0f);
            distToMidTop = Math.abs(halfTotalHeight - (float)distUp);
        }
        int minValBottom = noBottom && distDown == 0 ? 0 : 1;
        int minValTop = noTop && distUp == 0 ? 0 : 1;
        double bottomWidth = (double)((int)(Math.pow(distToMidBottom, exp) / scale * (double)(8 - minValBottom)) + minValBottom) / 16.0;
        double topWidth = (double)((int)(Math.pow(distToMidTop, exp) / scale * (double)(8 - minValTop)) + minValTop) / 16.0;
        boolean hasTop = distUp == 0 && !noTop;
        boolean bl = hasBottom = distDown == 0 && !noBottom;
        int tex = hasTop ? 0 : (hasBottom ? 1 : 2);
        IIcon icon = block.func_149691_a(tex, 0);
        float u1 = icon.func_94209_e();
        float u2 = icon.func_94212_f();
        float v1 = icon.func_94206_g();
        float v2 = icon.func_94210_h();
        double texBottomWidth = bottomWidth * (double)(u2 - u1) * 2.0;
        double texTopWidth = topWidth * (double)(u2 - u1) * 2.0;
        StalactiteHelper core = StalactiteHelper.getValsFor(x, y, z);
        if (hasTop) {
            core.tX = 0.5;
            core.tZ = 0.5;
        }
        if (hasBottom) {
            core.bX = 0.5;
            core.bZ = 0.5;
        }
        Tessellator t = Tessellator.field_78398_a;
        t.func_78380_c(brightness);
        t.func_78370_a(255, 255, 255, 255);
        float nx = 1.0f;
        float ny = (float)(core.tX - topWidth - (core.bX - bottomWidth));
        float nz = 0.0f;
        float length = MathHelper.func_76129_c((float)(1.0f + ny * ny));
        t.func_78375_b(nx /= length, ny /= length, nz);
        t.func_78374_a((double)x + core.bX - bottomWidth, (double)y, (double)z + core.bZ - bottomWidth, (double)u1 + texBottomWidth, (double)v2);
        t.func_78374_a((double)x + core.bX - bottomWidth, (double)y, (double)z + core.bZ + bottomWidth, (double)u1, (double)v2);
        t.func_78374_a((double)x + core.tX - topWidth, (double)(y + 1), (double)z + core.tZ + topWidth, (double)u1, (double)v1);
        t.func_78374_a((double)x + core.tX - topWidth, (double)(y + 1), (double)z + core.tZ - topWidth, (double)u1 + texTopWidth, (double)v1);
        nx = 1.0f;
        ny = -((float)(core.tX + topWidth - (core.bX + bottomWidth)));
        nz = 0.0f;
        length = MathHelper.func_76129_c((float)(1.0f + ny * ny));
        t.func_78375_b(nx /= length, ny /= length, nz);
        t.func_78374_a((double)x + core.bX + bottomWidth, (double)y, (double)z + core.bZ + bottomWidth, (double)u1 + texBottomWidth, (double)v2);
        t.func_78374_a((double)x + core.bX + bottomWidth, (double)y, (double)z + core.bZ - bottomWidth, (double)u1, (double)v2);
        t.func_78374_a((double)x + core.tX + topWidth, (double)(y + 1), (double)z + core.tZ - topWidth, (double)u1, (double)v1);
        t.func_78374_a((double)x + core.tX + topWidth, (double)(y + 1), (double)z + core.tZ + topWidth, (double)u1 + texTopWidth, (double)v1);
        nx = 0.0f;
        ny = (float)(core.tZ - topWidth - (core.bZ - bottomWidth));
        nz = 1.0f;
        length = MathHelper.func_76129_c((float)(1.0f + ny * ny));
        t.func_78375_b(nx, ny /= length, nz /= length);
        t.func_78374_a((double)x + core.bX + bottomWidth, (double)y, (double)z + core.bZ - bottomWidth, (double)u1 + texBottomWidth, (double)v2);
        t.func_78374_a((double)x + core.bX - bottomWidth, (double)y, (double)z + core.bZ - bottomWidth, (double)u1, (double)v2);
        t.func_78374_a((double)x + core.tX - topWidth, (double)(y + 1), (double)z + core.tZ - topWidth, (double)u1, (double)v1);
        t.func_78374_a((double)x + core.tX + topWidth, (double)(y + 1), (double)z + core.tZ - topWidth, (double)u1 + texTopWidth, (double)v1);
        nx = 0.0f;
        ny = -((float)(core.tZ + topWidth - (core.bZ + bottomWidth)));
        nz = 1.0f;
        length = MathHelper.func_76129_c((float)(1.0f + ny * ny));
        t.func_78375_b(nx, ny /= length, nz /= length);
        t.func_78374_a((double)x + core.bX - bottomWidth, (double)y, (double)z + core.bZ + bottomWidth, (double)u1 + texBottomWidth, (double)v2);
        t.func_78374_a((double)x + core.bX + bottomWidth, (double)y, (double)z + core.bZ + bottomWidth, (double)u1, (double)v2);
        t.func_78374_a((double)x + core.tX + topWidth, (double)(y + 1), (double)z + core.tZ + topWidth, (double)u1, (double)v1);
        t.func_78374_a((double)x + core.tX - topWidth, (double)(y + 1), (double)z + core.tZ + topWidth, (double)u1 + texTopWidth, (double)v1);
        icon = block.func_149691_a(2, 0);
        u1 = icon.func_94209_e();
        v1 = icon.func_94206_g();
        if (distUp == 0) {
            t.func_78375_b(0.0f, 1.0f, 0.0f);
            t.func_78374_a((double)x + core.tX - topWidth, (double)(y + 1), (double)z + core.tZ - topWidth, (double)u1, (double)v1);
            t.func_78374_a((double)x + core.tX - topWidth, (double)(y + 1), (double)z + core.tZ + topWidth, (double)u1 + texTopWidth, (double)v1);
            t.func_78374_a((double)x + core.tX + topWidth, (double)(y + 1), (double)z + core.tZ + topWidth, (double)u1 + texTopWidth, (double)v1 + texTopWidth);
            t.func_78374_a((double)x + core.tX + topWidth, (double)(y + 1), (double)z + core.tZ - topWidth, (double)u1, (double)v1 + texTopWidth);
        }
        if (distDown == 0) {
            t.func_78375_b(0.0f, -1.0f, 0.0f);
            t.func_78374_a((double)x + core.bX - bottomWidth, (double)y, (double)z + core.bZ + bottomWidth, (double)u1 + texBottomWidth, (double)v1);
            t.func_78374_a((double)x + core.bX - bottomWidth, (double)y, (double)z + core.bZ - bottomWidth, (double)u1, (double)v1);
            t.func_78374_a((double)x + core.bX + bottomWidth, (double)y, (double)z + core.bZ - bottomWidth, (double)u1, (double)v1 + texBottomWidth);
            t.func_78374_a((double)x + core.bX + bottomWidth, (double)y, (double)z + core.bZ + bottomWidth, (double)u1 + texBottomWidth, (double)v1 + texBottomWidth);
        }
        return true;
    }
}

