/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.plants.roots;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.plants.roots.BlockRootUW;
import thebetweenlands.creativetabs.BLCreativeTabs;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.proxy.ClientProxy;
import thebetweenlands.world.events.impl.EventSpoopy;

public class BlockRoot
extends Block {
    @SideOnly(value=Side.CLIENT)
    public IIcon rootIcon;
    @SideOnly(value=Side.CLIENT)
    public IIcon spoopyRootIcon;

    public BlockRoot() {
        super(Material.field_151575_d);
        this.func_149675_a(true);
        this.func_149647_a(BLCreativeTabs.plants);
        this.func_149711_c(1.0f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149663_c("thebetweenlands.root");
        this.func_149658_d("thebetweenlands:weedwoodBark");
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && this.canPlaceBlockOn(world, world.func_147439_a(x, y - 1, z), x, y - 1, z);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.canPlaceBlockOn(world, world.func_147439_a(x, y - 1, z), x, y - 1, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        this.checkAndDropBlock(world, x, y, z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.checkAndDropBlock(world, x, y, z);
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.TANGLED_ROOT).func_77960_j();
    }

    public int func_149745_a(Random rnd) {
        return 1;
    }

    public int func_149692_a(int p_149692_1_) {
        return ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.TANGLED_ROOT).func_77960_j();
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.TANGLED_ROOT).func_77973_b();
    }

    protected void checkAndDropBlock(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            world.func_147444_c(x, y, z, Blocks.field_150350_a);
        }
    }

    protected boolean canPlaceBlockOn(World world, Block block, int x, int y, int z) {
        return block instanceof BlockRootUW || block == this || block.isSideSolid((IBlockAccess)world, x, y, z, ForgeDirection.UP);
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.BlockRenderIDs.ROOT.id();
    }

    public boolean isWood(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149637_q() {
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return false;
    }

    public static void generateWaterRootPatch(World world, int x, int y, int z, int tries, int radius) {
        for (int i = 0; i < tries; ++i) {
            int bz;
            int by;
            int bx = x + world.field_73012_v.nextInt(radius) - radius / 2;
            if (!(Math.sqrt((bx - x) * (bx - x) + ((by = y + world.field_73012_v.nextInt(radius) - radius / 2) - y) * (by - y) + ((bz = z + world.field_73012_v.nextInt(radius) - radius / 2) - z) * (bz - z)) <= (double)radius)) continue;
            Block cBlock = world.func_147439_a(bx, by, bz);
            Block blockAbove = world.func_147439_a(bx, by + 1, bz);
            Block blockAbove2 = world.func_147439_a(bx, by + 2, bz);
            if (cBlock != BLBlockRegistry.mud || blockAbove != BLBlockRegistry.swampWater || blockAbove2 != BLBlockRegistry.swampWater) continue;
            BlockRoot.generateRoot(world, bx, by + 1, bz, world.field_73012_v.nextInt(6) + 2);
        }
    }

    public static void generateRootPatch(World world, int x, int y, int z, int tries, int radius) {
        for (int i = 0; i < tries; ++i) {
            boolean hasSpace;
            int bz;
            int by;
            int bx = x + world.field_73012_v.nextInt(radius) - radius / 2;
            if (!(Math.sqrt((bx - x) * (bx - x) + ((by = y + world.field_73012_v.nextInt(radius) - radius / 2) - y) * (by - y) + ((bz = z + world.field_73012_v.nextInt(radius) - radius / 2) - z) * (bz - z)) <= (double)radius)) continue;
            Block cBlock = world.func_147439_a(bx, by, bz);
            Block blockAbove = world.func_147439_a(bx, by + 1, bz);
            Block blockAbove2 = world.func_147439_a(bx, by + 2, bz);
            boolean bl = hasSpace = blockAbove == Blocks.field_150350_a && blockAbove2 == Blocks.field_150350_a;
            if (cBlock != BLBlockRegistry.swampGrass && cBlock != BLBlockRegistry.deadGrass && cBlock != BLBlockRegistry.mud || !hasSpace) continue;
            BlockRoot.generateRoot(world, bx, by + 1, bz, world.field_73012_v.nextInt(6) + 2);
        }
    }

    public static void generateRoot(World world, int x, int y, int z, int height) {
        if (!world.field_72995_K) {
            Block cBlock;
            for (int yo = 0; yo < height && ((cBlock = world.func_147439_a(x, y + yo, z)) == Blocks.field_150350_a || cBlock == BLBlockRegistry.swampWater); ++yo) {
                if (cBlock == BLBlockRegistry.swampWater) {
                    world.func_147449_b(x, y + yo, z, (Block)BLBlockRegistry.rootUW);
                    continue;
                }
                world.func_147449_b(x, y + yo, z, (Block)BLBlockRegistry.root);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        super.func_149651_a(reg);
        this.rootIcon = reg.func_94245_a("thebetweenlands:root");
        this.spoopyRootIcon = reg.func_94245_a("thebetweenlands:rootSpoopy");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (EventSpoopy.isSpoopy((World)Minecraft.func_71410_x().field_71441_e)) {
            return this.spoopyRootIcon;
        }
        return this.rootIcon;
    }
}

