/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.plants.crops;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import thebetweenlands.blocks.terrain.BlockFarmedDirt;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.client.render.block.crops.CropRenderer;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.proxy.ClientProxy;

public class BlockBLGenericCrop
extends BlockCrops {
    public static final int MATURE_CROP = 7;
    public static final int DECAYED_CROP = 8;
    private int maxHeight = 1;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] cropIconArray;
    @SideOnly(value=Side.CLIENT)
    private CropRenderer cropRenderer;
    private String type;

    public BlockBLGenericCrop(String blockName) {
        this.type = blockName;
        this.func_149663_c("thebetweenlands." + this.type);
    }

    public BlockBLGenericCrop setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    @SideOnly(value=Side.CLIENT)
    public CropRenderer getCropRenderer() {
        return this.cropRenderer;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockBLGenericCrop setCropModels(ModelBase[] models, int[] textureDimensions) {
        this.cropRenderer = new CropRenderer();
        this.cropRenderer.setCropModels(models, textureDimensions);
        return this;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        int i;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ItemStack seedDrop = this.getSeedDrop(world, x, y, z);
        ItemStack cropDrop = this.getCropDrop(world, x, y, z);
        for (i = 0; i < this.getSeedDrops(world, x, y, z, fortune); ++i) {
            ret.add(seedDrop);
        }
        for (i = 0; i < this.getCropDrops(world, x, y, z, fortune); ++i) {
            ret.add(cropDrop);
        }
        return ret;
    }

    public int getSeedDrops(World world, int x, int y, int z, int fortune) {
        return 1 + (this.isMature(world, x, y, z) ? (world.field_73012_v.nextInt(3) == 0 ? 1 : 0) + fortune : 0);
    }

    public int getCropDrops(World world, int x, int y, int z, int fortune) {
        if (this.isMature(world, x, y, z)) {
            return 2 + world.field_73012_v.nextInt(3) + fortune;
        }
        return 0;
    }

    public ItemStack getSeedDrop(World world, int x, int y, int z) {
        return null;
    }

    public ItemStack getCropDrop(World world, int x, int y, int z) {
        return null;
    }

    protected Item func_149866_i() {
        return null;
    }

    protected Item func_149865_P() {
        return null;
    }

    public Item func_149650_a(int meta, Random rand, int amount) {
        return null;
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float chance, int fortune) {
    }

    protected boolean func_149854_a(Block block) {
        if (this.maxHeight > 1 && block instanceof BlockBLGenericCrop && this.isSameCrop(block)) {
            return true;
        }
        return block instanceof BlockFarmedDirt;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        Block soil = world.func_147439_a(x, y - 1, z);
        if (this.maxHeight > 1 && soil instanceof BlockBLGenericCrop && this.isSameCrop(soil)) {
            return ((BlockBLGenericCrop)soil).isFullyGrown(world, x, y - 1, z);
        }
        int meta = world.func_72805_g(x, y - 1, z);
        return soil != null && soil instanceof BlockFarmedDirt && meta >= 4 && meta <= 10;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        int meta = world.func_72805_g(x, y, z);
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b() == BLItemRegistry.itemsGeneric && stack.func_77960_j() == ItemGeneric.EnumItemGeneric.PLANT_TONIC.id) {
            if (!world.field_72995_K) {
                for (int xo = -1; xo <= 1; ++xo) {
                    for (int zo = -1; zo <= 1; ++zo) {
                        Block blockBelow;
                        Block block = world.func_147439_a(x + xo, y, z + zo);
                        if (block instanceof BlockBLGenericCrop) {
                            ((BlockBLGenericCrop)block).setDecayed(world, x + xo, y, z + zo, false);
                        }
                        if (!((blockBelow = world.func_147439_a(x + xo, y - 1, z + zo)) instanceof BlockFarmedDirt)) continue;
                        ((BlockFarmedDirt)blockBelow).setDecayed(world, x + xo, y - 1, z + zo, false);
                    }
                }
                world.func_72926_e(2005, x, y, z, 0);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
                if (!player.field_71071_by.func_70441_a(new ItemStack(BLItemRegistry.weedwoodBucket))) {
                    player.func_71019_a(new ItemStack(BLItemRegistry.weedwoodBucket), false);
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_149851_a(World world, int x, int y, int z, boolean isRemote) {
        int meta = world.func_72805_g(x, y, z);
        return this.maxHeight <= 1 || !this.canGrowTo(world, x, y + 1, z) || this.hasReachedMaxHeight(world, x, y, z) ? meta < 7 : meta <= 7;
    }

    public boolean func_149852_a(World world, Random rand, int x, int y, int z) {
        int chance = this.isCropOrSoilDecayed(world, x, y, z) ? 6 : 3;
        return rand.nextInt(chance * ((int)((double)world.func_72805_g(x, y, z) / 1.6) + 1)) == 0;
    }

    public void func_149863_m(World world, int x, int y, int z) {
        int prevMeta = world.func_72805_g(x, y, z);
        this.preGrow(world, x, y, z, prevMeta);
        int l = world.func_72805_g(x, y, z) + MathHelper.func_76136_a((Random)world.field_73012_v, (int)2, (int)4);
        if (l > 7) {
            l = 7;
        }
        world.func_72921_c(x, y, z, l, 3);
        world.func_72926_e(2005, x, y, z, 0);
        if (this.isCropOrSoilDecayed(world, x, y, z) && this.isFullyGrown(world, x, y, z)) {
            this.setDecayed(world, x, y, z, true);
        }
        this.postGrow(world, x, y, z, prevMeta, world.func_72805_g(x, y, z));
    }

    public boolean isMature(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 7;
    }

    public void func_149681_a(World world, int x, int y, int z, int id, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        if (this.maxHeight > 1 && !player.field_71075_bZ.field_75098_d) {
            Block block;
            for (int yo = 1; yo <= this.maxHeight && (block = world.func_147439_a(x, y + yo, z)) instanceof BlockBLGenericCrop && this.isSameCrop(block); ++yo) {
                ((BlockBLGenericCrop)block).harvestCrop(world, x, y + yo, z, player);
            }
        }
        boolean grown = this.isFullyGrown(world, x, y, z);
        if (!player.field_71075_bZ.field_75098_d) {
            this.harvestCrop(world, x, y, z, player);
        }
        this.destroyCrop(world, x, y, z, world.func_72805_g(x, y, z));
        if (grown && !player.field_71075_bZ.field_75098_d && world.func_147439_a(x, y - 1, z) instanceof BlockFarmedDirt) {
            ((BlockFarmedDirt)world.func_147439_a(x, y - 1, z)).useCompost(world, x, y - 1, z);
        }
        if (this.maxHeight > 1) {
            int yo;
            Block block;
            if (!player.field_71075_bZ.field_75098_d) {
                for (int yo2 = 1; yo2 <= this.maxHeight && (block = world.func_147439_a(x, y - yo2, z)) instanceof BlockBLGenericCrop && this.isSameCrop(block); ++yo2) {
                    ((BlockBLGenericCrop)block).harvestCrop(world, x, y - yo2, z, player);
                }
            }
            for (yo = 1; yo <= this.maxHeight && (block = world.func_147439_a(x, y + yo, z)) instanceof BlockBLGenericCrop && this.isSameCrop(block); ++yo) {
                ((BlockBLGenericCrop)block).destroyCrop(world, x, y + yo, z, world.func_72805_g(x, y + yo, z));
            }
            for (yo = 1; yo <= this.maxHeight && (block = world.func_147439_a(x, y - yo, z)) instanceof BlockBLGenericCrop && this.isSameCrop(block); ++yo) {
                ((BlockBLGenericCrop)block).destroyCrop(world, x, y - yo, z, world.func_72805_g(x, y - yo, z));
                if (player.field_71075_bZ.field_75098_d || !(world.func_147439_a(x, y - yo - 1, z) instanceof BlockFarmedDirt)) continue;
                ((BlockFarmedDirt)world.func_147439_a(x, y - yo - 1, z)).useCompost(world, x, y - yo - 1, z);
            }
        }
    }

    public void harvestCrop(World world, int x, int y, int z, EntityPlayer player) {
        player.func_71064_a(StatList.field_75934_C[BlockBLGenericCrop.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
        if (!world.field_72995_K && !world.restoringBlockSnapshots && world.func_82736_K().func_82766_b("doTileDrops")) {
            ArrayList<ItemStack> drops = this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
            float chance = ForgeEventFactory.fireBlockHarvesting(drops, (World)world, (Block)this, (int)x, (int)y, (int)z, (int)world.func_72805_g(x, y, z), (int)0, (float)1.0f, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack item : drops) {
                if (!(world.field_73012_v.nextFloat() <= chance)) continue;
                float f = 0.7f;
                double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, item);
                entityitem.field_145804_b = 10;
                world.func_72838_d((Entity)entityitem);
            }
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.func_149855_e(world, x, y, z);
        if (this.shouldGrow(world, x, y, z)) {
            int meta;
            int metaDirt = this.getSoilMetadata(world, x, y, z);
            int prevMeta = meta = world.func_72805_g(x, y, z);
            this.preGrow(world, x, y, z, meta);
            if (!this.isFullyGrown(world, x, y, z) && BlockFarmedDirt.isFertilized(metaDirt)) {
                world.func_72921_c(x, y, z, ++meta, 3);
            }
            this.postGrow(world, x, y, z, prevMeta, meta);
        }
    }

    public boolean shouldGrow(World world, int x, int y, int z) {
        return world.field_73012_v.nextInt(3) == 0;
    }

    public boolean shouldDecay(World world, int x, int y, int z) {
        return world.field_73012_v.nextInt(180) == 0;
    }

    public boolean isCropOrSoilDecayed(World world, int x, int y, int z) {
        int meta = this.getSoilMetadata(world, x, y, z);
        if (meta == -1) {
            return false;
        }
        return BlockFarmedDirt.isDecayed(meta) || world.func_72805_g(x, y, z) == 8;
    }

    public int getSoilMetadata(World world, int x, int y, int z) {
        if (this.maxHeight > 1) {
            for (int yo = 1; yo <= this.maxHeight; ++yo) {
                Block block = world.func_147439_a(x, y - yo, z);
                if (!(block instanceof BlockFarmedDirt)) continue;
                return world.func_72805_g(x, y - yo, z);
            }
        }
        return !(world.func_147439_a(x, y - 1, z) instanceof BlockFarmedDirt) ? -1 : world.func_72805_g(x, y - 1, z);
    }

    public boolean isFullyGrown(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) == 7 || world.func_72805_g(x, y, z) == 8;
    }

    public void setDecayed(World world, int x, int y, int z, boolean decayed) {
        if (!decayed) {
            if (world.func_147439_a(x, y, z) instanceof BlockBLGenericCrop && world.func_72805_g(x, y, z) == 8) {
                world.func_72921_c(x, y, z, 7, 2);
                ((BlockBLGenericCrop)world.func_147439_a(x, y, z)).onCured(world, x, y, z);
                world.func_147444_c(x, y, z, world.func_147439_a(x, y, z));
            }
        } else if (world.func_147439_a(x, y, z) instanceof BlockBLGenericCrop && world.func_72805_g(x, y, z) == 7) {
            world.func_72921_c(x, y, z, 8, 2);
            ((BlockBLGenericCrop)world.func_147439_a(x, y, z)).onDecayed(world, x, y, z);
            world.func_147444_c(x, y, z, world.func_147439_a(x, y, z));
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        return this.destroyCrop(world, x, y, z, world.func_72805_g(x, y, z));
    }

    protected void func_149855_e(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            this.destroyCrop(world, x, y, z, world.func_72805_g(x, y, z));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (this.cropRenderer != null || this.field_149761_L == null) {
            if (meta <= 7) {
                if (meta == 6) {
                    meta = 5;
                }
                return this.cropIconArray[meta >> 1];
            }
            return this.cropIconArray[this.cropIconArray.length - 1];
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        if (this.cropRenderer != null || this.field_149768_d == null) {
            this.cropIconArray = new IIcon[5];
            for (int i = 0; i < this.cropIconArray.length; ++i) {
                this.cropIconArray[i] = iconRegister.func_94245_a("thebetweenlands:crops/" + this.type + i);
            }
        } else {
            this.field_149761_L = iconRegister.func_94245_a(this.field_149768_d);
        }
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return this.cropRenderer != null ? ClientProxy.BlockRenderIDs.CROP.id() : 1;
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        double pixel = 0.0625;
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 8 && rand.nextInt(10) == 0) {
            for (int l = 0; l <= 5; ++l) {
                double particleX = (float)x + rand.nextFloat();
                double particleY = (float)y + rand.nextFloat();
                double particleZ = (float)z + rand.nextFloat();
                if (l == 0 && !world.func_147439_a(x, y + 2, z).func_149662_c()) {
                    particleY = (double)(y + 1) + pixel;
                }
                if (l == 1 && !world.func_147439_a(x, y - 1, z).func_149662_c()) {
                    particleY = (double)y - pixel;
                }
                if (l == 2 && !world.func_147439_a(x, y, z + 1).func_149662_c()) {
                    particleZ = (double)(z + 1) + pixel;
                }
                if (l == 3 && !world.func_147439_a(x, y, z - 1).func_149662_c()) {
                    particleZ = (double)z - pixel;
                }
                if (l == 4 && !world.func_147439_a(x + 1, y, z).func_149662_c()) {
                    particleX = (double)(x + 1) + pixel;
                }
                if (l == 5 && !world.func_147439_a(x - 1, y, z).func_149662_c()) {
                    particleX = (double)x - pixel;
                }
                if (!(particleX < (double)x || particleX > (double)(x + 1) || particleY < (double)y || particleY > (double)(y + 1) || particleZ < (double)z) && !(particleZ > (double)(z + 1))) continue;
                BLParticle.DIRT_DECAY.spawn(world, particleX, particleY, particleZ, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        if (this.isFullyGrown(world, x, y, z) && this.isCropOrSoilDecayed(world, x, y, z)) {
            this.setDecayed(world, x, y, z, true);
        }
    }

    protected void onDecayed(World world, int x, int y, int z) {
        Block blockBelow;
        Block blockAbove = world.func_147439_a(x, y + 1, z);
        if (blockAbove instanceof BlockBLGenericCrop) {
            ((BlockBLGenericCrop)blockAbove).setDecayed(world, x, y + 1, z, true);
        }
        if ((blockBelow = world.func_147439_a(x, y - 1, z)) instanceof BlockBLGenericCrop) {
            ((BlockBLGenericCrop)blockBelow).setDecayed(world, x, y - 1, z, true);
        }
    }

    protected void onCured(World world, int x, int y, int z) {
        Block blockBelow;
        Block blockAbove = world.func_147439_a(x, y + 1, z);
        if (blockAbove instanceof BlockBLGenericCrop) {
            ((BlockBLGenericCrop)blockAbove).setDecayed(world, x, y + 1, z, false);
        }
        if ((blockBelow = world.func_147439_a(x, y - 1, z)) instanceof BlockBLGenericCrop) {
            ((BlockBLGenericCrop)blockBelow).setDecayed(world, x, y - 1, z, false);
        }
        if (blockBelow instanceof BlockFarmedDirt) {
            ((BlockFarmedDirt)blockBelow).setDecayed(world, x, y - 1, z, false);
        }
    }

    private void preGrow(World world, int x, int y, int z, int meta) {
        if (this.maxHeight > 1 && meta == 7 && !this.hasReachedMaxHeight(world, x, y, z) && this.canGrowTo(world, x, y + 1, z)) {
            this.onGrow(world, x, y + 1, z);
        }
    }

    public boolean hasReachedMaxHeight(World world, int x, int y, int z) {
        return this.getCropHeight(world, x, y, z) >= this.maxHeight;
    }

    public int getCropHeight(World world, int x, int y, int z) {
        Block below;
        int height = 1;
        for (int yo = 1; yo <= this.maxHeight && (below = world.func_147439_a(x, y - yo, z)) instanceof BlockBLGenericCrop && this.isSameCrop(below); ++yo) {
            ++height;
        }
        return height;
    }

    public boolean isSameCrop(Block crop) {
        return crop == this;
    }

    private void postGrow(World world, int x, int y, int z, int prevMeta, int meta) {
        BlockBLGenericCrop crop;
        if (this.maxHeight > 1 && meta == 7 && prevMeta < meta && world.func_147439_a(x, y - 1, z) instanceof BlockBLGenericCrop && (crop = (BlockBLGenericCrop)world.func_147439_a(x, y - 1, z)).isCropOrSoilDecayed(world, x, y - 1, z)) {
            world.func_72921_c(x, y, z, 8, 3);
        }
    }

    protected void onGrow(World world, int x, int y, int z) {
        world.func_147449_b(x, y, z, (Block)this);
    }

    protected boolean canGrowTo(World world, int x, int y, int z) {
        return world.func_147437_c(x, y, z);
    }

    protected boolean destroyCrop(World world, int x, int y, int z, int meta) {
        return world.func_147468_f(x, y, z);
    }
}

