/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.plants.crops;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.plants.crops.BlockBLGenericCrop;
import thebetweenlands.herblore.aspects.Aspect;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.tileentities.TileEntityAspectrusCrop;

public class BlockAspectrusCrop
extends BlockBLGenericCrop
implements ITileEntityProvider {
    private static final float ASPECT_FRUIT_MULTIPLIER = 0.5f;
    private static final float ASPECT_SEEDS_DEGRADATION = 0.18f;
    private static final int MAX_HEIGHT = 3;

    public BlockAspectrusCrop(String blockName) {
        super(blockName);
        this.func_149658_d("thebetweenlands:weedwoodLeavesFast");
        float min = 0.345f;
        float max = 0.655f;
        this.func_149676_a(min, 0.0f, min, max, 1.0f, max);
        this.setMaxHeight(3);
    }

    public void setAspect(World world, int x, int y, int z, Aspect aspect) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityAspectrusCrop) {
            ((TileEntityAspectrusCrop)tile).setAspect(aspect);
        }
    }

    public Aspect getAspect(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityAspectrusCrop) {
            return ((TileEntityAspectrusCrop)tile).getAspect();
        }
        return null;
    }

    @Override
    public ItemStack getSeedDrop(World world, int x, int y, int z) {
        ItemStack stack = new ItemStack(BLItemRegistry.aspectrusCropSeed, 1);
        Aspect aspect = this.getAspect(world, x, y, z);
        if (aspect != null && aspect.getAmount() - 0.18f > 0.0f) {
            AspectManager.addDynamicAspects(stack, new Aspect(aspect.type, aspect.getAmount() - 0.18f));
        }
        return stack;
    }

    @Override
    public ItemStack getCropDrop(World world, int x, int y, int z) {
        ItemStack stack = ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.ASPECTRUS_FRUIT);
        Aspect aspect = this.getAspect(world, x, y, z);
        if (aspect != null) {
            AspectManager.addDynamicAspects(stack, new Aspect(aspect.type, aspect.getAmount() * 0.5f));
        }
        return stack;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        List<Aspect> aspects;
        ItemStack heldItem;
        if (this.getAspect(world, x, y, z) == null && (heldItem = player.func_70694_bm()) != null && heldItem.func_77973_b() == BLItemRegistry.aspectVial && (aspects = AspectManager.get(world).getDiscoveredAspects(heldItem, null)).size() > 0) {
            if (!world.field_72995_K) {
                Aspect aspect = aspects.get(0);
                this.setAspect(world, x, y, z, aspect);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                ItemStack newStack;
                --heldItem.field_77994_a;
                if (heldItem.field_77994_a == 0) {
                    player.func_70062_b(0, null);
                }
                if (!player.field_71071_by.func_70441_a(newStack = heldItem.func_77960_j() % 2 == 0 ? new ItemStack((Item)BLItemRegistry.dentrothystVial, 1, 0) : new ItemStack((Item)BLItemRegistry.dentrothystVial, 1, 2))) {
                    player.func_71019_a(newStack, false);
                }
            }
            return true;
        }
        return super.func_149727_a(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return -1;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        float min = 0.375f;
        float max = 0.625f;
        return AxisAlignedBB.func_72330_a((double)((double)x + (double)min), (double)y, (double)((double)z + (double)min), (double)((double)x + (double)max), (double)((double)y + 1.5), (double)((double)z + (double)max));
    }

    @Override
    public boolean destroyCrop(World world, int x, int y, int z, int meta) {
        return world.func_147449_b(x, y, z, (Block)BLBlockRegistry.rubberTreePlankFence);
    }

    @Override
    public boolean func_149851_a(World world, int x, int y, int z, boolean isRemote) {
        Aspect aspect = this.getAspect(world, x, y, z);
        if (aspect == null) {
            return false;
        }
        return super.func_149851_a(world, x, y, z, isRemote);
    }

    @Override
    public boolean shouldGrow(World world, int x, int y, int z) {
        Aspect aspect = this.getAspect(world, x, y, z);
        if (aspect != null) {
            return world.field_73012_v.nextInt((int)(1.0f + aspect.getAmount() * 8.0f)) == 0;
        }
        return false;
    }

    @Override
    public boolean shouldDecay(World world, int x, int y, int z) {
        Aspect aspect = this.getAspect(world, x, y, z);
        if (aspect != null) {
            return world.field_73012_v.nextInt(Math.max((int)(180.0f - aspect.getAmount() * 35.0f), 2)) == 0;
        }
        return world.field_73012_v.nextInt(180) == 0;
    }

    @Override
    public boolean canGrowTo(World world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == BLBlockRegistry.rubberTreePlankFence && !BLBlockRegistry.rubberTreePlankFence.func_149826_e((IBlockAccess)world, x + 1, y, z) && !BLBlockRegistry.rubberTreePlankFence.func_149826_e((IBlockAccess)world, x - 1, y, z) && !BLBlockRegistry.rubberTreePlankFence.func_149826_e((IBlockAccess)world, x, y, z + 1) && !BLBlockRegistry.rubberTreePlankFence.func_149826_e((IBlockAccess)world, x, y, z - 1);
    }

    @Override
    public void onGrow(World world, int x, int y, int z) {
        super.onGrow(world, x, y, z);
        Block blockBelow = world.func_147439_a(x, y - 1, z);
        if (blockBelow instanceof BlockAspectrusCrop) {
            this.setAspect(world, x, y, z, ((BlockAspectrusCrop)blockBelow).getAspect(world, x, y - 1, z));
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        world.func_147475_p(x, y, z);
    }

    public boolean func_149696_a(World world, int x, int y, int z, int event, int arg) {
        super.func_149696_a(world, x, y, z, event, arg);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        return tileentity != null ? tileentity.func_145842_c(event, arg) : false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityAspectrusCrop();
    }
}

