/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.plants;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.BLFluidRegistry;
import thebetweenlands.blocks.terrain.BlockSwampWater;
import thebetweenlands.client.render.block.water.WaterSimplePlantRenderer;
import thebetweenlands.creativetabs.BLCreativeTabs;
import thebetweenlands.items.herblore.ItemGenericPlantDrop;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.items.tools.ISickleHarvestable;
import thebetweenlands.items.tools.ISyrmoriteShearable;

public class BlockWaterFlowerStalk
extends BlockSwampWater
implements IPlantable,
ISyrmoriteShearable,
ISickleHarvestable {
    public IIcon iconStalk;

    public BlockWaterFlowerStalk() {
        super(BLFluidRegistry.swampWaterStalk, Material.field_151586_h);
        this.func_149672_a(Block.field_149779_h);
        this.func_149663_c("thebetweenlands.waterFlowerStalk");
        this.func_149711_c(0.5f);
        this.func_149647_a(BLCreativeTabs.plants);
        this.func_149676_a(0.1f, 0.0f, 0.1f, 1.0f, 0.9f, 0.9f);
        this.func_149675_a(true);
        this.canSpread = false;
        this.canReplenish = false;
        this.hasBoundingBox = true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconStalk = iconRegister.func_94245_a("thebetweenlands:waterFlowerStalk");
        this.setSpecialRenderer(new WaterSimplePlantRenderer(this.iconStalk));
        super.func_149651_a(iconRegister);
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Water;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && this.func_149718_j(world, x, y, z) && this.canPlaceBlockOn(world.func_147439_a(x, y - 1, z)) && world.func_147439_a(x, y, z).func_149688_o() == Material.field_151586_h;
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.canPlaceBlockOn(world.func_147439_a(x, y - 1, z));
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        this.checkAndDropBlock(world, x, y, z);
    }

    @Override
    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.checkAndDropBlock(world, x, y, z);
    }

    public int func_149643_k(World world, int x, int y, int z) {
        return ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.SWAMP_REED).func_77960_j();
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public Item func_149650_a(int p_149650_1_, Random random, int meta) {
        return null;
    }

    protected void checkAndDropBlock(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            world.func_147444_c(x, y, z, Blocks.field_150350_a);
        }
    }

    protected boolean canPlaceBlockOn(Block block) {
        return block instanceof BlockWaterFlowerStalk || block == BLBlockRegistry.mud;
    }

    @Override
    public boolean isHarvestable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    @Override
    public ArrayList<ItemStack> getHarvestableDrops(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(ItemGenericPlantDrop.createStack(ItemGenericPlantDrop.EnumItemPlantDrop.WATER_FLOWER_STALK));
        return drops;
    }

    @Override
    public boolean isSyrmoriteShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    @Override
    public ItemStack getSyrmoriteShearableSpecialDrops(Block block, int x, int y, int z, int meta) {
        return null;
    }
}

