/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.plants;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.creativetabs.BLCreativeTabs;
import thebetweenlands.items.herblore.ItemGenericPlantDrop;
import thebetweenlands.items.tools.ISickleHarvestable;
import thebetweenlands.items.tools.ISyrmoriteShearable;

public class BlockWaterFlower
extends BlockBush
implements IPlantable,
ISyrmoriteShearable,
ISickleHarvestable {
    public BlockWaterFlower() {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.func_149647_a(BLCreativeTabs.plants);
        this.func_149711_c(0.5f);
        this.func_149672_a(Block.field_149779_h);
        this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 1.0f, 0.9f);
        this.func_149663_c("thebetweenlands.waterFlower");
        this.func_149658_d("thebetweenlands:waterFlower");
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
    }

    public Item func_149650_a(int p_149650_1_, Random random, int meta) {
        return null;
    }

    public boolean func_149854_a(Block block) {
        return block == BLBlockRegistry.waterFlowerStalk;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkBlock(world, x, y, z);
    }

    protected final boolean checkBlock(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            return false;
        }
        return true;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.func_147437_c(x, y, z) && this.func_149854_a(world.func_147439_a(x, y - 1, z));
    }

    protected void func_149855_e(World world, int x, int y, int z) {
        super.func_149855_e(world, x, y, z);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != this) {
            return super.func_149718_j(world, x, y, z);
        }
        return world.func_147439_a(x, y - 1, z) == this || this.func_149854_a(world.func_147439_a(x, y - 1, z));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess access, int x, int y, int z) {
        return 0xFFFFFF;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Beach;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public static void generateFlowerPatch(World world, int x, int y, int z, int tries, int radius) {
        for (int i = 0; i < tries; ++i) {
            Block cBlock;
            int bz;
            int by;
            int bx = x + world.field_73012_v.nextInt(radius) - radius / 2;
            if (!(Math.sqrt((bx - x) * (bx - x) + ((by = y + world.field_73012_v.nextInt(radius) - radius / 2) - y) * (by - y) + ((bz = z + world.field_73012_v.nextInt(radius) - radius / 2) - z) * (bz - z)) <= (double)radius) || !BLBlockRegistry.waterFlowerStalk.canPlaceBlockOn(cBlock = world.func_147439_a(bx, by, bz))) continue;
            BlockWaterFlower.generateFlower(world, bx, by + 1, bz);
        }
    }

    public static void generateFlower(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            int yo = 0;
            for (int i = 0; i < 255; ++i) {
                Block cBlock = world.func_147439_a(x, y + yo, z);
                if (cBlock != BLBlockRegistry.swampWater) {
                    world.func_147449_b(x, y + yo, z, (Block)BLBlockRegistry.waterFlower);
                    break;
                }
                world.func_147449_b(x, y + yo, z, (Block)BLBlockRegistry.waterFlowerStalk);
                ++yo;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (world.field_73012_v.nextInt(40) == 0) {
            BLParticle.MOTH.spawn(world, x, (double)y + 1.5, z, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
        }
    }

    @Override
    public boolean isHarvestable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    @Override
    public ArrayList<ItemStack> getHarvestableDrops(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(ItemGenericPlantDrop.createStack(ItemGenericPlantDrop.EnumItemPlantDrop.WATER_FLOWER));
        return drops;
    }

    @Override
    public boolean isSyrmoriteShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }

    @Override
    public ItemStack getSyrmoriteShearableSpecialDrops(Block block, int x, int y, int z, int meta) {
        return null;
    }
}

