/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.plants;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.creativetabs.BLCreativeTabs;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.proxy.ClientProxy;
import thebetweenlands.world.events.impl.EventSpoopy;

public class BlockSwampReed
extends BlockBush
implements IPlantable {
    @SideOnly(value=Side.CLIENT)
    public IIcon top;
    @SideOnly(value=Side.CLIENT)
    public IIcon bottom;
    @SideOnly(value=Side.CLIENT)
    public IIcon spoopyTop;
    @SideOnly(value=Side.CLIENT)
    public IIcon spoopyBottom;

    public BlockSwampReed() {
        super(Material.field_151589_v);
        this.func_149675_a(true);
        this.func_149647_a(BLCreativeTabs.plants);
        this.func_149711_c(0.5f);
        this.func_149672_a(Block.field_149779_h);
        this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 1.0f, 0.9f);
        this.func_149663_c("thebetweenlands.swampReedBlock");
        this.func_149675_a(true);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.SWAMP_REED, 1 + fortune));
        return drops;
    }

    public boolean func_149854_a(Block block) {
        return block == BLBlockRegistry.swampDirt || block == BLBlockRegistry.swampGrass || block == BLBlockRegistry.silt || block == BLBlockRegistry.swampReedUW || block == BLBlockRegistry.swampReed || block == BLBlockRegistry.mud || block == BLBlockRegistry.deadGrass;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkBlock(world, x, y, z);
    }

    protected final boolean checkBlock(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            return false;
        }
        return true;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        boolean hasWater = world.func_147439_a(x - 1, y - 1, z).func_149688_o() == Material.field_151586_h || world.func_147439_a(x + 1, y - 1, z).func_149688_o() == Material.field_151586_h || world.func_147439_a(x, y - 1, z - 1).func_149688_o() == Material.field_151586_h || world.func_147439_a(x, y - 1, z + 1).func_149688_o() == Material.field_151586_h;
        return this.func_149854_a(world.func_147439_a(x, y - 1, z)) && (hasWater || world.func_147439_a(x, y - 1, z) == this);
    }

    public static void generateReedPatch(World world, int x, int y, int z, int tries, int radius) {
        for (int i = 0; i < tries; ++i) {
            int bz;
            int by;
            int bx = x + world.field_73012_v.nextInt(radius) - radius / 2;
            if (!(Math.sqrt((bx - x) * (bx - x) + ((by = y + world.field_73012_v.nextInt(radius) - radius / 2) - y) * (by - y) + ((bz = z + world.field_73012_v.nextInt(radius) - radius / 2) - z) * (bz - z)) <= (double)radius)) continue;
            Block cBlock = world.func_147439_a(bx, by, bz);
            Block blockAbove = world.func_147439_a(bx, by + 1, bz);
            Block blockAbove2 = world.func_147439_a(bx, by + 2, bz);
            if (cBlock == BLBlockRegistry.mud && blockAbove == BLBlockRegistry.swampWater && blockAbove2 == Blocks.field_150350_a) {
                BlockSwampReed.generateReed(world, bx, by + 1, bz);
                continue;
            }
            if (!cBlock.func_149662_c() || blockAbove != Blocks.field_150350_a || blockAbove2 != Blocks.field_150350_a || !BLBlockRegistry.swampReed.func_149742_c(world, bx, by + 1, bz)) continue;
            BlockSwampReed.generateReed(world, bx, by + 1, bz);
        }
    }

    public static void generateReed(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block cBlock;
            int height = world.field_73012_v.nextInt(4) + 2;
            for (int yo = 0; yo < height && ((cBlock = world.func_147439_a(x, y + yo, z)) == Blocks.field_150350_a || cBlock == BLBlockRegistry.swampWater); ++yo) {
                if (cBlock == BLBlockRegistry.swampWater) {
                    world.func_147449_b(x, y + yo, z, (Block)BLBlockRegistry.swampReedUW);
                    continue;
                }
                world.func_147449_b(x, y + yo, z, (Block)BLBlockRegistry.swampReed);
            }
        }
    }

    protected void func_149855_e(World world, int x, int y, int z) {
        super.func_149855_e(world, x, y, z);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z) != this) {
            return super.func_149718_j(world, x, y, z);
        }
        return world.func_147439_a(x, y - 1, z) == this || this.func_149854_a(world.func_147439_a(x, y - 1, z));
    }

    public int func_149645_b() {
        return ClientProxy.BlockRenderIDs.SWAMP_REED.id();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (EventSpoopy.isSpoopy((World)Minecraft.func_71410_x().field_71441_e)) {
            return this.spoopyTop;
        }
        return this.top;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (EventSpoopy.isSpoopy((World)Minecraft.func_71410_x().field_71441_e)) {
            return (world.func_72805_g(x, y, z) & 8) != 0 ? this.spoopyTop : this.spoopyBottom;
        }
        return (world.func_72805_g(x, y, z) & 8) != 0 ? this.top : this.bottom;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.top = reg.func_94245_a("thebetweenlands:swampReedTop");
        this.bottom = reg.func_94245_a("thebetweenlands:swampReedBottom");
        this.spoopyTop = reg.func_94245_a("thebetweenlands:swampReedTopSpoopy");
        this.spoopyBottom = reg.func_94245_a("thebetweenlands:swampReedBottomSpoopy");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcons(int i) {
        if (EventSpoopy.isSpoopy((World)Minecraft.func_71410_x().field_71441_e)) {
            switch (i) {
                case 0: {
                    return this.spoopyTop;
                }
                case 1: {
                    return this.spoopyBottom;
                }
            }
        } else {
            switch (i) {
                case 0: {
                    return this.top;
                }
                case 1: {
                    return this.bottom;
                }
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess access, int x, int y, int z) {
        return 0xFFFFFF;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Beach;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (world.func_147437_c(x, y + 1, z)) {
            int reedHeight = 1;
            while (world.func_147439_a(x, y - reedHeight, z) == this) {
                ++reedHeight;
            }
            if (reedHeight < 3) {
                int meta = world.func_72805_g(x, y, z);
                if (meta == 15) {
                    world.func_147449_b(x, y + 1, z, (Block)this);
                    world.func_72921_c(x, y, z, 0, 4);
                } else {
                    world.func_72921_c(x, y, z, meta + 1, 4);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (world.field_73012_v.nextInt(40) == 0) {
            BLParticle.MOSQUITO.spawn(world, x, (double)y + 1.5, z);
        }
    }
}

