/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.plants;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.BLFluidRegistry;
import thebetweenlands.blocks.terrain.BlockSwampWater;
import thebetweenlands.client.render.block.water.WaterSimplePlantRenderer;
import thebetweenlands.creativetabs.BLCreativeTabs;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.herblore.ItemGenericPlantDrop;
import thebetweenlands.items.tools.ISickleHarvestable;
import thebetweenlands.items.tools.ISyrmoriteShearable;

public class BlockGoldenClub
extends BlockSwampWater
implements IPlantable,
ISickleHarvestable,
ISyrmoriteShearable {
    public IIcon iconGoldenClubBottom;
    public IIcon iconGoldenClubTop;

    public BlockGoldenClub() {
        super(BLFluidRegistry.swampWaterGoldenClub, Material.field_151586_h);
        this.func_149672_a(Block.field_149779_h);
        this.func_149663_c("thebetweenlands.goldenClub");
        this.func_149711_c(0.5f);
        this.func_149647_a(BLCreativeTabs.plants);
        this.func_149676_a(0.1f, 0.0f, 0.1f, 1.0f, 0.9f, 0.9f);
        this.func_149675_a(true);
        this.canSpread = false;
        this.hasBoundingBox = true;
        this.canReplenish = false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconGoldenClubBottom = iconRegister.func_94245_a("thebetweenlands:goldenClubBottom");
        this.iconGoldenClubTop = iconRegister.func_94245_a("thebetweenlands:goldenClubTop");
        this.setSpecialRenderer(new WaterSimplePlantRenderer(this.iconGoldenClubBottom, this.iconGoldenClubTop));
        super.func_149651_a(iconRegister);
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Water;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && this.func_149718_j(world, x, y, z) && this.canPlaceBlockOn(world.func_147439_a(x, y - 1, z));
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.canPlaceBlockOn(world.func_147439_a(x, y - 1, z));
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        this.checkAndDropBlock(world, x, y, z);
    }

    @Override
    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        this.checkAndDropBlock(world, x, y, z);
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    protected void checkAndDropBlock(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
            world.func_147444_c(x, y, z, Blocks.field_150350_a);
        }
    }

    protected boolean canPlaceBlockOn(Block block) {
        return block instanceof BlockGoldenClub || block == BLBlockRegistry.mud;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        return drops;
    }

    @Override
    public boolean isHarvestable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return item.func_77973_b() == BLItemRegistry.sickle;
    }

    @Override
    public ArrayList<ItemStack> getHarvestableDrops(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
        dropList.add(ItemGenericPlantDrop.createStack(ItemGenericPlantDrop.EnumItemPlantDrop.GOLDEN_CLUB_FLOWERS));
        return dropList;
    }

    @Override
    public ItemStack getSyrmoriteShearableSpecialDrops(Block block, int x, int y, int z, int meta) {
        return null;
    }

    @Override
    public boolean isSyrmoriteShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }
}

