/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.plants;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.creativetabs.BLCreativeTabs;
import thebetweenlands.items.tools.ISickleHarvestable;
import thebetweenlands.items.tools.ISyrmoriteShearable;
import thebetweenlands.proxy.ClientProxy;
import thebetweenlands.world.events.impl.EventSpoopy;

public class BlockDoubleHeightPlant
extends BlockDoublePlant
implements ISickleHarvestable,
ISyrmoriteShearable {
    @SideOnly(value=Side.CLIENT)
    public IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    public IIcon bottomIcon;
    @SideOnly(value=Side.CLIENT)
    public IIcon spoopyTopIcon;
    @SideOnly(value=Side.CLIENT)
    public IIcon spoopyBottomIcon;
    protected final String name;
    Random rnd = new Random();
    private boolean harvestable = false;
    private ItemStack harvestItem = null;
    private boolean hasSpoopyTexture = false;
    private int renderType = -1;

    public BlockDoubleHeightPlant(String name) {
        this(name, 1.0f);
    }

    public BlockDoubleHeightPlant(String name, float width) {
        this.name = name;
        this.func_149647_a(BLCreativeTabs.plants);
        this.func_149672_a(Block.field_149779_h);
        this.func_149675_a(true);
        float w = (1.0f - width) / 2.0f;
        this.func_149676_a(w, 0.0f, w, width + w, 1.0f, width + w);
        this.func_149663_c("thebetweenlands." + name.substring(0, 1).toLowerCase() + name.substring(1));
    }

    public BlockDoubleHeightPlant setRenderType(int renderType) {
        this.renderType = renderType;
        return this;
    }

    public BlockDoubleHeightPlant setHarvestable(boolean harvestable) {
        this.harvestable = harvestable;
        return this;
    }

    public BlockDoubleHeightPlant setHarvestedItem(ItemStack stack) {
        this.harvestable = true;
        this.harvestItem = stack;
        return this;
    }

    public BlockDoubleHeightPlant setHasSpoopyTexture(boolean spoopyTexture) {
        this.hasSpoopyTexture = spoopyTexture;
        return this;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
    }

    protected boolean func_149854_a(Block block) {
        return block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150458_ak || block == BLBlockRegistry.swampDirt || block == BLBlockRegistry.swampGrass || block == BLBlockRegistry.deadGrass;
    }

    public int func_149645_b() {
        return this.renderType == -1 ? ClientProxy.BlockRenderIDs.DOUBLE_PLANTS.id() : this.renderType;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (EventSpoopy.isSpoopy((World)Minecraft.func_71410_x().field_71441_e) && this.hasSpoopyTexture) {
            return this.spoopyTopIcon;
        }
        return this.topIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        if (EventSpoopy.isSpoopy((World)Minecraft.func_71410_x().field_71441_e) && this.hasSpoopyTexture) {
            return BlockDoubleHeightPlant.func_149887_c((int)world.func_72805_g(x, y, z)) ? this.spoopyTopIcon : this.spoopyBottomIcon;
        }
        return BlockDoubleHeightPlant.func_149887_c((int)world.func_72805_g(x, y, z)) ? this.topIcon : this.bottomIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.topIcon = reg.func_94245_a("thebetweenlands:doublePlant" + this.name + "Top");
        this.bottomIcon = reg.func_94245_a("thebetweenlands:doublePlant" + this.name + "Bottom");
        if (this.hasSpoopyTexture) {
            this.spoopyTopIcon = reg.func_94245_a("thebetweenlands:doublePlant" + this.name + "TopSpoopy");
            this.spoopyBottomIcon = reg.func_94245_a("thebetweenlands:doublePlant" + this.name + "BottomSpoopy");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess access, int x, int y, int z) {
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item));
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        return drops;
    }

    @Override
    public boolean isHarvestable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return this.harvestable && this.harvestItem != null;
    }

    @Override
    public ArrayList<ItemStack> getHarvestableDrops(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
        if (this.harvestItem != null) {
            dropList.add(this.harvestItem.func_77946_l());
        }
        return dropList;
    }

    @Override
    public ItemStack getSyrmoriteShearableSpecialDrops(Block block, int x, int y, int z, int meta) {
        return null;
    }

    @Override
    public boolean isSyrmoriteShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }
}

