/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.plants;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.creativetabs.BLCreativeTabs;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.herblore.ItemGenericPlantDrop;
import thebetweenlands.items.tools.ISickleHarvestable;
import thebetweenlands.items.tools.ISyrmoriteShearable;

public class BlockCaveMoss
extends BlockBush
implements ISickleHarvestable,
ISyrmoriteShearable {
    private IIcon lower;

    public BlockCaveMoss() {
        super(Material.field_151585_k);
        this.func_149675_a(false);
        this.func_149711_c(0.0f);
        this.func_149647_a(BLCreativeTabs.plants);
        this.func_149663_c("thebetweenlands.caveMoss");
        this.func_149658_d("thebetweenlands:caveMoss");
        this.func_149672_a(Block.field_149779_h);
        this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 1.0f, 0.75f);
    }

    public boolean isLadder(IBlockAccess world, int x, int y, int z, EntityLivingBase entity) {
        return true;
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return this.isValidBlock(world.func_147439_a(x, y + 1, z)) && this.func_149718_j(world, x, y, z);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return this.isValidBlock(world.func_147439_a(x, y + 1, z));
    }

    public int func_149645_b() {
        return 6;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return random.nextInt(2);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float sideHitX, float sideHitY, float sideHitZ, int meta) {
        return world.func_147439_a(x, y - 1, z) != this ? 1 : 0;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        if (world.func_147437_c(x, y + 1, z)) {
            world.func_147468_f(x, y, z);
            this.func_149697_b(world, x, y, z, 0, 0);
        } else {
            world.func_72921_c(x, y, z, world.func_147439_a(x, y - 1, z) != this ? 1 : 0, 2);
        }
    }

    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (random.nextInt(40) == 0) {
            float dripRange = 0.5f;
            float px = random.nextFloat() - 0.5f;
            float py = random.nextFloat();
            float pz = random.nextFloat() - 0.5f;
            float u = Math.max(Math.abs(px), Math.abs(pz));
            px = px / u * dripRange + 0.5f;
            pz = pz / u * dripRange + 0.5f;
            BLParticle.CAVE_WATER_DRIP.spawn(world, (float)x + px, (float)y + py, (float)z + pz);
        }
    }

    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.lower = iconRegister.func_94245_a(this.field_149768_d + "Lower");
    }

    public IIcon func_149691_a(int side, int metadata) {
        return metadata == 1 ? this.lower : this.field_149761_L;
    }

    protected boolean isValidBlock(Block block) {
        return block == BLBlockRegistry.betweenstone || block == this;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        return drops;
    }

    @Override
    public boolean isHarvestable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return item.func_77973_b() == BLItemRegistry.sickle;
    }

    @Override
    public ArrayList<ItemStack> getHarvestableDrops(ItemStack item, IBlockAccess world, int x, int y, int z, int fortune) {
        ArrayList<ItemStack> dropList = new ArrayList<ItemStack>();
        dropList.add(ItemGenericPlantDrop.createStack(ItemGenericPlantDrop.EnumItemPlantDrop.CAVE_MOSS));
        return dropList;
    }

    @Override
    public ItemStack getSyrmoriteShearableSpecialDrops(Block block, int x, int y, int z, int meta) {
        return null;
    }

    @Override
    public boolean isSyrmoriteShearable(ItemStack item, IBlockAccess world, int x, int y, int z) {
        return true;
    }
}

