/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.ores;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.creativetabs.BLCreativeTabs;

public class BlockGenericOre
extends Block {
    private String type;
    private ItemStack oreDrops;
    private Random rand = new Random();
    private int minDropAmount = 1;
    private int maxDropAmount = 1;
    private int minXP = 0;
    private int maxXP = 0;

    public BlockGenericOre(String blockName, ItemStack oreDrops) {
        super(Material.field_151576_e);
        this.func_149672_a(field_149769_e);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(BLCreativeTabs.blocks);
        this.type = blockName;
        this.oreDrops = oreDrops;
        this.func_149663_c("thebetweenlands." + this.type);
        this.func_149658_d("thebetweenlands:" + this.type);
    }

    public BlockGenericOre setDropsAmounts(int min, int max) {
        this.minDropAmount = min;
        this.maxDropAmount = max;
        return this;
    }

    public BlockGenericOre setXP(int min, int max) {
        this.minXP = min;
        this.maxXP = max;
        return this;
    }

    private ItemStack getOreDropped() {
        return this.oreDrops != null ? this.oreDrops.func_77946_l() : this.oreDrops;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.oreDrops != null) {
            for (int dropFortune = 0; dropFortune < fortune + world.field_73012_v.nextInt(this.maxDropAmount - this.minDropAmount + 1) + this.minDropAmount; ++dropFortune) {
                drops.add(this.getOreDropped());
            }
        } else {
            drops.add(new ItemStack(Item.func_150898_a((Block)this)));
        }
        return drops;
    }

    public int func_149645_b() {
        return 0;
    }

    public String func_149732_F() {
        return String.format(StatCollector.func_74838_a((String)("tile.thebetweenlands." + this.type)), new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.field_149761_L;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int getExpDrop(IBlockAccess world, int meta, int fortune) {
        int xpAmount = MathHelper.func_76136_a((Random)this.rand, (int)this.minXP, (int)this.maxXP);
        return xpAmount;
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        double pixel = 0.0625;
        if (rand.nextInt(3) == 0) {
            for (int l = 0; l < 5; ++l) {
                double particleX = (float)x + rand.nextFloat();
                double particleY = (float)y + rand.nextFloat();
                double particleZ = (float)z + rand.nextFloat();
                if (l == 0 && !world.func_147439_a(x, y + 1, z).func_149662_c()) {
                    particleY = (double)(y + 1) + pixel;
                }
                if (l == 1 && !world.func_147439_a(x, y - 1, z).func_149662_c()) {
                    particleY = (double)y - pixel;
                }
                if (l == 2 && !world.func_147439_a(x, y, z + 1).func_149662_c()) {
                    particleZ = (double)(z + 1) + pixel;
                }
                if (l == 3 && !world.func_147439_a(x, y, z - 1).func_149662_c()) {
                    particleZ = (double)z - pixel;
                }
                if (l == 4 && !world.func_147439_a(x + 1, y, z).func_149662_c()) {
                    particleX = (double)(x + 1) + pixel;
                }
                if (l == 5 && !world.func_147439_a(x - 1, y, z).func_149662_c()) {
                    particleX = (double)x - pixel;
                }
                if (!(particleX < (double)x || particleX > (double)(x + 1) || particleY < (double)y || particleY > (double)(y + 1) || particleZ < (double)z) && !(particleZ > (double)(z + 1))) continue;
                this.spawnParticle(world, particleX, particleY, particleZ);
            }
        }
    }

    public void spawnParticle(World world, double x, double y, double z) {
    }
}

