/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.container.repeller;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.vecmath.Vector3d;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.creativetabs.BLCreativeTabs;
import thebetweenlands.entities.particles.EntityAnimatorFX2;
import thebetweenlands.herblore.aspects.Aspect;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.herblore.aspects.AspectRegistry;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.tileentities.TileEntityRepeller;

public class BlockRepeller
extends BlockContainer {
    public BlockRepeller() {
        super(Material.field_151575_d);
        this.func_149711_c(1.5f);
        this.func_149647_a(BLCreativeTabs.blocks);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        return super.func_149668_a(world, x, y, z);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 4) {
            this.func_149676_a(0.15f, 0.0f, 0.15f, 0.85f, 0.7f, 0.85f);
        } else {
            this.func_149676_a(0.15f, 0.0f, 0.15f, 0.85f, 1.0f, 0.85f);
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && world.isSideSolid(x, y - 1, z, ForgeDirection.UP) && world.func_147437_c(x, y + 1, z);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int metadata, float hitX, float hitY, float hitZ) {
        if (world.func_72805_g(x, y, z) >= 4 && world.func_147439_a(x, y - 1, z) == this) {
            return this.func_149727_a(world, x, y - 1, z, player, metadata, hitX, hitY, hitZ);
        }
        if (world.func_72805_g(x, y, z) < 4) {
            TileEntityRepeller tile = (TileEntityRepeller)world.func_147438_o(x, y, z);
            if (!player.func_70093_af() && player.func_70694_bm() != null) {
                if (player.func_70694_bm().func_77973_b() == BLItemRegistry.shimmerStone) {
                    if (!tile.hasShimmerstone()) {
                        tile.addShimmerstone();
                        if (!player.field_71075_bZ.field_75098_d) {
                            --player.func_70694_bm().field_77994_a;
                        }
                    }
                    return true;
                }
                if (player.func_70694_bm().func_77973_b() == BLItemRegistry.aspectVial) {
                    if (tile.hasShimmerstone()) {
                        List<Aspect> aspects = AspectManager.getDynamicAspects(player.func_70694_bm());
                        if (!aspects.isEmpty() && aspects.get((int)0).type == AspectRegistry.BYARIIS) {
                            Aspect aspect = aspects.get(0);
                            if (!world.field_72995_K) {
                                float added = tile.addFuel(aspect.getAmount());
                                if (!player.field_71075_bZ.field_75098_d) {
                                    ItemStack newItem = player.func_70694_bm();
                                    AspectManager.removeDynamicAspects(newItem);
                                    float leftAmount = aspect.amount - added;
                                    if (leftAmount > 0.0f) {
                                        AspectManager.addDynamicAspects(newItem, new Aspect(AspectRegistry.BYARIIS, leftAmount));
                                    } else {
                                        newItem = newItem.func_77973_b().getContainerItem(newItem);
                                    }
                                    player.func_70062_b(0, newItem);
                                }
                            }
                            player.func_71038_i();
                            return true;
                        }
                    } else if (!world.field_72995_K) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.repeller.shimmerstone.missing", new Object[0]));
                    }
                } else if (player.func_70694_bm().func_77973_b() == BLItemRegistry.dentrothystVial && tile.getFuel() > 0.0f && (player.func_70694_bm().func_77960_j() == 0 || player.func_70694_bm().func_77960_j() == 2)) {
                    ItemStack newStack = new ItemStack((Item)BLItemRegistry.aspectVial, 1, player.func_70694_bm().func_77960_j() == 0 ? 0 : 1);
                    if (!world.field_72995_K) {
                        AspectManager.addDynamicAspects(newStack, new Aspect(AspectRegistry.BYARIIS, tile.getFuel()));
                        tile.emptyFuel();
                    }
                    --player.func_70694_bm().field_77994_a;
                    if (player.func_70694_bm().field_77994_a <= 0) {
                        player.func_70062_b(0, null);
                    }
                    if (!player.field_71071_by.func_70441_a(newStack)) {
                        player.func_71019_a(newStack, false);
                    }
                    return true;
                }
            } else {
                if (player.func_70093_af() && player.func_70694_bm() == null && tile.hasShimmerstone()) {
                    tile.removeShimmerstone();
                    ItemStack stack = new ItemStack((Item)BLItemRegistry.shimmerStone, 1);
                    if (!player.field_71071_by.func_70441_a(stack)) {
                        player.func_71019_a(stack, false);
                    }
                    return true;
                }
                if (!player.func_70093_af() && player.func_70694_bm() == null) {
                    if (!world.field_72995_K) {
                        tile.cycleRadiusState();
                    }
                    player.func_71038_i();
                }
            }
        }
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (world.field_72995_K) {
            return;
        }
        TileEntityRepeller tile = (TileEntityRepeller)world.func_147438_o(x, y, z);
        if (tile != null) {
            EntityItem entityitem;
            double d2;
            double d1;
            double d0;
            float f;
            if (tile.hasShimmerstone()) {
                f = 0.7f;
                d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, new ItemStack((Item)BLItemRegistry.shimmerStone, 1));
                entityitem.field_145804_b = 10;
                world.func_72838_d((Entity)entityitem);
            }
            f = 0.7f;
            d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, new ItemStack(BLBlockRegistry.repeller, 1));
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        return new ArrayList<ItemStack>();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack is) {
        int rotation = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        world.func_72921_c(x, y, z, rotation, 3);
        world.func_147465_d(x, y + 1, z, (Block)this, rotation + 4, 3);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z) != this && world.isSideSolid(x, y - 1, z, ForgeDirection.UP) && world.func_147439_a(x, y + 1, z) == this || world.func_147439_a(x, y - 1, z) == this && world.func_72805_g(x, y, z) >= 4;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        this.checkAndBreakBlock(world, x, y, z);
    }

    protected void checkAndBreakBlock(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            int meta = world.func_72805_g(x, y, z);
            this.func_149749_a(world, x, y, z, world.func_147439_a(x, y, z), meta);
            world.func_147465_d(x, y, z, BlockRepeller.func_149729_e((int)0), 0, 3);
        }
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TileEntityRepeller tile;
        int meta;
        if (rand.nextInt(6) == 0 && (meta = world.func_72805_g(x, y, z)) < 4 && (tile = (TileEntityRepeller)world.func_147438_o(x, y, z)) != null && tile.isRunning()) {
            for (int i = 0; i < 20; ++i) {
                double radius = Math.max((double)tile.getRadius(0.0f), 1.0);
                float rndRot = (float)((double)rand.nextFloat() * Math.PI * 2.0);
                double rotX = Math.sin(rndRot) * radius;
                double rotZ = Math.cos(rndRot) * radius;
                double xOff = Math.sin((double)((float)meta / 2.0f) * Math.PI) * (double)0.23f;
                double zOff = Math.cos((double)((float)meta / 2.0f) * Math.PI) * (double)0.23f;
                double centerX = (double)((float)x + 0.5f) + xOff;
                double centerY = (float)y + 1.3f;
                double centerZ = (double)((float)z + 0.5f) - zOff;
                ArrayList<Vector3d> points = new ArrayList<Vector3d>();
                points.add(new Vector3d(centerX, centerY, centerZ));
                points.add(new Vector3d(centerX, centerY + radius, centerZ));
                points.add(new Vector3d(centerX + rotX, centerY + radius, centerZ + rotZ));
                points.add(new Vector3d(centerX + rotX, (double)y + 0.1, centerZ + rotZ));
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityAnimatorFX2(world, centerX, centerY, centerZ, 0.0, 0.0, 0.0, points));
            }
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return meta < 4 ? new TileEntityRepeller() : null;
    }
}

