/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.container;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.creativetabs.BLCreativeTabs;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.tileentities.TileEntityInfuser;

public class BlockInfuser
extends BlockContainer {
    public BlockInfuser() {
        super(Material.field_151573_f);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149663_c("thebetweenlands.infuser");
        this.func_149647_a(BLCreativeTabs.herbLore);
        this.func_149658_d("thebetweenlands:octineBlock");
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack is) {
        int rot = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        world.func_72921_c(x, y, z, rot == 0 ? 2 : (rot == 1 ? 5 : (rot == 2 ? 3 : 4)), 3);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int metadata, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && world.func_147438_o(x, y, z) instanceof TileEntityInfuser) {
            TileEntityInfuser tile = (TileEntityInfuser)world.func_147438_o(x, y, z);
            if (!player.func_70093_af()) {
                if (tile != null && player.func_71045_bC() == null && tile.getStirProgress() >= 90) {
                    tile.setStirProgress(0);
                    return true;
                }
                if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == BLItemRegistry.weedwoodBucketWater && !tile.hasInfusion()) {
                    ItemStack oldItem = player.func_71045_bC();
                    ItemStack newItem = tile.fillTankWithBucket(player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c));
                    world.func_147471_g(x, y, z);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newItem);
                    }
                    if (!ItemStack.func_77989_b((ItemStack)oldItem, (ItemStack)newItem)) {
                        return true;
                    }
                }
                if (player.func_71045_bC() != null && AspectManager.get(world).getDiscoveredAspects(player.func_71045_bC(), null).size() > 0 && !tile.hasInfusion()) {
                    ItemStack ingredient = player.func_71045_bC();
                    for (int i = 0; i < 6; ++i) {
                        if (tile.func_70301_a(i) != null) continue;
                        ItemStack singleIngredient = ingredient.func_77946_l();
                        singleIngredient.field_77994_a = 1;
                        tile.func_70299_a(i, singleIngredient);
                        tile.updateInfusingRecipe();
                        if (!player.field_71075_bZ.field_75098_d) {
                            --player.func_71045_bC().field_77994_a;
                        }
                        world.func_147471_g(x, y, z);
                        return true;
                    }
                }
                if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() == BLItemRegistry.lifeCrystal) {
                    if (tile.func_70301_a(7) == null) {
                        tile.func_70299_a(7, player.func_71045_bC());
                        tile.updateInfusingRecipe();
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.func_70062_b(0, null);
                        }
                    }
                    return true;
                }
            }
            if (player.func_70093_af() && !tile.hasInfusion()) {
                for (int i = 6; i >= 0; --i) {
                    if (tile.func_70301_a(i) == null) continue;
                    EntityItem itemEntity = player.func_71019_a(tile.func_70301_a(i).func_77946_l(), false);
                    if (itemEntity != null) {
                        itemEntity.field_145804_b = 0;
                    }
                    tile.func_70299_a(i, null);
                    tile.updateInfusingRecipe();
                    world.func_147471_g(x, y, z);
                    return true;
                }
            }
            if (player.func_70093_af() && tile.func_70301_a(7) != null) {
                EntityItem itemEntity = player.func_71019_a(tile.func_70301_a(7).func_77946_l(), false);
                if (itemEntity != null) {
                    itemEntity.field_145804_b = 0;
                }
                tile.func_70299_a(7, null);
                tile.updateInfusingRecipe();
                world.func_147471_g(x, y, z);
                return true;
            }
        }
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        ItemStack stack;
        if (world.field_72995_K) {
            return;
        }
        IInventory tileInventory = (IInventory)world.func_147438_o(x, y, z);
        TileEntityInfuser tile = (TileEntityInfuser)world.func_147438_o(x, y, z);
        if (tileInventory != null && !tile.hasInfusion()) {
            for (int i = 0; i <= 7; ++i) {
                ItemStack stack2 = tileInventory.func_70301_a(i);
                if (stack2 == null || world.field_72995_K || !world.func_82736_K().func_82766_b("doTileDrops")) continue;
                float f = 0.7f;
                double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack2);
                entityitem.field_145804_b = 10;
                world.func_72838_d((Entity)entityitem);
            }
        } else if (tileInventory != null && tile.hasInfusion() && (stack = tileInventory.func_70301_a(7)) != null && !world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TileEntityInfuser infuser;
        if (world.func_147438_o(x, y, z) instanceof TileEntityInfuser && (infuser = (TileEntityInfuser)world.func_147438_o(x, y, z)).getWaterAmount() > 0 && infuser.getTemperature() > 0) {
            int amount = infuser.waterTank.getFluidAmount();
            int capacity = infuser.waterTank.getCapacity();
            float size = 1.0f / (float)capacity * (float)amount;
            float xx = (float)x + 0.5f;
            float yy = (float)y + 0.35f + size * 0.5f;
            float zz = (float)z + 0.5f;
            float fixedOffset = 0.25f;
            float randomOffset = rand.nextFloat() * 0.6f - 0.3f;
            if (rand.nextInt(101 - infuser.getTemperature()) / 4 == 0) {
                if (!infuser.hasInfusion()) {
                    BLParticle.BUBBLE_INFUSION.spawn(world, xx, yy, zz, 0.1, 0.0, 0.1, 0.0f, new Object[0]);
                } else {
                    BLParticle.BUBBLE_INFUSION.spawn(world, xx, yy, zz, 0.1, 0.0, 0.1, 0.0f, new Object[0]);
                }
                if (rand.nextInt(10) == 0 && infuser.getTemperature() > 70) {
                    world.func_72980_b((double)xx, (double)yy, (double)zz, "liquid.lava", 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.5f, false);
                }
            }
            if (infuser.getTemperature() >= 100) {
                BLParticle.STEAM_PURIFIER.spawn(world, xx - fixedOffset, (double)y + 0.75, zz + randomOffset, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                BLParticle.STEAM_PURIFIER.spawn(world, xx + fixedOffset, (double)y + 0.75, zz + randomOffset, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                BLParticle.STEAM_PURIFIER.spawn(world, xx + randomOffset, (double)y + 0.75, zz - fixedOffset, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                BLParticle.STEAM_PURIFIER.spawn(world, xx + randomOffset, (double)y + 0.75, zz + fixedOffset, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
            }
        }
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityInfuser();
    }
}

