/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.container;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.creativetabs.BLCreativeTabs;
import thebetweenlands.herblore.aspects.Aspect;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.herblore.aspects.DiscoveryContainer;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.tileentities.TileEntityGeckoCage;
import thebetweenlands.utils.confighandler.ConfigHandler;

public class BlockGeckoCage
extends BlockContainer {
    public BlockGeckoCage() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149663_c("thebetweenlands.geckoCage");
        this.func_149647_a(BLCreativeTabs.blocks);
        this.func_149658_d("thebetweenlands:weedwood");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return BLBlockRegistry.weedwood.func_149691_a(0, 0);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack is) {
        int rot = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        world.func_72921_c(x, y, z, rot == 0 ? 2 : (rot == 1 ? 5 : (rot == 2 ? 3 : 4)), 3);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int metadata, float hitX, float hitY, float hitZ) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityGeckoCage) {
            TileEntityGeckoCage tile = (TileEntityGeckoCage)world.func_147438_o(x, y, z);
            if (player.func_70093_af()) {
                return false;
            }
            if (player.func_70694_bm() != null) {
                ItemStack stack = player.func_70694_bm();
                if (stack.func_77973_b() == BLItemRegistry.gecko) {
                    if (!tile.hasGecko()) {
                        tile.addGecko(12);
                        if (!player.field_71075_bZ.field_75098_d) {
                            --stack.field_77994_a;
                        }
                        return true;
                    }
                    return false;
                }
                if (tile.getAspectType() == null) {
                    if (tile.hasGecko()) {
                        if (AspectManager.hasDiscoveryProvider(player)) {
                            AspectManager manager = AspectManager.get(world);
                            List<Aspect> aspects = manager.getDiscoveredAspects(stack, null);
                            if (aspects.size() > 0) {
                                DiscoveryContainer mergedKnowledge = AspectManager.getMergedDiscoveryContainer(player);
                                AspectManager.AspectItem aspectItem = new AspectManager.AspectItem(stack);
                                DiscoveryContainer.AspectDiscovery discovery = mergedKnowledge.discover(manager, aspectItem);
                                switch (discovery.result) {
                                    case NEW: 
                                    case LAST: {
                                        AspectManager.addDiscoveryToContainers(player, aspectItem, discovery.discovered.type);
                                        if (!world.field_72995_K) {
                                            tile.setAspectType(discovery.discovered.type, 600);
                                            if (ConfigHandler.DEBUG) {
                                                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.aspect.discovery." + discovery.discovered.type.getName(), new Object[0]));
                                                player.func_145747_a((IChatComponent)new ChatComponentText("Aspect: " + discovery.discovered.type.getName()));
                                            } else {
                                                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.aspect.discovery." + discovery.discovered.type.getName(), new Object[0]));
                                            }
                                            if (discovery.result == DiscoveryContainer.AspectDiscovery.EnumDiscoveryResult.LAST) {
                                                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.aspect.discovery.last", new Object[0]));
                                            } else {
                                                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.aspect.discovery.more", new Object[0]));
                                            }
                                            if (!player.field_71075_bZ.field_75098_d) {
                                                --stack.field_77994_a;
                                            }
                                        }
                                        return true;
                                    }
                                    case END: {
                                        if (!world.field_72995_K) {
                                            player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.aspect.discovery.end", new Object[0]));
                                        }
                                        return false;
                                    }
                                }
                                if (!world.field_72995_K) {
                                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.aspect.discovery.none", new Object[0]));
                                }
                                return false;
                            }
                            if (!world.field_72995_K) {
                                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.aspect.discovery.none", new Object[0]));
                            }
                            return false;
                        }
                        if (!world.field_72995_K) {
                            player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.aspect.discovery.book.none", new Object[0]));
                        }
                        return false;
                    }
                    if (!world.field_72995_K) {
                        player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.aspect.discovery.gecko.none", new Object[0]));
                    }
                    return false;
                }
                if (!world.field_72995_K) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.aspect.discovery.gecko.recovering", new Object[0]));
                }
                return false;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TileEntityGeckoCage cage;
        if (rand.nextInt(10) == 0 && world.func_147438_o(x, y, z) instanceof TileEntityGeckoCage && (cage = (TileEntityGeckoCage)world.func_147438_o(x, y, z)).hasGecko()) {
            float xx = (float)x + 0.5f;
            float yy = (float)y + 0.1f + rand.nextFloat() * 0.5f;
            float zz = (float)z + 0.5f;
            float fixedOffset = 0.25f;
            float randomOffset = rand.nextFloat() * 0.6f - 0.3f;
            if (cage.getAspectType() != null) {
                BLParticle.BUBBLE_INFUSION.spawn(world, xx - fixedOffset, yy, zz + randomOffset, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                BLParticle.BUBBLE_INFUSION.spawn(world, xx + fixedOffset, yy, zz + randomOffset, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                BLParticle.BUBBLE_INFUSION.spawn(world, xx + randomOffset, yy, zz - fixedOffset, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                BLParticle.BUBBLE_INFUSION.spawn(world, xx + randomOffset, yy, zz + fixedOffset, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
            } else {
                BLParticle.RUSTLE_LEAF.spawn(world, xx - fixedOffset / 2.0f, yy, zz + randomOffset / 2.0f, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                BLParticle.RUSTLE_LEAF.spawn(world, xx + fixedOffset / 2.0f, yy, zz + randomOffset / 2.0f, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                BLParticle.RUSTLE_LEAF.spawn(world, xx + randomOffset / 2.0f, yy, zz - fixedOffset / 2.0f, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
                BLParticle.RUSTLE_LEAF.spawn(world, xx + randomOffset / 2.0f, yy, zz + fixedOffset / 2.0f, 0.0, 0.0, 0.0, 0.0f, new Object[0]);
            }
        }
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityGeckoCage();
    }
}

