/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.container;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import thebetweenlands.TheBetweenlands;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.creativetabs.BLCreativeTabs;
import thebetweenlands.tileentities.TileEntityBLFurnace;

public class BlockBLFurnace
extends BlockContainer {
    private final Random rand = new Random();
    private final boolean active;
    private static boolean isBurning;
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon frontIcon;

    public BlockBLFurnace(boolean isActive) {
        super(Material.field_151576_e);
        this.active = isActive;
        this.func_149711_c(3.5f);
        this.func_149672_a(field_149780_i);
        if (!isActive) {
            this.func_149647_a(BLCreativeTabs.blocks);
        }
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        return Item.func_150898_a((Block)BLBlockRegistry.furnaceBL);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (side == 1) {
            return this.topIcon;
        }
        switch (meta) {
            case 0: {
                return side == 3 ? this.frontIcon : this.field_149761_L;
            }
            case 1: {
                return side == 4 ? this.frontIcon : this.field_149761_L;
            }
            case 2: {
                return side == 2 ? this.frontIcon : this.field_149761_L;
            }
            case 3: {
                return side == 5 ? this.frontIcon : this.field_149761_L;
            }
        }
        return this.field_149761_L;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister icon) {
        this.field_149761_L = icon.func_94245_a("thebetweenlands:sulfurFurnaceSide");
        this.frontIcon = icon.func_94245_a(this.active ? "thebetweenlands:sulfurFurnaceFrontOn" : "thebetweenlands:sulfurFurnaceFrontOff");
        this.topIcon = icon.func_94245_a("thebetweenlands:sulfurFurnaceTop");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityBLFurnace tileentityfurnace = (TileEntityBLFurnace)world.func_147438_o(x, y, z);
        if (tileentityfurnace != null) {
            player.openGui((Object)TheBetweenlands.instance, 4, world, x, y, z);
        }
        return true;
    }

    public static void updateFurnaceBlockState(boolean inUse, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        TileEntity tileentity = world.func_147438_o(x, y, z);
        isBurning = true;
        if (inUse) {
            world.func_147449_b(x, y, z, BLBlockRegistry.furnaceBLLit);
        } else {
            world.func_147449_b(x, y, z, BLBlockRegistry.furnaceBL);
        }
        isBurning = false;
        world.func_72921_c(x, y, z, meta, 2);
        if (tileentity != null) {
            tileentity.func_145829_t();
            world.func_147455_a(x, y, z, tileentity);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityBLFurnace();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack is) {
        int rot = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 2.5)) & 3;
        world.func_72921_c(x, y, z, rot, 3);
        if (is.func_82837_s()) {
            ((TileEntityBLFurnace)world.func_147438_o(x, y, z)).getStackDisplayName(is.func_82833_r());
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntityBLFurnace tileentityfurnace;
        if (!isBurning && (tileentityfurnace = (TileEntityBLFurnace)world.func_147438_o(x, y, z)) != null) {
            for (int slot = 0; slot < tileentityfurnace.func_70302_i_(); ++slot) {
                ItemStack itemstack = tileentityfurnace.func_70301_a(slot);
                if (itemstack == null) continue;
                float xOffset = this.rand.nextFloat() * 0.8f + 0.1f;
                float yOffset = this.rand.nextFloat() * 0.8f + 0.1f;
                float zOffset = this.rand.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int ammount = this.rand.nextInt(21) + 10;
                    if (ammount > itemstack.field_77994_a) {
                        ammount = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= ammount;
                    EntityItem entityitem = new EntityItem(world, (double)((float)x + xOffset), (double)((float)y + yOffset), (double)((float)z + zOffset), new ItemStack(itemstack.func_77973_b(), ammount, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float velocity = 0.05f;
                    entityitem.field_70159_w = (float)this.rand.nextGaussian() * velocity;
                    entityitem.field_70181_x = (float)this.rand.nextGaussian() * velocity + 0.2f;
                    entityitem.field_70179_y = (float)this.rand.nextGaussian() * velocity;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (this.active) {
            int meta = world.func_72805_g(x, y, z);
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f3 = 0.52f;
            float f4 = rand.nextFloat() * 0.6f - 0.3f;
            if (meta == 1) {
                BLParticle.SULFUR_TORCH.spawn(world, f - f3, f1, f2 + f4);
                world.func_72869_a("flame", (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (meta == 3) {
                BLParticle.SULFUR_TORCH.spawn(world, f + f3, f1, f2 + f4);
                world.func_72869_a("flame", (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0);
            } else if (meta == 2) {
                BLParticle.SULFUR_TORCH.spawn(world, f + f4, f1, f2 - f3);
                world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0);
            } else if (meta == 0) {
                BLParticle.SULFUR_TORCH.spawn(world, f + f4, f1, f2 + f3);
                world.func_72869_a("flame", (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        return Container.func_94526_b((IInventory)((IInventory)world.func_147438_o(x, y, z)));
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)BLBlockRegistry.furnaceBL);
    }
}

