/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks.container;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import thebetweenlands.herblore.Amounts;
import thebetweenlands.herblore.aspects.Aspect;
import thebetweenlands.herblore.aspects.AspectManager;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.tileentities.TileEntityAspectVial;

public class BlockAspectVial
extends BlockContainer {
    public static final String[] iconPaths = new String[]{"dentrothyst1", "dentrothyst2"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockAspectVial() {
        super(Material.field_151592_s);
        this.func_149672_a(field_149778_k);
        this.func_149711_c(0.4f);
        this.func_149663_c("thebetweenlands.aspectVialBlock");
        this.func_149676_a(0.1f, 0.0f, 0.1f, 0.9f, 0.8f, 0.9f);
    }

    public void func_149651_a(IIconRegister reg) {
        this.icons = new IIcon[iconPaths.length];
        int i = 0;
        for (String path : iconPaths) {
            this.icons[i++] = reg.func_94245_a("thebetweenlands:" + path);
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        if (meta < 0 || meta >= this.icons.length) {
            return null;
        }
        return this.icons[meta];
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack is) {
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int metadata, float hitX, float hitY, float hitZ) {
        if (world.func_147438_o(x, y, z) instanceof TileEntityAspectVial) {
            TileEntityAspectVial tile = (TileEntityAspectVial)world.func_147438_o(x, y, z);
            if (player.func_70694_bm() != null) {
                ItemStack heldItem = player.func_70694_bm();
                if (heldItem.func_77973_b() == BLItemRegistry.aspectVial && AspectManager.getDynamicAspects(heldItem).size() == 1) {
                    Aspect itemAspect = AspectManager.getDynamicAspects(heldItem).get(0);
                    if (!player.func_70093_af()) {
                        if (tile.getAspect() == null || tile.getAspect().type == itemAspect.type) {
                            if (!world.field_72995_K) {
                                float added;
                                if (tile.getAspect() == null) {
                                    tile.setAspect(new Aspect(itemAspect.type, 0.0f));
                                }
                                if ((added = tile.addAmount(Math.min(itemAspect.amount, 0.25f))) > 0.0f) {
                                    AspectManager.removeDynamicAspects(heldItem);
                                    float leftAmount = itemAspect.amount - added;
                                    if (leftAmount > 0.0f) {
                                        AspectManager.addDynamicAspects(heldItem, new Aspect(itemAspect.type, itemAspect.amount - added));
                                    } else {
                                        int type = heldItem.func_77960_j();
                                        switch (type) {
                                            default: {
                                                player.func_70062_b(0, BLItemRegistry.dentrothystVial.createStack(0));
                                                break;
                                            }
                                            case 1: {
                                                player.func_70062_b(0, BLItemRegistry.dentrothystVial.createStack(2));
                                            }
                                        }
                                    }
                                }
                            }
                            player.func_71038_i();
                            return true;
                        }
                    } else if (tile.getAspect() != null && tile.getAspect().type == itemAspect.type) {
                        float toRemove;
                        if (!world.field_72995_K && (toRemove = Math.min(0.25f, Amounts.MAX_VIAL_ASPECT_AMOUNT - itemAspect.amount)) > 0.0f) {
                            float removedAmount = tile.removeAmount(toRemove);
                            AspectManager.removeDynamicAspects(heldItem);
                            AspectManager.addDynamicAspects(heldItem, new Aspect(itemAspect.type, itemAspect.amount + removedAmount));
                        }
                        player.func_71038_i();
                        return true;
                    }
                } else if (heldItem.func_77973_b() == BLItemRegistry.dentrothystVial && player.func_70093_af() && tile.getAspect() != null && heldItem.func_77960_j() != 1) {
                    if (!world.field_72995_K) {
                        Aspect aspect = tile.getAspect();
                        float removedAmount = tile.removeAmount(0.25f);
                        if (removedAmount > 0.0f) {
                            EntityItem itemEntity;
                            ItemStack vial = new ItemStack((Item)BLItemRegistry.aspectVial);
                            switch (heldItem.func_77960_j()) {
                                default: {
                                    vial.func_77964_b(0);
                                    break;
                                }
                                case 2: {
                                    vial.func_77964_b(1);
                                }
                            }
                            AspectManager.addDynamicAspects(vial, new Aspect(aspect.type, removedAmount));
                            --heldItem.field_77994_a;
                            if (heldItem.field_77994_a <= 0) {
                                player.func_70062_b(0, null);
                            }
                            if ((itemEntity = player.func_71019_a(vial, false)) != null) {
                                itemEntity.field_145804_b = 0;
                            }
                        }
                    }
                    player.func_71038_i();
                    return true;
                }
            }
        }
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityAspectVial();
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        TileEntityAspectVial tile = (TileEntityAspectVial)world.func_147438_o(x, y, z);
        if (tile != null) {
            if (tile.getAspect() != null) {
                if (tile.getAspect().amount > 0.0f) {
                    ItemStack vial = new ItemStack((Item)BLItemRegistry.aspectVial);
                    vial.func_77964_b(metadata);
                    AspectManager.addDynamicAspects(vial, tile.getAspect());
                    ret.add(vial);
                }
            } else {
                ItemStack vial = new ItemStack((Item)BLItemRegistry.dentrothystVial);
                switch (metadata) {
                    default: {
                        vial.func_77964_b(0);
                        break;
                    }
                    case 1: {
                        vial.func_77964_b(2);
                    }
                }
                ret.add(vial);
            }
        }
        return ret;
    }

    public void func_149681_a(World world, int x, int y, int z, int id, EntityPlayer player) {
        if (world.field_72995_K) {
            return;
        }
        player.func_71064_a(StatList.field_75934_C[BlockAspectVial.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
        if (!world.field_72995_K && !world.restoringBlockSnapshots && world.func_82736_K().func_82766_b("doTileDrops") && !player.field_71075_bZ.field_75098_d) {
            ArrayList<ItemStack> drops = this.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
            float chance = ForgeEventFactory.fireBlockHarvesting(drops, (World)world, (Block)this, (int)x, (int)y, (int)z, (int)world.func_72805_g(x, y, z), (int)0, (float)1.0f, (boolean)false, (EntityPlayer)((EntityPlayer)this.harvesters.get()));
            for (ItemStack item : drops) {
                if (!(world.field_73012_v.nextFloat() <= chance)) continue;
                float f = 0.7f;
                double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, item);
                entityitem.field_145804_b = 10;
                world.func_72838_d((Entity)entityitem);
            }
        }
        world.func_147468_f(x, y, z);
    }
}

