/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.client.particle.BLParticle;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.entities.properties.list.EntityPropertiesPortal;
import thebetweenlands.world.teleporter.TeleporterHandler;

public class BlockTreePortal
extends Block {
    public BlockTreePortal() {
        super(Material.field_151567_E);
        this.func_149715_a(1.0f);
        this.func_149722_s();
        this.func_149663_c("thebetweenlands.treePortalBlock");
        this.func_149672_a(Block.field_149778_k);
        this.func_149658_d("thebetweenlands:portal");
    }

    public static boolean makePortalX(World world, int x, int y, int z) {
        world.func_147465_d(x, y + 2, z - 1, BLBlockRegistry.portalBarkFrame, 8, 2);
        world.func_147465_d(x, y + 2, z, BLBlockRegistry.portalBarkFrame, 9, 2);
        world.func_147465_d(x, y + 2, z + 1, BLBlockRegistry.portalBarkFrame, 10, 2);
        world.func_147465_d(x, y + 1, z - 1, BLBlockRegistry.portalBarkFrame, 11, 2);
        world.func_147465_d(x, y + 1, z + 1, BLBlockRegistry.portalBarkFrame, 12, 2);
        world.func_147465_d(x, y, z - 1, BLBlockRegistry.portalBarkFrame, 11, 2);
        world.func_147465_d(x, y, z + 1, BLBlockRegistry.portalBarkFrame, 12, 2);
        world.func_147465_d(x, y - 1, z - 1, BLBlockRegistry.portalBarkFrame, 13, 2);
        world.func_147465_d(x, y - 1, z, BLBlockRegistry.portalBarkFrame, 14, 2);
        world.func_147465_d(x, y - 1, z + 1, BLBlockRegistry.portalBarkFrame, 15, 2);
        if (BlockTreePortal.isPatternValidX(world, x, y, z)) {
            world.func_147465_d(x, y, z, (Block)BLBlockRegistry.treePortalBlock, 0, 2);
            world.func_147465_d(x, y + 1, z, (Block)BLBlockRegistry.treePortalBlock, 0, 2);
            return true;
        }
        return false;
    }

    public static boolean makePortalZ(World world, int x, int y, int z) {
        world.func_147465_d(x - 1, y + 2, z, BLBlockRegistry.portalBarkFrame, 0, 2);
        world.func_147465_d(x, y + 2, z, BLBlockRegistry.portalBarkFrame, 1, 2);
        world.func_147465_d(x + 1, y + 2, z, BLBlockRegistry.portalBarkFrame, 2, 2);
        world.func_147465_d(x - 1, y + 1, z, BLBlockRegistry.portalBarkFrame, 3, 2);
        world.func_147465_d(x + 1, y + 1, z, BLBlockRegistry.portalBarkFrame, 4, 2);
        world.func_147465_d(x - 1, y, z, BLBlockRegistry.portalBarkFrame, 3, 2);
        world.func_147465_d(x + 1, y, z, BLBlockRegistry.portalBarkFrame, 4, 2);
        world.func_147465_d(x - 1, y - 1, z, BLBlockRegistry.portalBarkFrame, 5, 2);
        world.func_147465_d(x, y - 1, z, BLBlockRegistry.portalBarkFrame, 6, 2);
        world.func_147465_d(x + 1, y - 1, z, BLBlockRegistry.portalBarkFrame, 7, 2);
        if (BlockTreePortal.isPatternValidZ(world, x, y, z)) {
            world.func_147465_d(x, y, z, (Block)BLBlockRegistry.treePortalBlock, 1, 2);
            world.func_147465_d(x, y + 1, z, (Block)BLBlockRegistry.treePortalBlock, 1, 2);
            return true;
        }
        return false;
    }

    public static boolean isPatternValidX(World world, int x, int y, int z) {
        if (!BlockTreePortal.check(world, x, y - 1, z, BLBlockRegistry.portalBarkFrame) && !BlockTreePortal.checkPortal(world, x, y - 1, z, BLBlockRegistry.treePortalBlock, 0)) {
            return false;
        }
        if (!BlockTreePortal.check(world, x, y, z - 1, BLBlockRegistry.portalBarkFrame)) {
            return false;
        }
        if (!BlockTreePortal.check(world, x, y, z + 1, BLBlockRegistry.portalBarkFrame)) {
            return false;
        }
        if (!BlockTreePortal.check(world, x, y + 1, z - 1, BLBlockRegistry.portalBarkFrame)) {
            return false;
        }
        if (!BlockTreePortal.check(world, x, y + 1, z + 1, BLBlockRegistry.portalBarkFrame)) {
            return false;
        }
        return BlockTreePortal.check(world, x, y + 2, z, BLBlockRegistry.portalBarkFrame);
    }

    public static boolean isPatternValidZ(World world, int x, int y, int z) {
        if (!BlockTreePortal.check(world, x, y - 1, z, BLBlockRegistry.portalBarkFrame) && !BlockTreePortal.checkPortal(world, x, y - 1, z, BLBlockRegistry.treePortalBlock, 1)) {
            return false;
        }
        if (!BlockTreePortal.check(world, x - 1, y, z, BLBlockRegistry.portalBarkFrame)) {
            return false;
        }
        if (!BlockTreePortal.check(world, x + 1, y, z, BLBlockRegistry.portalBarkFrame)) {
            return false;
        }
        if (!BlockTreePortal.check(world, x - 1, y + 1, z, BLBlockRegistry.portalBarkFrame)) {
            return false;
        }
        if (!BlockTreePortal.check(world, x + 1, y + 1, z, BLBlockRegistry.portalBarkFrame)) {
            return false;
        }
        return BlockTreePortal.check(world, x, y + 2, z, BLBlockRegistry.portalBarkFrame);
    }

    private static boolean check(World world, int x, int y, int z, Block target) {
        return world.func_147439_a(x, y, z) == target;
    }

    private static boolean checkPortal(World world, int x, int y, int z, Block target, int meta) {
        return world.func_147439_a(x, y, z) == target && world.func_72805_g(x, y, z) == meta;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.func_149718_j(world, x, y, z);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        if (BlockTreePortal.checkPortal(world, x, y + 1, z, BLBlockRegistry.treePortalBlock, 0) && BlockTreePortal.isPatternValidX(world, x, y, z)) {
            return true;
        }
        if (BlockTreePortal.checkPortal(world, x, y - 1, z, BLBlockRegistry.treePortalBlock, 0) && BlockTreePortal.isPatternValidX(world, x, y - 1, z)) {
            return true;
        }
        if (BlockTreePortal.checkPortal(world, x, y + 1, z, BLBlockRegistry.treePortalBlock, 1) && BlockTreePortal.isPatternValidZ(world, x, y, z)) {
            return true;
        }
        if (BlockTreePortal.checkPortal(world, x, y - 1, z, BLBlockRegistry.treePortalBlock, 1) && BlockTreePortal.isPatternValidZ(world, x, y - 1, z)) {
            return true;
        }
        world.func_72889_a(null, 2001, x, y, z, Block.func_149682_b((Block)world.func_147439_a(x, y, z)));
        world.func_147468_f(x, y, z);
        return false;
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 1;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        float ySize;
        float xSize;
        if (world.func_147439_a(x - 1, y, z) != BLBlockRegistry.portalBarkFrame && world.func_147439_a(x + 1, y, z) != BLBlockRegistry.portalBarkFrame) {
            xSize = 0.125f;
            ySize = 0.5f;
        } else {
            xSize = 0.5f;
            ySize = 0.125f;
        }
        this.func_149676_a(0.5f - xSize, 0.0f, 0.5f - ySize, 0.5f + xSize, 1.0f, 0.5f + ySize);
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        if (entity.field_70154_o == null && entity.field_70153_n == null && entity.field_71088_bW <= 0) {
            if (entity instanceof EntityPlayer) {
                EntityPropertiesPortal props = BLEntityPropertiesRegistry.HANDLER.getProperties(entity, EntityPropertiesPortal.class);
                props.inPortal = true;
            } else if (!world.field_72995_K) {
                if (entity.field_71093_bK == 0) {
                    TeleporterHandler.transferToBL(entity);
                } else {
                    TeleporterHandler.transferToOverworld(entity);
                }
                entity.field_71088_bW = 10;
            }
        }
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return side > 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        for (int i = 0; i < 4; ++i) {
            double particleX = (float)x + rand.nextFloat();
            double particleY = (float)y + rand.nextFloat();
            double particleZ = (float)z + rand.nextFloat();
            int multi = rand.nextInt(2) * 2 - 1;
            double motionX = ((double)rand.nextFloat() - 0.5) * 0.5;
            double motionY = ((double)rand.nextFloat() - 0.5) * 0.5;
            double motionZ = ((double)rand.nextFloat() - 0.5) * 0.5;
            if (world.func_147439_a(x - 1, y, z) != this && world.func_147439_a(x + 1, y, z) != this) {
                particleX = (double)x + 0.5 + 0.25 * (double)multi;
                motionX = rand.nextFloat() * 2.0f * (float)multi;
            } else {
                particleZ = (double)z + 0.5 + 0.25 * (double)multi;
                motionZ = rand.nextFloat() * 2.0f * (float)multi;
            }
            BLParticle.PORTAL.spawn(world, particleX, particleY, particleZ, motionX, motionY, motionZ, 0.0f, new Object[0]);
        }
        if (rand.nextInt(100) == 0) {
            world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "thebetweenlands:portal", 0.2f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
    }
}

