/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.items.misc.ItemGeneric;
import thebetweenlands.proxy.ClientProxy;

public class BlockRubberTap
extends Block {
    public IIcon icon;

    public BlockRubberTap() {
        super(Material.field_151575_d);
        this.func_149663_c("thebetweenlands.rubberTap");
        this.func_149711_c(0.8f);
        this.func_149647_a(null);
        this.func_149672_a(Block.field_149766_f);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.icon = register.func_94245_a("thebetweenlands:blockBucket");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return this.icon;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.BlockRenderIDs.RUBBER_TAP.id();
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return world.func_147439_a(x - 1, y, z) == BLBlockRegistry.rubberTreeLog && world.func_72805_g(x - 1, y, z) == 1 || world.func_147439_a(x + 1, y, z) == BLBlockRegistry.rubberTreeLog && world.func_72805_g(x + 1, y, z) == 1 || world.func_147439_a(x, y, z - 1) == BLBlockRegistry.rubberTreeLog && world.func_72805_g(x, y, z - 1) == 1 || world.func_147439_a(x, y, z + 1) == BLBlockRegistry.rubberTreeLog && world.func_72805_g(x, y, z + 1) == 1;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int meta) {
        int res = meta;
        if (side == 2 && world.func_147439_a(x, y, z + 1) == BLBlockRegistry.rubberTreeLog && world.func_72805_g(x, y, z + 1) == 1) {
            res = 4;
        }
        if (side == 3 && world.func_147439_a(x, y, z - 1) == BLBlockRegistry.rubberTreeLog && world.func_72805_g(x, y, z - 1) == 1) {
            res = 3;
        }
        if (side == 4 && world.func_147439_a(x + 1, y, z) == BLBlockRegistry.rubberTreeLog && world.func_72805_g(x + 1, y, z) == 1) {
            res = 2;
        }
        if (side == 5 && world.func_147439_a(x - 1, y, z) == BLBlockRegistry.rubberTreeLog && world.func_72805_g(x - 1, y, z) == 1) {
            res = 1;
        }
        return res;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        world.func_147464_a(x, y, z, (Block)this, 6000);
        if (world.func_72805_g(x, y, z) == 0) {
            if (world.func_147439_a(x - 1, y, z) == BLBlockRegistry.rubberTreeLog && world.func_72805_g(x - 1, y, z) == 1) {
                world.func_72921_c(x, y, z, 1, 2);
            } else if (world.func_147439_a(x + 1, y, z) == BLBlockRegistry.rubberTreeLog && world.func_72805_g(x + 1, y, z) == 1) {
                world.func_72921_c(x, y, z, 2, 2);
            } else if (world.func_147439_a(x, y, z - 1) == BLBlockRegistry.rubberTreeLog && world.func_72805_g(x, y, z - 1) == 1) {
                world.func_72921_c(x, y, z, 3, 2);
            } else if (world.func_147439_a(x, y, z + 1) == BLBlockRegistry.rubberTreeLog && world.func_72805_g(x, y, z + 1) == 1) {
                world.func_72921_c(x, y, z, 4, 2);
            }
        }
        this.checkAndDrop(world, x, y, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.canBlockStay(world, x, y, z, block);
    }

    protected boolean canBlockStay(World world, int x, int y, int z, Block block) {
        if (this.checkAndDrop(world, x, y, z)) {
            int meta = world.func_72805_g(x, y, z);
            boolean mustDrop = false;
            if ((world.func_147439_a(x - 1, y, z) != BLBlockRegistry.rubberTreeLog || world.func_72805_g(x - 1, y, z) != 1) && meta == 1) {
                mustDrop = true;
            }
            if ((world.func_147439_a(x + 1, y, z) != BLBlockRegistry.rubberTreeLog || world.func_72805_g(x + 1, y, z) != 1) && meta == 2) {
                mustDrop = true;
            }
            if ((world.func_147439_a(x, y, z - 1) != BLBlockRegistry.rubberTreeLog || world.func_72805_g(x, y, z - 1) != 1) && meta == 3) {
                mustDrop = true;
            }
            if ((world.func_147439_a(x, y, z + 1) != BLBlockRegistry.rubberTreeLog || world.func_72805_g(x, y, z + 1) != 1) && meta == 4) {
                mustDrop = true;
            }
            if (mustDrop) {
                this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                world.func_147468_f(x, y, z);
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean checkAndDrop(World world, int x, int y, int z) {
        if (!this.func_149742_c(world, x, y, z)) {
            if (world.func_147439_a(x, y, z) == this) {
                this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
                world.func_147468_f(x, y, z);
            }
            return false;
        }
        return true;
    }

    public void setFull(World world, int x, int y, int z, boolean full) {
        int meta = world.func_72805_g(x, y, z);
        switch (meta) {
            case 1: 
            case 5: {
                world.func_72921_c(x, y, z, full ? 5 : 1, 2);
                break;
            }
            case 2: 
            case 6: {
                world.func_72921_c(x, y, z, full ? 6 : 2, 2);
                break;
            }
            case 3: 
            case 7: {
                world.func_72921_c(x, y, z, full ? 7 : 3, 2);
                break;
            }
            case 4: 
            case 8: {
                world.func_72921_c(x, y, z, full ? 8 : 4, 2);
            }
        }
    }

    public boolean isFull(World world, int x, int y, int z) {
        return world.func_72805_g(x, y, z) >= 5;
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        if (!world.field_72995_K) {
            this.setFull(world, x, y, z, true);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int meta, int fortune) {
        if (world.field_72995_K) {
            return new ArrayList<ItemStack>();
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (meta < 5) {
            drops.add(ItemGeneric.createStack(BLItemRegistry.weedwoodBucket, 1, 0));
        } else {
            drops.add(ItemGeneric.createStack(BLItemRegistry.weedwoodBucketRubber, 1, 0));
        }
        drops.add(ItemGeneric.createStack(ItemGeneric.EnumItemGeneric.SWAMP_REED_ROPE));
        return drops;
    }
}

