/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.command.ICommand;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import thebetweenlands.blocks.BLBlockRegistry;
import thebetweenlands.blocks.BLFluidRegistry;
import thebetweenlands.command.CommandAspectDiscovery;
import thebetweenlands.command.CommandBLEvent;
import thebetweenlands.command.CommandDecay;
import thebetweenlands.command.CommandFindPage;
import thebetweenlands.command.CommandResetAspects;
import thebetweenlands.command.CommandTickSpeed;
import thebetweenlands.entities.BLEntityRegistry;
import thebetweenlands.entities.properties.BLEntityPropertiesRegistry;
import thebetweenlands.event.debugging.DebugHandlerChunkData;
import thebetweenlands.event.elixirs.ElixirCommonHandler;
import thebetweenlands.event.entity.AttackDamageHandler;
import thebetweenlands.event.entity.EntitySpawnHandler;
import thebetweenlands.event.entity.MiscEntitySyncHandler;
import thebetweenlands.event.entity.PageDiscoveringEvent;
import thebetweenlands.event.entity.PowerRingHandler;
import thebetweenlands.event.entity.RecruitmentRingHandler;
import thebetweenlands.event.entity.VolarPadGlideHandler;
import thebetweenlands.event.item.ItemEquipmentHandler;
import thebetweenlands.event.player.ArmorHandler;
import thebetweenlands.event.player.BonemealEventHandler;
import thebetweenlands.event.player.DecayEventHandler;
import thebetweenlands.event.player.FoodSicknessEventHandler;
import thebetweenlands.event.player.OverworldItemEventHandler;
import thebetweenlands.event.player.PlayerLocationHandler;
import thebetweenlands.event.player.PlayerPortalHandler;
import thebetweenlands.event.player.SiltCrabClipHandler;
import thebetweenlands.event.world.EnvironmentEventHandler;
import thebetweenlands.herblore.elixirs.ElixirEffectRegistry;
import thebetweenlands.items.BLItemRegistry;
import thebetweenlands.lib.ModInfo;
import thebetweenlands.mods.RecurrentComplexModule;
import thebetweenlands.network.base.IPacket;
import thebetweenlands.network.base.SidedPacketHandler;
import thebetweenlands.network.base.impl.CommonPacketProxy;
import thebetweenlands.network.base.impl.IDPacketObjectSerializer;
import thebetweenlands.network.message.MessageLoadAspects;
import thebetweenlands.network.message.MessageOpenPouch;
import thebetweenlands.network.message.MessagePouchNaming;
import thebetweenlands.network.message.MessageSyncEnvironmentEvent;
import thebetweenlands.network.message.MessageWeedwoodRowboatInput;
import thebetweenlands.network.packet.client.PacketEquipment;
import thebetweenlands.network.packet.client.PacketFlightState;
import thebetweenlands.network.packet.client.PacketPlayIdleSound;
import thebetweenlands.network.packet.client.PacketRecruitmentState;
import thebetweenlands.network.packet.client.PacketRingInput;
import thebetweenlands.network.packet.server.PacketAttackTarget;
import thebetweenlands.network.packet.server.PacketDruidAltarProgress;
import thebetweenlands.network.packet.server.PacketDruidTeleportParticle;
import thebetweenlands.network.packet.server.PacketGemProc;
import thebetweenlands.network.packet.server.PacketPowerRingHit;
import thebetweenlands.network.packet.server.PacketRevengeTarget;
import thebetweenlands.network.packet.server.PacketSnailHatchParticle;
import thebetweenlands.network.packet.server.PacketTickspeed;
import thebetweenlands.network.packet.server.PacketWeedWoodBushRustle;
import thebetweenlands.precondition.TheBetweenlandsPreconditions;
import thebetweenlands.proxy.CommonProxy;
import thebetweenlands.recipes.BLRecipes;
import thebetweenlands.utils.PotionHelper;
import thebetweenlands.utils.confighandler.ConfigHandler;
import thebetweenlands.world.BLGamerules;
import thebetweenlands.world.WorldProviderBetweenlands;
import thebetweenlands.world.biomes.base.BLBiomeRegistry;
import thebetweenlands.world.biomes.spawning.MobSpawnHandler;
import thebetweenlands.world.feature.structure.WorldGenDruidCircle;
import thebetweenlands.world.storage.chunk.BetweenlandsChunkData;
import thebetweenlands.world.storage.chunk.ChunkDataBase;
import thebetweenlands.world.storage.world.WorldDataBase;
import thebetweenlands.world.teleporter.TeleporterHandler;

@Mod(modid="thebetweenlands", name="The Betweenlands", version="1.0.6-alpha", guiFactory="thebetweenlands.utils.confighandler.ConfigGuiFactory")
public class TheBetweenlands {
    @SidedProxy(modId="thebetweenlands", clientSide="thebetweenlands.proxy.ClientProxy", serverSide="thebetweenlands.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="thebetweenlands")
    public static TheBetweenlands instance;
    public static SimpleNetworkWrapper networkWrapper;
    public static final SidedPacketHandler sidedPacketHandler;
    public static final IDPacketObjectSerializer packetRegistry;
    @SidedProxy(modId="thebetweenlands", clientSide="thebetweenlands.network.base.impl.ClientPacketProxy", serverSide="thebetweenlands.network.base.impl.CommonPacketProxy")
    public static CommonPacketProxy packetProxy;
    public static File dir;
    private static byte nextPacketId;
    public static ArrayList<String> unlocalizedNames;
    public static boolean isShadersModInstalled;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.INSTANCE.loadConfig(event);
        dir = event.getModConfigurationDirectory();
        BLFluidRegistry.init();
        BLBlockRegistry.init();
        BLBiomeRegistry.init();
        BLItemRegistry.init();
        BLEntityRegistry.init();
        PotionHelper.initPotionArray();
        ElixirEffectRegistry.registerElixirs();
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenDruidCircle(), (int)0);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        DimensionManager.registerProviderType((int)ModInfo.DIMENSION_ID, WorldProviderBetweenlands.class, (boolean)true);
        DimensionManager.registerDimension((int)ModInfo.DIMENSION_ID, (int)ModInfo.DIMENSION_ID);
        networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("thebetweenlands");
        networkWrapper.registerMessage(MessageSyncEnvironmentEvent.class, MessageSyncEnvironmentEvent.class, 4, Side.CLIENT);
        networkWrapper.registerMessage(MessageWeedwoodRowboatInput.class, MessageWeedwoodRowboatInput.class, 5, Side.SERVER);
        networkWrapper.registerMessage(MessageLoadAspects.class, MessageLoadAspects.class, 6, Side.CLIENT);
        BLEntityPropertiesRegistry.HANDLER.registerPacket(networkWrapper, 7);
        BetweenlandsChunkData.CHUNK_SYNC_HANDLER.registerPacket(networkWrapper, 8);
        networkWrapper.registerMessage(MessagePouchNaming.class, MessagePouchNaming.class, 9, Side.SERVER);
        networkWrapper.registerMessage(MessageOpenPouch.class, MessageOpenPouch.class, 10, Side.SERVER);
        sidedPacketHandler.setProxy(packetProxy).setNetworkWrapper(networkWrapper, 20, 21).setPacketSerializer(packetRegistry);
        TheBetweenlands.registerPacket(PacketDruidAltarProgress.class);
        TheBetweenlands.registerPacket(PacketDruidTeleportParticle.class);
        TheBetweenlands.registerPacket(PacketSnailHatchParticle.class);
        TheBetweenlands.registerPacket(PacketTickspeed.class);
        TheBetweenlands.registerPacket(PacketRevengeTarget.class);
        TheBetweenlands.registerPacket(PacketAttackTarget.class);
        TheBetweenlands.registerPacket(PacketWeedWoodBushRustle.class);
        TheBetweenlands.registerPacket(PacketGemProc.class);
        TheBetweenlands.registerPacket(PacketEquipment.class);
        TheBetweenlands.registerPacket(PacketPowerRingHit.class);
        TheBetweenlands.registerPacket(PacketRecruitmentState.class);
        TheBetweenlands.registerPacket(PacketPlayIdleSound.class);
        TheBetweenlands.registerPacket(PacketFlightState.class);
        TheBetweenlands.registerPacket(PacketRingInput.class);
    }

    private static void registerPacket(Class<? extends IPacket> packetClass) {
        byte by = nextPacketId;
        nextPacketId = (byte)(by + 1);
        packetRegistry.registerPacket(packetClass, by);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ArrayList<IRecipe> doorRecipes = new ArrayList<IRecipe>();
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            ItemStack stack;
            if (recipe == null || (stack = recipe.func_77571_b()) == null || stack.func_77973_b() != Items.field_151135_aq) continue;
            doorRecipes.add(recipe);
        }
        for (IRecipe recipe : doorRecipes) {
            CraftingManager.func_77594_a().func_77592_b().remove(recipe);
        }
        proxy.registerTileEntities();
        proxy.init();
        FMLCommonHandler.instance().bus().register((Object)ConfigHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)DecayEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)BLFluidRegistry.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new ArmorHandler());
        MinecraftForge.EVENT_BUS.register((Object)new OverworldItemEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new OverworldItemEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)DecayEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerPortalHandler());
        MinecraftForge.EVENT_BUS.register((Object)PowerRingHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)PowerRingHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new PageDiscoveringEvent());
        FMLCommonHandler.instance().bus().register((Object)EnvironmentEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)EnvironmentEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)new BonemealEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SiltCrabClipHandler());
        MinecraftForge.EVENT_BUS.register((Object)new MiscEntitySyncHandler());
        MinecraftForge.EVENT_BUS.register((Object)AttackDamageHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ElixirCommonHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)ElixirCommonHandler.INSTANCE);
        BLEntityPropertiesRegistry.HANDLER.registerHandler();
        FMLCommonHandler.instance().bus().register((Object)MobSpawnHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)MobSpawnHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)WorldDataBase.WORLD_UNLOAD_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)BetweenlandsChunkData.CHUNK_SYNC_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)FoodSicknessEventHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)FoodSicknessEventHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)EntitySpawnHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ItemEquipmentHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)ItemEquipmentHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)DebugHandlerChunkData.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)ChunkDataBase.CHUNK_DATA_HANDLER);
        FMLCommonHandler.instance().bus().register((Object)ChunkDataBase.CHUNK_DATA_HANDLER);
        MinecraftForge.EVENT_BUS.register((Object)PlayerLocationHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)PlayerLocationHandler.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)RecruitmentRingHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)RecruitmentRingHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)BLItemRegistry.ringOfFlight);
        MinecraftForge.EVENT_BUS.register((Object)new VolarPadGlideHandler());
        MinecraftForge.EVENT_BUS.register((Object)BLItemRegistry.volarkite);
        BLRecipes.init();
        TeleporterHandler.init();
        CraftingManager.func_77594_a().func_77592_b().addAll(doorRecipes);
        RecurrentComplexModule.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        if (ConfigHandler.DEBUG) {
            System.out.println("==================================================");
            for (String name : unlocalizedNames) {
                System.out.println("needs translation: " + name);
            }
            System.out.println("==================================================");
        }
        try {
            Class.forName("shadersmod.client.Shaders");
            isShadersModInstalled = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBLEvent());
        event.registerServerCommand((ICommand)new CommandResetAspects());
        event.registerServerCommand((ICommand)new CommandDecay());
        event.registerServerCommand((ICommand)new CommandFindPage());
        event.registerServerCommand((ICommand)new CommandAspectDiscovery());
        if (ConfigHandler.DEBUG) {
            event.registerServerCommand((ICommand)new CommandTickSpeed());
        }
        BLGamerules.INSTANCE.onServerStarting(event);
    }

    @Mod.InstanceFactory
    public static TheBetweenlands createInstance() {
        TheBetweenlandsPreconditions.check();
        return new TheBetweenlands();
    }

    static {
        sidedPacketHandler = new SidedPacketHandler();
        packetRegistry = new IDPacketObjectSerializer();
        nextPacketId = 0;
        unlocalizedNames = new ArrayList();
        isShadersModInstalled = false;
    }
}

