/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.registry;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.shared.TinkerCommons;
import slimeknights.tconstruct.shared.TinkerFluids;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;
import slimeknights.tconstruct.smeltery.block.BlockCasting;
import tinker_io.handler.CrushedOreMeltingRegistry;
import tinker_io.handler.PureMetalCastingRegistry;
import tinker_io.handler.SORecipe;
import tinker_io.registry.FluidRegister;

public class SmelteryRecipeRegistry {
    public int VALUE_Ingot = 144;

    public static void registerMeltingCasting() {
        CrushedOreMeltingRegistry.registerCrushedOre();
        PureMetalCastingRegistry.registerPureMetalCasting();
        FluidStack fluidStackCobalt = new FluidStack((Fluid)FluidRegister.pureMetal, 144, new NBTTagCompound());
        fluidStackCobalt.tag.func_74778_a("oreDic", "oreCobalt");
        SmelteryRecipeRegistry.registerSmartOutputCasting(TinkerCommons.ingotCobalt, TinkerSmeltery.castIngot, fluidStackCobalt);
        FluidStack fluidStackArdite = new FluidStack((Fluid)FluidRegister.pureMetal, 144, new NBTTagCompound());
        fluidStackArdite.tag.func_74778_a("oreDic", "oreArdite");
        SmelteryRecipeRegistry.registerSmartOutputCasting(TinkerCommons.ingotArdite, TinkerSmeltery.castIngot, fluidStackArdite);
        SmelteryRecipeRegistry.registerSmartOutputCasting(new ItemStack(TinkerCommons.blockClearGlass, 1), new ItemStack((Block)TinkerSmeltery.castingBlock, 1, BlockCasting.CastingType.BASIN.getMeta()), new FluidStack((Fluid)TinkerFluids.glass, 1000));
    }

    public static void registerMeltingWithNBT(ItemStack inputItem, FluidStack outputFluidStack, int meltingTime) {
        TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.ItemCombination.ofNBT((ItemStack)inputItem, (int)outputFluidStack.amount), outputFluidStack, meltingTime));
    }

    public static void registerMelting(Item item, Fluid fluid, int outputAmount, int meltingTime) {
        TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((Item)item, (int)outputAmount), fluid, meltingTime));
    }

    public static void registerTableCasting(ItemStack output, ItemStack cast, FluidStack fluid) {
        TinkerRegistry.registerTableCasting((CastingRecipe)new CastingRecipe(output, RecipeMatch.of((Item)cast.func_77973_b()), fluid, false, true));
    }

    public static void registerSmartOutputCasting(ItemStack output, ItemStack cast, FluidStack fluid) {
        SORecipe.registerTableCastingWithFluidStack(new CastingRecipe(output, RecipeMatch.of((ItemStack)cast), fluid, false, true));
    }
}

