/*
 * Decompiled with CFR 0.152.
 */
package com.miningmark48.pearcelmod.handler;

import com.miningmark48.pearcelmod.utility.Translate;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigurationHandler {
    public static Configuration configuration;
    public static boolean doWorldGen;
    public static boolean doSpecialWorldGen;
    public static boolean doEnderPearcelCooldown;
    public static int torcherRange;
    public static int torcherFrequency;
    public static int maxStaffFlyHeight;
    public static int enderPearcelCooldownTime;
    public static float enderPearcelVelocity;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("pearcelmod")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        doWorldGen = configuration.getBoolean(Translate.toLocal("config.doWorldGen.title"), "general", true, Translate.toLocal("config.doWorldGen.desc"));
        doSpecialWorldGen = configuration.getBoolean(Translate.toLocal("config.doSpecialWorldGen.title"), "general", true, Translate.toLocal("config.doSpecialWorldGen.desc"));
        torcherRange = configuration.getInt(Translate.toLocal("config.torcherRange.title"), "general", 25, 1, Integer.MAX_VALUE, Translate.toLocal("config.torcherRange.desc"));
        torcherFrequency = configuration.getInt(Translate.toLocal("config.torcherFrequency.title"), "general", 2, 2, Integer.MAX_VALUE, Translate.toLocal("config.torcherFrequency.desc"));
        maxStaffFlyHeight = configuration.getInt(Translate.toLocal("config.maxStaffFlyHeight.title"), "general", 150, 1, 256, Translate.toLocal("config.maxStaffFlyHeight.desc"));
        enderPearcelVelocity = configuration.getFloat(Translate.toLocal("config.enderPearcelVelocity.title"), "general", 3.0f, 1.0f, Float.MAX_VALUE, Translate.toLocal("config.enderPearcelVelocity.desc"));
        doEnderPearcelCooldown = configuration.getBoolean(Translate.toLocal("config.doEnderPearcelCooldown.title"), "general", true, Translate.toLocal("config.doEnderPearcelCooldown.desc"));
        enderPearcelCooldownTime = configuration.getInt(Translate.toLocal("config.enderPearcelCooldownTime.title"), "general", 1, 1, Integer.MAX_VALUE, Translate.toLocal("config.enderPearcelCooldownTime.desc"));
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }
}

