/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mca.ai.AIMood;
import mca.ai.AIProcreate;
import mca.ai.AISleep;
import mca.api.RegistryMCA;
import mca.core.MCA;
import mca.core.minecraft.ModAchievements;
import mca.core.minecraft.ModItems;
import mca.data.NBTPlayerData;
import mca.data.PlayerMemory;
import mca.entity.EntityHuman;
import mca.enums.EnumDialogueType;
import mca.enums.EnumInteraction;
import mca.enums.EnumPersonality;
import mca.items.ItemBaby;
import mca.packets.PacketSetTutorialMessage;
import mca.util.MarriageHandler;
import mca.util.TutorialManager;
import mca.util.TutorialMessage;
import mca.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import radixcore.network.ByteBufIO;
import radixcore.packets.AbstractPacket;
import radixcore.util.BlockHelper;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;

public class PacketInteract
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketInteract, IMessage> {
    private int buttonId;
    private int entityId;
    private int numAdditionalData;
    private Object[] additionalData;

    public PacketInteract() {
    }

    public PacketInteract(int buttonId, int entityId) {
        this.buttonId = buttonId;
        this.entityId = entityId;
    }

    public PacketInteract(int buttonId, int entityId, Object ... additionalData) {
        this.buttonId = buttonId;
        this.entityId = entityId;
        this.numAdditionalData = additionalData.length;
        this.additionalData = additionalData;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.buttonId = byteBuf.readInt();
        this.entityId = byteBuf.readInt();
        this.numAdditionalData = byteBuf.readInt();
        this.additionalData = new Object[this.numAdditionalData];
        for (int i = 0; i < this.numAdditionalData; ++i) {
            this.additionalData[i] = ByteBufIO.readObject((ByteBuf)byteBuf);
        }
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.buttonId);
        byteBuf.writeInt(this.entityId);
        byteBuf.writeInt(this.numAdditionalData);
        if (this.numAdditionalData > 0) {
            for (Object obj : this.additionalData) {
                ByteBufIO.writeObject((ByteBuf)byteBuf, (Object)obj);
            }
        }
    }

    public IMessage onMessage(PacketInteract packet, MessageContext context) {
        MCA.getPacketHandler().addPacketForProcessing(context.side, packet, context);
        return null;
    }

    public void processOnGameThread(IMessageHandler message, MessageContext context) {
        PacketInteract packet = (PacketInteract)message;
        EntityHuman villager = null;
        EntityPlayer player = null;
        for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            player = this.getPlayer(context);
            villager = (EntityHuman)world.func_73045_a(packet.entityId);
            if (player != null && villager != null) break;
        }
        if (player != null && villager != null) {
            PlayerMemory memory;
            EnumInteraction interaction = EnumInteraction.fromId(packet.buttonId);
            if (interaction == EnumInteraction.SET_HOME) {
                if (villager.getAI(AISleep.class).setHomePoint(villager.field_70165_t, villager.field_70163_u, villager.field_70161_v)) {
                    villager.say("interaction.sethome.success", player);
                    TutorialManager.sendMessageToPlayer(player, "Villagers go to their home points at night, and then go to sleep.", "If their home point becomes blocked, they will automatically find a new one.");
                } else {
                    Block block = null;
                    int iPosX = (int)villager.field_70165_t;
                    int iPosY = (int)villager.field_70163_u;
                    int iPosZ = (int)villager.field_70161_v;
                    if (!Utilities.isPointClear(villager.field_70170_p, iPosX, iPosY, iPosZ)) {
                        block = BlockHelper.getBlock((World)villager.field_70170_p, (int)iPosX, (int)iPosY, (int)iPosZ);
                    } else if (!Utilities.isPointClear(villager.field_70170_p, iPosX, iPosY + 1, iPosZ)) {
                        block = BlockHelper.getBlock((World)villager.field_70170_p, (int)iPosX, (int)(iPosY + 1), (int)iPosZ);
                    }
                    if (block != null) {
                        villager.say("interaction.sethome.fail", player, block.func_149732_F().toLowerCase());
                    }
                    TutorialManager.sendMessageToPlayer(player, "Move villagers away from the edges of walls", "and other blocks before setting their home.");
                }
            } else if (interaction == EnumInteraction.TRADE) {
                villager.func_70932_a_(player);
                player.func_180472_a((IMerchant)villager);
            } else if (interaction == EnumInteraction.PICK_UP) {
                villager.func_184220_m((Entity)player);
            } else if (interaction == EnumInteraction.TAKE_GIFT) {
                PlayerMemory memory2 = villager.getPlayerMemory(player);
                memory2.setHasGift(false);
                ItemStack stack = RegistryMCA.getGiftStackFromRelationship(memory2.getHearts());
                villager.func_145779_a(stack.func_77973_b(), stack.field_77994_a);
            } else if (interaction == EnumInteraction.CHAT || interaction == EnumInteraction.JOKE || interaction == EnumInteraction.SHAKE_HAND || interaction == EnumInteraction.TELL_STORY || interaction == EnumInteraction.FLIRT || interaction == EnumInteraction.HUG || interaction == EnumInteraction.KISS) {
                AIMood mood = villager.getAI(AIMood.class);
                PlayerMemory memory3 = villager.getPlayerMemory(player);
                if (memory3.getDialogueType() == EnumDialogueType.SPOUSE && memory3.getHearts() <= 25 && villager.timesWarnedForLowHearts >= 3) {
                    villager.say("spouse.endmarriage", player, player);
                    player.func_146105_b((ITextComponent)new TextComponentString("\u00a7C" + MCA.getLanguageManager().getString("notify.spouseendedmarriage", new Object[]{villager})));
                    memory3.setHearts(-100);
                    mood.modifyMoodLevel(-20.0f);
                    villager.timesWarnedForLowHearts = 0;
                    MarriageHandler.endMarriage(player, villager);
                } else {
                    int successChance = interaction.getSuccessChance(villager, memory3);
                    int pointsModification = interaction.getBasePoints() + villager.getPersonality().getHeartsModifierForInteraction(interaction) + mood.getMood(villager.getPersonality()).getPointsModifierForInteraction(interaction);
                    boolean wasGood = RadixLogic.getBooleanWithProbability((int)successChance);
                    if (villager.getPersonality() == EnumPersonality.FRIENDLY) {
                        pointsModification = (int)((double)pointsModification + (double)pointsModification * 0.15);
                    } else if (villager.getPersonality() == EnumPersonality.FLIRTY) {
                        pointsModification = (int)((double)pointsModification + (double)pointsModification * 0.25);
                    } else if (villager.getPersonality() == EnumPersonality.SENSITIVE && RadixLogic.getBooleanWithProbability((int)5)) {
                        pointsModification = -35;
                        wasGood = false;
                    } else if (villager.getPersonality() == EnumPersonality.STUBBORN) {
                        pointsModification = (int)((double)pointsModification - (double)pointsModification * 0.15);
                    }
                    if (wasGood) {
                        pointsModification = RadixMath.clamp((int)pointsModification, (int)1, (int)100);
                        mood.modifyMoodLevel(RadixMath.getNumberInRange((float)0.2f, (float)1.0f));
                        villager.say(memory3.getDialogueType().toString() + "." + interaction.getName() + ".good", player);
                    } else {
                        pointsModification = RadixMath.clamp((int)(pointsModification * -1), (int)-100, (int)-1);
                        mood.modifyMoodLevel(RadixMath.getNumberInRange((float)0.2f, (float)1.0f) * -1.0f);
                        villager.say(memory3.getDialogueType().toString() + "." + interaction.getName() + ".bad", player);
                    }
                    memory3.setHearts(memory3.getHearts() + pointsModification);
                    memory3.increaseInteractionFatigue();
                    if (memory3.getHearts() >= 100) {
                        player.func_71029_a((StatBase)ModAchievements.fullGoldHearts);
                    }
                    if (memory3.getInteractionFatigue() == 4) {
                        TutorialManager.sendMessageToPlayer(player, "Villagers tire of conversation after a few tries.", "Talk to them later for better success chances.");
                    }
                }
            } else if (interaction == EnumInteraction.STOP) {
                villager.getAIManager().disableAllToggleAIs();
            } else if (interaction == EnumInteraction.INVENTORY) {
                villager.openInventory(player);
            } else if (interaction == EnumInteraction.RIDE_HORSE) {
                if (villager.func_184187_bx() != null) {
                    EntityHorse horse = (EntityHorse)villager.func_184187_bx();
                    horse.func_110251_o(true);
                    villager.func_184210_p();
                } else {
                    EntityHorse horse = (EntityHorse)RadixLogic.getNearestEntityOfTypeWithinDistance(EntityHorse.class, (Entity)villager, (int)5);
                    if (horse != null) {
                        if (horse.func_110257_ck() && !horse.func_184207_aI()) {
                            villager.func_184220_m((Entity)horse);
                        } else {
                            villager.say("interaction.ridehorse.fail.notrideable", player);
                        }
                    } else {
                        villager.say("interaction.ridehorse.fail.notnearby", player);
                    }
                }
            } else if (interaction == EnumInteraction.DIVORCE) {
                NBTPlayerData data = MCA.getPlayerData(player);
                if (data.getSpousePermanentId() != 0) {
                    villager.say("interaction.divorce.priest.success", player);
                    EntityHuman spouse = MCA.getHumanByPermanentId(data.getSpousePermanentId());
                    if (spouse != null) {
                        MarriageHandler.endMarriage(player, spouse);
                        memory = spouse.getPlayerMemory(player);
                        spouse.getAI(AIMood.class).modifyMoodLevel(-5.0f);
                        memory.setHearts(-100);
                    }
                    MarriageHandler.forceEndMarriage(player);
                } else {
                    villager.say("interaction.divorce.priest.fail.notmarried", player);
                }
            } else if (interaction == EnumInteraction.RESETBABY) {
                NBTPlayerData data = MCA.getPlayerData(player);
                if (data.getShouldHaveBaby()) {
                    villager.say("interaction.resetbaby.success", player);
                    data.setShouldHaveBaby(false);
                    for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                        ItemStack stack = player.field_71071_by.func_70301_a(i);
                        if (stack == null || !(stack.func_77973_b() instanceof ItemBaby)) continue;
                        ItemBaby baby = (ItemBaby)stack.func_77973_b();
                        if (!stack.func_77978_p().func_74779_i("owner").equals(player.func_70005_c_())) continue;
                        player.field_71071_by.func_70299_a(i, null);
                    }
                } else {
                    villager.say("interaction.resetbaby.fail", player);
                }
            } else if (interaction == EnumInteraction.ADOPTBABY) {
                NBTPlayerData data = MCA.getPlayerData(player);
                if (this.getIsOverChildrenCount(player)) {
                    player.func_145747_a((ITextComponent)new TextComponentString("\u00a7CYou have too many children."));
                } else if (!data.getShouldHaveBaby()) {
                    boolean isMale = RadixLogic.getBooleanWithProbability((int)50);
                    String babyName = isMale ? MCA.getLanguageManager().getString("name.male") : MCA.getLanguageManager().getString("name.female");
                    villager.say("interaction.adoptbaby.success", player, babyName);
                    ItemStack stack = new ItemStack((Item)(isMale ? ModItems.babyBoy : ModItems.babyGirl));
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74778_a("name", babyName);
                    nbt.func_74768_a("age", 0);
                    nbt.func_74778_a("owner", player.func_70005_c_());
                    stack.func_77982_d(nbt);
                    player.field_71071_by.func_70441_a(stack);
                    data.setShouldHaveBaby(true);
                } else {
                    villager.say("interactionp.havebaby.fail.alreadyexists", player);
                }
            } else if (interaction == EnumInteraction.ACCEPT) {
                Integer length = (Integer)packet.additionalData[0];
                Boolean isExtending = (Boolean)packet.additionalData[1];
                memory = villager.getPlayerMemory(player);
                if (isExtending.booleanValue()) {
                    memory.setIsHiredBy(true, memory.getHireTimeLeft() + length * 60);
                } else {
                    memory.setIsHiredBy(true, length * 60);
                }
                int currentSlot = 0;
                for (int i = 0; i < 3; ++i) {
                    int slot = -1;
                    while (currentSlot < player.field_71071_by.field_70462_a.length) {
                        ItemStack stack = player.field_71071_by.field_70462_a[currentSlot];
                        if (stack != null && stack.func_77973_b() == Items.field_151043_k) {
                            slot = currentSlot;
                            break;
                        }
                        ++currentSlot;
                    }
                    if (slot <= -1) continue;
                    player.field_71071_by.func_70298_a(slot, 1);
                }
            } else if (interaction == EnumInteraction.PROCREATE) {
                NBTPlayerData playerData = MCA.getPlayerData(player);
                if (this.getIsOverChildrenCount(player)) {
                    player.func_145747_a((ITextComponent)new TextComponentString("\u00a7CYou have too many children."));
                } else if (playerData.getShouldHaveBaby()) {
                    player.func_145747_a((ITextComponent)new TextComponentString("\u00a7CYou already have a baby."));
                } else {
                    villager.getAI(AIProcreate.class).setIsProcreating(true);
                }
            } else if (interaction == EnumInteraction.DISMISS) {
                PlayerMemory memory4 = villager.getPlayerMemory(player);
                memory4.setIsHiredBy(false, 0);
            } else if (interaction == EnumInteraction.TAXES) {
                List villagerList = RadixLogic.getAllEntitiesOfTypeWithinDistance(EntityHuman.class, (Entity)villager, (int)50);
                int percentAverage = this.getVillageHappinessPercentage(villager, player, villagerList);
                if (percentAverage != -1) {
                    PlayerMemory thisMemory = villager.getPlayerMemory(player);
                    Item dropItem = RadixLogic.getBooleanWithProbability((int)3) ? Items.field_151045_i : (RadixLogic.getBooleanWithProbability((int)50) ? Items.field_151074_bl : Items.field_151042_j);
                    int happinessLevel = MathHelper.func_76125_a((int)Math.round(percentAverage / 25), (int)0, (int)4);
                    int itemsDropped = RadixMath.getNumberInRange((int)Math.round((float)happinessLevel / 2.0f), (int)(happinessLevel * 2));
                    if (itemsDropped == 0) {
                        ++itemsDropped;
                    }
                    if (dropItem == Items.field_151045_i) {
                        itemsDropped = MathHelper.func_76125_a((int)itemsDropped, (int)1, (int)5);
                    }
                    if (happinessLevel <= 2) {
                        MCA.getPacketHandler().sendPacketToPlayer(new PacketSetTutorialMessage(new TutorialMessage("Unhappy villagers do not like being taxed, and will contribute less.", "Increase their happiness by maintaining high hearts with them.")), (EntityPlayerMP)player);
                    }
                    for (Entity entity : villagerList) {
                        if (!RadixLogic.getBooleanWithProbability((int)50)) continue;
                        EntityHuman human = (EntityHuman)entity;
                        PlayerMemory memory5 = human.getPlayerMemory(player);
                        memory5.setHearts(memory5.getHearts() - RadixMath.getNumberInRange((int)3, (int)8));
                    }
                    villager.func_70099_a(new ItemStack(dropItem, itemsDropped), 1.0f);
                    villager.say("interaction.tax.happylevel" + happinessLevel, player);
                    thisMemory.setTaxResetCounter(20);
                } else {
                    villager.say("interaction.tax.notlargeenough", player);
                }
            } else if (interaction == EnumInteraction.CHECKHAPPINESS) {
                NBTPlayerData data = MCA.getPlayerData(player);
                List villagerList = RadixLogic.getAllEntitiesOfTypeWithinDistance(EntityHuman.class, (Entity)villager, (int)50);
                int happinessPercent = this.getVillageHappinessPercentage(villager, player, villagerList);
                int requiredVillagers = 10 - villagerList.size();
                boolean flag = false;
                if (happinessPercent == -1) {
                    villager.say("interaction.checkhappiness.fail", player, requiredVillagers);
                } else {
                    villager.say("interaction.checkhappiness.success", player, happinessPercent);
                    if (happinessPercent > 80) {
                        TutorialManager.sendMessageToPlayer(player, "Once your village's happiness is at 80% or more they may", "soon ask you to become a baron or baroness.");
                        flag = true;
                    }
                }
                if (!data.getIsNobility()) {
                    data.setHappinessThresholdMet(flag);
                }
            } else if (interaction == EnumInteraction.NOBILITY_PROMPT_ACCEPT) {
                NBTPlayerData data = MCA.getPlayerData(player);
                data.setIsNobility(true);
                data.setHappinessThresholdMet(false);
            }
        }
    }

    private boolean getIsOverChildrenCount(EntityPlayer player) {
        int childrenCount = 0;
        for (Object obj : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c[0].field_72996_f) {
            EntityHuman human;
            if (!(obj instanceof EntityHuman) || !(human = (EntityHuman)((Object)obj)).isPlayerAParent(player)) continue;
            ++childrenCount;
        }
        return childrenCount >= MCA.getConfig().childLimit && MCA.getConfig().childLimit != -1;
    }

    private int getVillageHappinessPercentage(EntityHuman villager, EntityPlayer player, List<Entity> villagerList) {
        int villagersInArea = villagerList.size();
        if (villagersInArea >= 10) {
            int totalHearts = 0;
            int percentAverage = 0;
            double averageHearts = 0.0;
            for (Entity entity : villagerList) {
                EntityHuman human = (EntityHuman)entity;
                PlayerMemory memory = human.getPlayerMemory(player);
                totalHearts += MathHelper.func_76125_a((int)memory.getHearts(), (int)-100, (int)100);
            }
            averageHearts = (float)totalHearts / (float)(villagersInArea * 100);
            percentAverage = (int)(averageHearts * 100.0);
            return percentAverage;
        }
        return -1;
    }
}

