/*
 * Decompiled with CFR 0.152.
 */
package mca.items;

import java.util.List;
import mca.core.MCA;
import mca.core.minecraft.ModBlocks;
import mca.data.VillagerSaveData;
import mca.enums.EnumMemorialType;
import mca.enums.EnumProfession;
import mca.enums.EnumRelation;
import mca.tile.TileMemorial;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.lwjgl.input.Keyboard;
import radixcore.util.BlockHelper;

public class ItemMemorial
extends Item {
    private EnumMemorialType type;

    public ItemMemorial(EnumMemorialType type) {
        this.type = type;
        this.func_77655_b(type.getTypeName());
        GameRegistry.registerItem((Item)this, (String)type.getTypeName());
        this.func_77637_a(MCA.getCreativeTabMain());
        this.func_77625_d(1);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && stack.func_77942_o()) {
            int posX = pos.func_177958_n();
            int posY = pos.func_177956_o() + 1;
            int posZ = pos.func_177952_p();
            pos = new BlockPos(posX, posY, posZ);
            worldIn.func_180501_a(pos, ModBlocks.memorial.func_176223_P(), 2);
            TileMemorial tile = (TileMemorial)BlockHelper.getTileEntity((World)worldIn, (int)posX, (int)posY, (int)posZ);
            tile.setType(this.type);
            tile.setVillagerSaveData(VillagerSaveData.fromNBT(stack.func_77978_p()));
            tile.setOwnerName(stack.func_77978_p().func_74779_i("ownerName"));
            if (stack.func_77942_o()) {
                tile.setRelation(EnumRelation.getById(stack.func_77978_p().func_74762_e("relation")));
            } else {
                tile.setRelation(EnumRelation.NONE);
            }
            playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, null);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List infoList, boolean unknown) {
        super.func_77624_a(itemStack, entityPlayer, infoList, unknown);
        if (itemStack.func_77942_o()) {
            VillagerSaveData data = VillagerSaveData.fromNBT(itemStack.func_77978_p());
            String ownerName = itemStack.func_77978_p().func_74779_i("ownerName");
            String name = data.name;
            String relationId = EnumRelation.getById(itemStack.func_77978_p().func_74762_e("relation")).getPhraseId();
            infoList.add("\u00a7FBelonged to: ");
            if (!relationId.equals("relation.none")) {
                infoList.add("\u00a7A" + name + ", " + MCA.getLanguageManager().getString(relationId) + " of " + ownerName);
            } else {
                infoList.add("\u00a7A" + name + " the " + MCA.getLanguageManager().getString(EnumProfession.getProfessionById(data.professionId).getLocalizationId()));
                infoList.add("Captured by: " + ownerName);
            }
        } else {
            infoList.add("\u00a7ACREATIVE \u00a7r- No villager attached.");
            infoList.add("Right-click a villager to attach them");
            infoList.add("to this object.");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            infoList.add("");
            infoList.add("An item once owned by a");
            infoList.add("villager who has died. Revive ");
            infoList.add("them using the \u00a7EStaff of Life\u00a77.");
        } else {
            infoList.add("");
            infoList.add("Hold \u00a7ESHIFT\u00a77 for info.");
        }
    }
}

