/*
 * Decompiled with CFR 0.152.
 */
package mca.client.render;

import java.util.ArrayList;
import mca.ai.AISleep;
import mca.client.gui.GuiInteraction;
import mca.client.gui.GuiVillagerEditor;
import mca.client.model.ModelHuman;
import mca.core.MCA;
import mca.data.PlayerMemory;
import mca.entity.EntityHuman;
import mca.util.UVPoint;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.client.renderer.entity.layers.LayerHeldItem;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;
import radixcore.client.render.RenderHelper;
import radixcore.util.RadixMath;

public class RenderHuman<T extends EntityHuman>
extends RenderBiped<T> {
    private static final ResourceLocation gui = new ResourceLocation("mca:textures/gui.png");
    private static final UVPoint exMark = new UVPoint(55, 18, 3, 13);
    private static final UVPoint minus = new UVPoint(69, 23, 7, 3);
    private static final UVPoint plus = new UVPoint(85, 21, 7, 7);
    private static final float LABEL_SCALE = 0.027f;

    public RenderHuman() {
        super(Minecraft.func_71410_x().func_175598_ae(), (ModelBiped)new ModelHuman(), 0.5f);
        this.func_177094_a((LayerRenderer)new LayerHeldItem((RenderLivingBase)this));
        this.func_177094_a((LayerRenderer)new LayerBipedArmor((RenderLivingBase)this));
    }

    protected void preRenderCallback(EntityHuman entityLivingBase, float partialTickTime) {
        float scale;
        EntityHuman entity = entityLivingBase;
        AISleep sleepAI = entity.getAI(AISleep.class);
        float f = scale = entity.getIsMale() ? 0.9375f : 0.915f;
        if (entity.getIsChild()) {
            boolean doGradualGrowth = MCA.getConfig().isAgingEnabled;
            float growthFactor = (entity.getIsMale() ? 0.39f : 0.37f) / (float)MCA.getConfig().childGrowUpTime * (float)entity.func_70654_ax();
            scale = 0.55f + growthFactor;
            if (entityLivingBase.func_184187_bx() != null) {
                if (entityLivingBase.func_184187_bx() instanceof EntityHorse) {
                    GL11.glTranslated((double)0.0, (double)((double)growthFactor - 0.3), (double)0.2);
                } else {
                    GL11.glTranslated((double)0.0, (double)((double)growthFactor + 0.1), (double)0.4);
                }
            }
        }
        GL11.glScalef((float)scale, (float)(scale + entity.getHeight()), (float)scale);
        GL11.glScalef((float)(scale + entity.getGirth()), (float)scale, (float)(scale + entity.getGirth()));
        if (entityLivingBase.func_184187_bx() != null && entityLivingBase.func_184187_bx() instanceof EntityHorse) {
            GL11.glTranslated((double)0.0, (double)0.55, (double)0.1);
        }
    }

    private void doRenderEntity(EntityHuman entity, double x, double y, double z, float entityYaw, float partialTicks) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        PlayerMemory memory = entity.getPlayerMemoryWithoutCreating((EntityPlayer)player);
        if (!entity.getDoDisplay()) {
            return;
        }
        if (RadixMath.getDistanceToEntity((Entity)entity, (Entity)player) <= 5.0 && !entity.getAI(AISleep.class).getIsSleeping() && !entity.isInteractionGuiOpen && memory != null) {
            UVPoint uvp;
            UVPoint uVPoint = memory.doDisplayFeedback() ? (memory.getLastInteractionSuccess() ? plus : minus) : (uvp = memory.getHasQuest() ? exMark : null);
            if (uvp != null) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)x), (float)((float)y + entity.field_70131_O + 0.25f + 0.5f), (float)((float)z));
                GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)-0.027f, (float)-0.027f, (float)0.027f);
                GL11.glDisable((int)2896);
                GL11.glTranslatef((float)0.0f, (float)9.259259f, (float)0.0f);
                RenderHelper.drawTexturedRectangle((ResourceLocation)gui, (int)((int)x), (int)((int)y + 12), (int)uvp.getU(), (int)uvp.getV(), (int)uvp.getWidth(), (int)uvp.getHeight());
                GL11.glPopMatrix();
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2896);
            }
        }
        double posYCorrection = y - entity.func_70033_W();
        if (entity.func_70093_af()) {
            posYCorrection -= 0.125;
        }
        super.func_76986_a((EntityLiving)entity, x, posYCorrection, z, entityYaw, partialTicks);
    }

    private void doRenderEffects(EntityHuman entity, double x, double y, double z, float entityYaw, float partialTicks) {
        int currentHealth = (int)entity.func_110143_aJ();
        int maxHealth = (int)entity.func_110138_aP();
        double distanceFromPlayer = RadixMath.getDistanceToEntity((Entity)entity, (Entity)Minecraft.func_71410_x().field_71439_g);
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiVillagerEditor) {
            return;
        }
        if (currentHealth < maxHealth) {
            this.renderLabel(entity, x, y, z, MCA.getLanguageManager().getString("label.health") + currentHealth + "/" + maxHealth);
        } else if (this.canRenderNameTag((EntityLivingBase)entity) && MCA.getConfig().showNameTagOnHover) {
            this.renderLabel(entity, x, y, z, entity.getTitle((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
        } else if (entity.isInteractionGuiOpen) {
            this.renderLabel(entity, x, y + distanceFromPlayer / 15.0 + (double)entity.getHeight() * 1.15, z, entity.getTitle((EntityPlayer)Minecraft.func_71410_x().field_71439_g));
            this.renderHearts(entity, x, y + distanceFromPlayer / 15.0 + (double)entity.getHeight() * 1.15, z, entity.getPlayerMemory((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getHearts());
        } else if (entity.getAIManager().isToggleAIActive()) {
            this.renderLabel(entity, x, y + distanceFromPlayer / 15.0 + (double)entity.getHeight() * 1.15, z, entity.getAIManager().getNameOfActiveAI());
        }
    }

    private void renderHearts(EntityHuman human, double posX, double posY, double posZ, int heartsLevel) {
        try {
            int clampedHearts = RadixMath.clamp((int)((Math.abs(heartsLevel) + 5) / 10), (int)0, (int)10);
            boolean isNegative = heartsLevel < 0;
            int goldHearts = isNegative ? 0 : clampedHearts - 5;
            int heartU = 5;
            int goldHeartU = 37;
            int negHeartU = 21;
            clampedHearts = RadixMath.clamp((int)clampedHearts, (int)0, (int)5);
            ArrayList<Integer> heartsToDraw = new ArrayList<Integer>();
            while (goldHearts > 0) {
                heartsToDraw.add(37);
                --goldHearts;
            }
            while (heartsToDraw.size() < clampedHearts) {
                if (isNegative) {
                    heartsToDraw.add(21);
                    continue;
                }
                heartsToDraw.add(5);
            }
            if (!heartsToDraw.isEmpty()) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)posX + 0.0f), (float)((float)posY + human.field_70131_O + 0.25f), (float)((float)posZ));
                GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)this.field_76990_c.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)-0.027f, (float)-0.027f, (float)0.027f);
                GL11.glDisable((int)2896);
                GL11.glTranslatef((float)0.0f, (float)9.259259f, (float)0.0f);
                switch (heartsToDraw.size()) {
                    case 1: {
                        RenderHelper.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + 20 - 22), (int)((int)posY - 4), (int)((Integer)heartsToDraw.get(0)), (int)20, (int)9, (int)9);
                        break;
                    }
                    case 2: {
                        for (int i = 0; i < 2; ++i) {
                            RenderHelper.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + 10 * i - 9), (int)((int)posY - 4), (int)((Integer)heartsToDraw.get(i)), (int)20, (int)9, (int)9);
                        }
                        break;
                    }
                    case 3: {
                        for (int i = 0; i < 3; ++i) {
                            RenderHelper.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + 10 * i - 14), (int)((int)posY - 4), (int)((Integer)heartsToDraw.get(i)), (int)20, (int)9, (int)9);
                        }
                        break;
                    }
                    case 4: {
                        for (int i = 0; i < 4; ++i) {
                            RenderHelper.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + 10 * i - 19), (int)((int)posY - 4), (int)((Integer)heartsToDraw.get(i)), (int)20, (int)9, (int)9);
                        }
                        break;
                    }
                    case 5: {
                        for (int i = 0; i < 5; ++i) {
                            RenderHelper.drawTexturedRectangle((ResourceLocation)gui, (int)((int)posX + 10 * i - 23), (int)((int)posY - 4), (int)((Integer)heartsToDraw.get(i)), (int)20, (int)9, (int)9);
                        }
                        break;
                    }
                }
                GL11.glPopMatrix();
                GL11.glDepthMask((boolean)true);
                GL11.glEnable((int)2896);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void renderLabel(EntityHuman human, double posX, double posY, double posZ, String labelText) {
        this.func_147906_a((Entity)human, labelText, posX, posY, posZ, 64);
    }

    private boolean canRenderNameTag(EntityLivingBase entityRendering) {
        EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
        Vec3d entityLookVector = new Vec3d(entityRendering.field_70165_t - entityPlayer.field_70165_t, entityRendering.func_174813_aQ().field_72338_b - 3.0 + (double)entityRendering.field_70131_O / 2.0 - entityPlayer.field_70163_u + (double)entityPlayer.func_70047_e(), entityRendering.field_70161_v - entityPlayer.field_70161_v).func_72432_b();
        double dotProduct = entityPlayer.func_70676_i(1.0f).func_72432_b().func_72430_b(entityLookVector);
        boolean isPlayerLookingAt = dotProduct > 1.0 - 0.025 / entityLookVector.func_72433_c() ? entityPlayer.func_70685_l((Entity)entityRendering) : false;
        double distance = entityRendering.func_70032_d((Entity)Minecraft.func_71410_x().field_71439_g);
        return !(Minecraft.func_71410_x().field_71462_r instanceof GuiInteraction) && distance < 5.0 && isPlayerLookingAt && Minecraft.func_71382_s() && entityRendering != Minecraft.func_71410_x().field_71439_g && !entityRendering.func_98034_c((EntityPlayer)Minecraft.func_71410_x().field_71439_g) && !entityRendering.func_184207_aI();
    }

    public void doRender(EntityHuman entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.doRenderEntity(entity, x, y, z, entityYaw, partialTicks);
        this.doRenderEffects(entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(T entity) {
        T human = entity;
        String skinName = ((EntityHuman)((Object)human)).getHeadTexture();
        if (skinName.isEmpty()) {
            return new ResourceLocation("minecraft:textures/entity/steve.png");
        }
        if (((EntityHuman)((Object)human)).getPlayerSkinResourceLocation() != null) {
            return ((EntityHuman)((Object)human)).getPlayerSkinResourceLocation();
        }
        return new ResourceLocation(((EntityHuman)((Object)entity)).getHeadTexture());
    }
}

