/*
 * Decompiled with CFR 0.152.
 */
package mca.blocks;

import java.util.Random;
import mca.ai.AISleep;
import mca.core.minecraft.ModItems;
import mca.entity.EntityHuman;
import mca.enums.EnumBedColor;
import mca.enums.EnumSleepingState;
import mca.tile.TileVillagerBed;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import radixcore.util.BlockHelper;
import radixcore.util.RadixLogic;

public class BlockVillagerBed
extends BlockBed
implements ITileEntityProvider {
    private EnumBedColor bedColor;

    public BlockVillagerBed(EnumBedColor bedColor) {
        this.bedColor = bedColor;
        this.func_149663_c("BlockVillagerBed" + bedColor.toString());
        GameRegistry.registerBlock((Block)this, (String)("BlockVillagerBed" + bedColor.toString()));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileVillagerBed();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this.func_180660_a(null, world.field_73012_v, 0));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        switch (this.bedColor) {
            case BLUE: {
                return ModItems.bedBlue;
            }
            case GREEN: {
                return ModItems.bedGreen;
            }
            case PINK: {
                return ModItems.bedPink;
            }
            case PURPLE: {
                return ModItems.bedPurple;
            }
            case RED: {
                return ModItems.bedRed;
            }
        }
        return null;
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            playerIn.func_145747_a((ITextComponent)new TextComponentString("You cannot sleep in a villager's bed."));
        }
        return false;
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        this.onBlockDestroyedByExplosion(worldIn, pos, state);
    }

    public void onBlockDestroyedByExplosion(World worldIn, BlockPos pos, IBlockState state) {
        TileVillagerBed villagerBed;
        TileEntity tileEntity;
        int posX = pos.func_177958_n();
        int posY = pos.func_177956_o();
        int posZ = pos.func_177952_p();
        if (!worldIn.field_72995_K && (tileEntity = BlockHelper.getTileEntity((World)worldIn, (int)posX, (int)posY, (int)posZ)) instanceof TileVillagerBed && (villagerBed = (TileVillagerBed)tileEntity).getSleepingVillagerId() != -1) {
            try {
                EntityHuman entity = (EntityHuman)RadixLogic.getEntityByPermanentId((World)worldIn, (int)villagerBed.getSleepingVillagerId());
                if (entity != null) {
                    AISleep sleepAI = entity.getAI(AISleep.class);
                    sleepAI.setSleepingState(EnumSleepingState.INTERRUPTED);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

