/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import java.util.Iterator;
import mca.ai.AbstractToggleAI;
import mca.api.RegistryMCA;
import mca.api.WoodcuttingEntry;
import mca.api.exception.MappingNotFoundException;
import mca.core.MCA;
import mca.entity.EntityHuman;
import mca.enums.EnumPersonality;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import radixcore.data.WatchedBoolean;
import radixcore.math.Point3D;
import radixcore.util.BlockHelper;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;

public class AIWoodcutting
extends AbstractToggleAI {
    private WatchedBoolean isAIActive;
    private Point3D treeBasePoint;
    private int apiId;
    private int yLevel;
    private int cutInterval;
    private int cutTimeLeft;
    private boolean doReplant;

    public AIWoodcutting(EntityHuman owner) {
        super(owner);
        this.isAIActive = new WatchedBoolean(false, 44, owner.getDataWatcherEx());
        this.treeBasePoint = Point3D.ZERO;
    }

    @Override
    public void setIsActive(boolean value) {
        this.isAIActive.setValue((Object)value);
    }

    @Override
    public boolean getIsActive() {
        return this.isAIActive.getBoolean();
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void onUpdateServer() {
        try {
            if (!MCA.getConfig().allowWoodcuttingChore) {
                this.notifyAssigningPlayer("\u00a7CThis chore is disabled.");
                this.reset();
                return;
            }
            if (this.treeBasePoint.iPosX == 0 && this.treeBasePoint.iPosY == 0 && this.treeBasePoint.iPosZ == 0) {
                Point3D modifiedPoint;
                WoodcuttingEntry apiEntry = RegistryMCA.getWoodcuttingEntryById(this.apiId);
                if (apiEntry.getLogBlock() == null) {
                    this.isAIActive.setValue((Object)false);
                    return;
                }
                Point3D point = RadixLogic.getFirstNearestBlock((Entity)this.owner, (Block)apiEntry.getLogBlock(), (int)15);
                if (point == null) {
                    this.notifyAssigningPlayer("There are no logs nearby.");
                    this.isAIActive.setValue((Object)false);
                    return;
                }
                while (BlockHelper.getBlock((World)this.owner.field_70170_p, (int)point.iPosX, (int)point.iPosY, (int)point.iPosZ) == apiEntry.getLogBlock()) {
                    --point.iPosY;
                    if (point.iPosY > 0) continue;
                }
                while (BlockHelper.getBlock((World)this.owner.field_70170_p, (int)point.iPosX, (int)point.iPosY, (int)point.iPosZ) != apiEntry.getLogBlock()) {
                    ++point.iPosY;
                    if (point.iPosY < 255) continue;
                }
                this.treeBasePoint = modifiedPoint = new Point3D(point.iPosX, point.iPosY, point.iPosZ);
                return;
            }
            if (RadixMath.getDistanceToXYZ((double)this.treeBasePoint.dPosX, (double)this.treeBasePoint.dPosY, (double)this.treeBasePoint.dPosZ, (double)this.owner.field_70165_t, (double)this.owner.field_70163_u, (double)this.owner.field_70161_v) <= 2.5 || this.yLevel > 0) {
                --this.cutTimeLeft;
                this.owner.swingItem();
                if (this.cutTimeLeft > 0) return;
                this.cutTimeLeft = this.cutInterval;
                WoodcuttingEntry apiEntry = RegistryMCA.getWoodcuttingEntryById(this.apiId);
                Block block = apiEntry.getLogBlock();
                BlockHelper.setBlock((World)this.owner.field_70170_p, (int)this.treeBasePoint.iPosX, (int)(this.treeBasePoint.iPosY + this.yLevel), (int)this.treeBasePoint.iPosZ, (Block)Blocks.field_150350_a);
                boolean addedToInventory = this.addItemStackToInventory(new ItemStack(block, 1, apiEntry.getLogMeta()));
                boolean toolBroken = this.owner.damageHeldItem(2);
                if (addedToInventory || this.owner.getPersonality() != EnumPersonality.GREEDY) {
                    if (!addedToInventory) {
                        this.notifyAssigningPlayer("My inventory is full.");
                        this.isAIActive.setValue((Object)false);
                        return;
                    }
                    if (toolBroken) {
                        this.notifyAssigningPlayer("My axe has broken.");
                        this.isAIActive.setValue((Object)false);
                        return;
                    }
                }
                ++this.yLevel;
                Block nextBlock = BlockHelper.getBlock((World)this.owner.field_70170_p, (int)this.treeBasePoint.iPosX, (int)(this.treeBasePoint.iPosY + this.yLevel), (int)this.treeBasePoint.iPosZ);
                if (nextBlock == apiEntry.getLogBlock()) return;
                if (apiEntry.hasSapling() && this.doReplant) {
                    BlockHelper.setBlock((World)this.owner.field_70170_p, (int)this.treeBasePoint.iPosX, (int)(this.treeBasePoint.iPosY - 1), (int)this.treeBasePoint.iPosZ, (Block)Blocks.field_150346_d);
                    BlockHelper.setBlock((World)this.owner.field_70170_p, (int)this.treeBasePoint.iPosX, (int)this.treeBasePoint.iPosY, (int)this.treeBasePoint.iPosZ, (Block)apiEntry.getSaplingBlock());
                }
                this.yLevel = 0;
                this.treeBasePoint = Point3D.ZERO;
                return;
            }
            for (Point3D point : RadixLogic.getNearbyBlocks((Entity)this.owner, (Block)Blocks.field_150362_t, (int)1)) {
                BlockHelper.setBlock((World)this.owner.field_70170_p, (int)point.iPosX, (int)point.iPosY, (int)point.iPosZ, (Block)Blocks.field_150350_a);
            }
            Iterator apiEntry = RadixLogic.getNearbyBlocks((Entity)this.owner, (Block)Blocks.field_150361_u, (int)1).iterator();
            while (true) {
                Point3D point;
                if (!apiEntry.hasNext()) {
                    if (!this.owner.func_70661_as().func_75500_f()) return;
                    this.owner.func_70661_as().func_75492_a(this.treeBasePoint.dPosX, this.treeBasePoint.dPosY, this.treeBasePoint.dPosZ, (double)this.owner.getSpeed());
                    return;
                }
                point = (Point3D)apiEntry.next();
                BlockHelper.setBlock((World)this.owner.field_70170_p, (int)point.iPosX, (int)point.iPosY, (int)point.iPosZ, (Block)Blocks.field_150350_a);
            }
        }
        catch (MappingNotFoundException e) {
            this.reset();
        }
    }

    @Override
    public void reset() {
        this.isAIActive.setValue((Object)false);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("isWoodcuttingActive", this.isAIActive.getBoolean().booleanValue());
        this.treeBasePoint.writeToNBT("treeBasePoint", nbt);
        nbt.func_74768_a("apiId", this.apiId);
        nbt.func_74768_a("yLevel", this.yLevel);
        nbt.func_74768_a("cutInterval", this.cutInterval);
        nbt.func_74768_a("cutTimeLeft", this.cutTimeLeft);
        nbt.func_74757_a("doReplant", this.doReplant);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.isAIActive.setValue((Object)nbt.func_74767_n("isWoodcuttingActive"));
        this.treeBasePoint = Point3D.readFromNBT((String)"treeBasePoint", (NBTTagCompound)nbt);
        this.apiId = nbt.func_74762_e("apiId");
        this.yLevel = nbt.func_74762_e("yLevel");
        this.cutInterval = nbt.func_74762_e("cutInterval");
        this.cutTimeLeft = nbt.func_74762_e("cutTimeLeft");
        this.doReplant = nbt.func_74767_n("doReplant");
    }

    public void startWoodcutting(EntityPlayer player, int apiId, boolean doReplant) {
        this.apiId = apiId;
        this.assigningPlayer = player.func_110124_au().toString();
        this.yLevel = 0;
        this.doReplant = doReplant;
        this.cutTimeLeft = this.cutInterval = this.calculateCutInterval();
        this.isAIActive.setValue((Object)true);
    }

    private int calculateCutInterval() {
        ItemStack bestAxe = this.owner.getVillagerInventory().getBestItemOfType(ItemAxe.class);
        int returnAmount = -1;
        if (bestAxe != null) {
            Item item = bestAxe.func_77973_b();
            Item.ToolMaterial material = Item.ToolMaterial.valueOf((String)((ItemAxe)bestAxe.func_77973_b()).func_77861_e());
            switch (material) {
                case WOOD: {
                    returnAmount = 40;
                    break;
                }
                case STONE: {
                    returnAmount = 30;
                    break;
                }
                case IRON: {
                    returnAmount = 25;
                    break;
                }
                case DIAMOND: {
                    returnAmount = 10;
                    break;
                }
                case GOLD: {
                    returnAmount = 5;
                    break;
                }
                default: {
                    returnAmount = 25;
                }
            }
            this.owner.setHeldItem(item);
        } else {
            returnAmount = 60;
            this.owner.setHeldItem(null);
        }
        return returnAmount;
    }

    @Override
    protected String getName() {
        return "Woodcutting";
    }
}

