/*
 * Decompiled with CFR 0.152.
 */
package mca.util;

import java.util.Random;
import net.minecraft.block.BlockDoor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketParticles;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Utilities {
    private Utilities() {
    }

    public static boolean isPointClear(World world, int posX, int posY, int posZ) {
        BlockPos block = new BlockPos(posX, posY, posZ);
        return !world.func_180495_p(block).func_185904_a().func_76230_c();
    }

    public static double getNumberInRange(Random rand, float standardDeviation, float mean) {
        return rand.nextGaussian() * (double)standardDeviation + (double)mean;
    }

    public static void spawnParticlesAroundPointS(EnumParticleTypes type, World world, double posX, double posY, double posZ, int rate) {
        Random rand = world.field_73012_v;
        for (int i = 0; i < rate; ++i) {
            float parX = (float)(posX + (double)(rand.nextFloat() * 1.0f * 2.0f) - 1.0);
            float parY = (float)(posY + 0.5 + (double)(rand.nextFloat() * 1.0f));
            float parZ = (float)(posZ + (double)(rand.nextFloat() * 1.0f * 2.0f) - 1.0);
            float velX = (float)(rand.nextGaussian() * 0.02);
            float velY = (float)(rand.nextGaussian() * 0.02);
            float velZ = (float)(rand.nextGaussian() * 0.02);
            SPacketParticles packet = new SPacketParticles(type, true, parX, parY, parZ, velX, velY, velZ, 0.0f, 0, new int[0]);
            for (int j = 0; j < world.field_73010_i.size(); ++j) {
                EntityPlayerMP entityPlayerMP = (EntityPlayerMP)world.field_73010_i.get(j);
                BlockPos blockpos = entityPlayerMP.func_180425_c();
                double distanceSq = blockpos.func_177954_c(posX, posY, posZ);
                if (!(distanceSq <= 256.0)) continue;
                entityPlayerMP.field_71135_a.func_147359_a((Packet)packet);
            }
        }
    }

    public static void spawnParticlesAroundEntityS(EnumParticleTypes type, Entity entityOrigin, int rate) {
        Random rand = entityOrigin.field_70170_p.field_73012_v;
        for (int i = 0; i < rate; ++i) {
            float parX = (float)(entityOrigin.field_70165_t + (double)(rand.nextFloat() * entityOrigin.field_70130_N * 2.0f) - (double)entityOrigin.field_70130_N);
            float parY = (float)(entityOrigin.field_70163_u + 0.5 + (double)(rand.nextFloat() * entityOrigin.field_70131_O));
            float parZ = (float)(entityOrigin.field_70161_v + (double)(rand.nextFloat() * entityOrigin.field_70130_N * 2.0f) - (double)entityOrigin.field_70130_N);
            float velX = (float)(rand.nextGaussian() * 0.02);
            float velY = (float)(rand.nextGaussian() * 0.02);
            float velZ = (float)(rand.nextGaussian() * 0.02);
            SPacketParticles packet = new SPacketParticles(type, true, parX, parY, parZ, velX, velY, velZ, 0.0f, 0, new int[0]);
            for (int j = 0; j < entityOrigin.field_70170_p.field_73010_i.size(); ++j) {
                EntityPlayerMP entityPlayerMP = (EntityPlayerMP)entityOrigin.field_70170_p.field_73010_i.get(j);
                ChunkCoordIntPair chunkCoordinates = new ChunkCoordIntPair(entityPlayerMP.field_70176_ah, entityPlayerMP.field_70164_aj);
                double deltaX = entityOrigin.field_70165_t - (double)chunkCoordinates.field_77276_a;
                double deltaY = entityOrigin.field_70163_u - (double)entityPlayerMP.field_70162_ai;
                double deltaZ = entityOrigin.field_70161_v - (double)chunkCoordinates.field_77275_b;
                double distanceSq = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
                if (!(distanceSq <= 256.0)) continue;
                entityPlayerMP.field_71135_a.func_147359_a((Packet)packet);
            }
        }
    }

    public static void spawnParticlesAroundEntityC(EnumParticleTypes type, Entity entityOrigin, int rate) {
        Random rand = entityOrigin.field_70170_p.field_73012_v;
        for (int i = 0; i < rate; ++i) {
            float parX = (float)(entityOrigin.field_70165_t + (double)(rand.nextFloat() * entityOrigin.field_70130_N * 2.0f) - (double)entityOrigin.field_70130_N);
            float parY = (float)(entityOrigin.field_70163_u + 0.5 + (double)(rand.nextFloat() * entityOrigin.field_70131_O));
            float parZ = (float)(entityOrigin.field_70161_v + (double)(rand.nextFloat() * entityOrigin.field_70130_N * 2.0f) - (double)entityOrigin.field_70130_N);
            float velX = (float)(rand.nextGaussian() * 0.02);
            float velY = (float)(rand.nextGaussian() * 0.02);
            float velZ = (float)(rand.nextGaussian() * 0.02);
            entityOrigin.field_70170_p.func_175688_a(type, (double)parX, (double)parY, (double)parZ, (double)velX, (double)velY, (double)velZ, new int[0]);
        }
    }

    public static void setDoorIsOpenAt(World world, int doorX, int doorY, int doorZ, boolean isOpen) {
    }

    public static boolean getDoorIsOpenAt(World world, int doorX, int doorY, int doorZ) {
        try {
            return !BlockDoor.func_176514_f((IBlockAccess)world, (BlockPos)new BlockPos(doorX, doorY, doorZ));
        }
        catch (Exception e) {
            return false;
        }
    }
}

