/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import io.netty.buffer.ByteBuf;
import mca.client.gui.GuiInteraction;
import mca.client.gui.GuiVillagerEditor;
import mca.core.MCA;
import mca.entity.EntityHuman;
import mca.items.ItemVillagerEditor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import radixcore.packets.AbstractPacket;

public class PacketOpenGUIOnEntity
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketOpenGUIOnEntity, IMessage> {
    private int entityId;
    private int guiId;

    public PacketOpenGUIOnEntity() {
    }

    public PacketOpenGUIOnEntity(int entityId, int guiId) {
        this.entityId = entityId;
        this.guiId = guiId;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.entityId = byteBuf.readInt();
        this.guiId = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.entityId);
        byteBuf.writeInt(this.guiId);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketOpenGUIOnEntity packet, MessageContext context) {
        MCA.getPacketHandler().addPacketForProcessing(context.side, packet, context);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void processOnGameThread(IMessageHandler message, MessageContext context) {
        PacketOpenGUIOnEntity packet = (PacketOpenGUIOnEntity)message;
        EntityPlayer player = this.getPlayer(context);
        EntityHuman entity = (EntityHuman)player.field_70170_p.func_73045_a(packet.entityId);
        if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemVillagerEditor) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiVillagerEditor(entity, player));
        } else {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiInteraction(entity, player));
        }
    }
}

