/*
 * Decompiled with CFR 0.152.
 */
package mca.data;

import com.google.common.io.Files;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mca.core.MCA;
import mca.data.NBTPlayerData;
import mca.data.PlayerData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.commons.lang3.exception.ExceptionUtils;
import radixcore.util.RadixExcept;

public class PlayerDataCollection
extends WorldSavedData {
    private static final String ID = "MinecraftComesAlive";
    private Map<UUID, NBTPlayerData> playerDataMap = new HashMap<UUID, NBTPlayerData>();

    public static PlayerDataCollection get() {
        World world = FMLCommonHandler.instance().getMinecraftServerInstance().func_130014_f_();
        PlayerDataCollection data = (PlayerDataCollection)world.func_72943_a(PlayerDataCollection.class, ID);
        if (data == null) {
            data = new PlayerDataCollection();
            world.func_72823_a(ID, (WorldSavedData)data);
        }
        return data;
    }

    public PlayerDataCollection() {
        this(ID);
    }

    public PlayerDataCollection(String id) {
        super(id);
    }

    public void func_76187_b(NBTTagCompound nbt) {
        for (Map.Entry<UUID, NBTPlayerData> entry : this.playerDataMap.entrySet()) {
            UUID uuid = entry.getKey();
            NBTPlayerData playerData = entry.getValue();
            NBTTagCompound playerDataTags = new NBTTagCompound();
            try {
                playerData.writeToNBT(playerDataTags);
                nbt.func_74782_a("PlayerData-" + uuid.toString(), (NBTBase)playerDataTags);
            }
            catch (Exception e) {
                RadixExcept.logErrorCatch((Throwable)e, (String)("Error writing player data to NBT for UUID " + uuid.toString() + ". Progress may be corrupted or lost."));
            }
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        for (Object tagKey : nbt.func_150296_c()) {
            try {
                String tagName = (String)tagKey;
                UUID uuid = UUID.fromString(tagName.replace("PlayerData-", ""));
                NBTTagCompound playerDataTags = nbt.func_74775_l(tagName);
                NBTPlayerData data = new NBTPlayerData();
                data.readFromNBT(playerDataTags);
                this.playerDataMap.put(uuid, data);
            }
            catch (Exception e) {
                RadixExcept.logErrorCatch((Throwable)e, (String)("Error reading player data from NBT tag: " + (String)tagKey + ". Progress may be corrupted or lost."));
            }
        }
        this.func_76185_a();
    }

    public boolean migrateOldPlayerData(EntityPlayer player, PlayerData data) {
        return this.migrateOldPlayerData(player.field_70170_p, player.func_110124_au(), data);
    }

    public boolean migrateOldPlayerData(World world, UUID uuid, PlayerData data) {
        String backupFullPath = data.getDataFile().replace(MCA.getMetadata().modId.toLowerCase(), "mca-backup");
        File backupFolder = new File(world.func_72860_G().func_75765_b().getAbsolutePath() + "/playerdata-mca-backup");
        File originalFullPathFile = new File(data.getDataFile());
        File backupFullPathFile = new File(backupFullPath);
        NBTPlayerData newData = new NBTPlayerData();
        this.logWarn("*** Detected old player data! UUID: " + uuid.toString() + " ***");
        this.logWarn("*** MCA will now migrate their data to a new internal format, doing the following: ***");
        this.logWarn("*** THESE ARE STEPS MCA WILL TAKE ON ITS OWN, NOT INSTRUCTIONS FOR SERVER ADMINISTRATORS ***");
        this.logWarn("*** - Copy old data to the new format in `[your world]/data/MinecraftComesAlive.dat` ***");
        this.logWarn("*** - Backup the old data file to `[your world]/playerdata-mca-backup` ***");
        this.logWarn("*** - Delete the old data file to prevent duplicate migration of bad data. ***");
        this.logWarn("*** You can turn this message off in MCA's configuration file, but no errors will be shown. ***");
        this.logWarn("*** You can force -everyone's- player data to be converted by using `/mca cpd`. ***");
        try {
            newData.setPermanentId(data.permanentId.getInt());
            newData.setSpousePermanentId(data.spousePermanentId.getInt());
            newData.setGenderPreference(data.genderPreference.getInt());
            newData.setIsMale(data.isMale.getBoolean());
            newData.setShouldHaveBaby(data.shouldHaveBaby.getBoolean());
            newData.setIsEngaged(data.isEngaged.getBoolean());
            newData.setHasChosenDestiny(data.hasChosenDestiny.getBoolean());
            newData.setMcaName(data.mcaName.getString());
            newData.setSpouseName(data.spouseName.getString());
            newData.setIsSuperUser(data.isSuperUser.getBoolean());
            newData.setIsNobility(false);
            newData.setHappinessThresholdMet(false);
        }
        catch (Exception e) {
            this.logError("****************   FAILED TO MIGRATE PLAYER DATA   ***********************");
            this.logError("* This player's data may be completely corrupted, or partially migrated. *");
            this.logError("*                                                                        *");
            this.logError("* This can indicate irreversible damage to this player's MCA progress.   *");
            this.logError("* This message will continue to appear until their old data is removed.  *");
            this.logError("* Their progress in MCA from this point forward can't be saved while the *");
            this.logError("* old data file remains in the following location:                       *");
            this.logError("*    /playerdata-mca/" + uuid.toString() + ".dat" + "            *");
            this.logError("*                                                                        *");
            this.logError("*      ONLY remove this file when Minecraft is not running!              *");
            this.logError("**************************************************************************");
            this.logError("Stacktrace will follow below:");
            this.logError(ExceptionUtils.getStackTrace((Throwable)e));
            this.logFatal("Please check recent logs for important information about this error.");
            return false;
        }
        this.logInfo("- Backing up old player data file to `playerdata-mca-backup`...");
        try {
            backupFolder.mkdirs();
            Files.copy((File)originalFullPathFile, (File)backupFullPathFile);
        }
        catch (Exception e) {
            this.logError("****************   FAILED TO BACKUP PLAYER DATA   *******************");
            this.logError("* Migration will not continue for this player unless their old data *");
            this.logError("* can be backed up. They will not be able to progress in MCA.       *");
            this.logError("* Try manually creating the folder below:                           *");
            this.logError("*        /[your world name]/playerdata-mca-backup/                  *");
            this.logError("*                                                                   *");
            this.logError("*    Ensure that this folder's permissions allow creating files.    *");
            this.logError("*********************************************************************");
            this.logError("Stacktrace will follow below:");
            this.logError(ExceptionUtils.getStackTrace((Throwable)e));
            this.logFatal("Please check recent logs for important information about this error.");
            return false;
        }
        this.logInfo("- Removing old player data from previous load location...");
        try {
            originalFullPathFile.delete();
        }
        catch (Exception e) {
            this.logError("****************   FAILED TO DELETE PLAYER DATA   ****************");
            this.logError("* The migration will try again when this player logs in again.   *");
            this.logError("* If their old MCA player data file isn't removed, they may lose *");
            this.logError("* progress in MCA. You must manually remove the file below:      *");
            this.logError("*    /playerdata-mca/" + uuid.toString() + ".dat" + "    *");
            this.logError("*                                                                *");
            this.logError("*      ONLY remove this file when Minecraft is not running!      *");
            this.logError("******************************************************************");
            this.logError("Stacktrace will follow below:");
            this.logError(ExceptionUtils.getStackTrace((Throwable)e));
            this.logFatal("Please check recent logs for important information about this error.");
            return false;
        }
        this.playerDataMap.put(uuid, newData);
        this.logInfo("- Migration of this data file succeeded without issue.");
        this.func_76185_a();
        return true;
    }

    public NBTPlayerData getPlayerData(UUID uuid) {
        return this.playerDataMap.get(uuid);
    }

    public void putPlayerData(UUID uuid, NBTPlayerData data) {
        this.playerDataMap.put(uuid, data);
        this.func_76185_a();
    }

    public UUID getUUIDByReference(NBTPlayerData data) {
        for (Map.Entry<UUID, NBTPlayerData> entry : this.playerDataMap.entrySet()) {
            if (entry.getValue() != data) continue;
            return entry.getKey();
        }
        return null;
    }

    private void logWarn(String message) {
        if (MCA.getConfig().showPlayerDataMigrationErrors) {
            MCA.getLog().warn(message);
        }
    }

    private void logError(String message) {
        if (MCA.getConfig().showPlayerDataMigrationErrors) {
            MCA.getLog().error(message);
        }
    }

    private void logInfo(String message) {
        if (MCA.getConfig().showPlayerDataMigrationErrors) {
            MCA.getLog().info(message);
        }
    }

    private void logFatal(String message) {
        if (MCA.getConfig().showPlayerDataMigrationErrors) {
            MCA.getLog().fatal(message);
        }
    }
}

