/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import java.util.List;
import mca.ai.AbstractAI;
import mca.entity.EntityHuman;
import mca.enums.EnumProfessionGroup;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import radixcore.math.Point3D;
import radixcore.util.BlockHelper;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;

public class AIPatrol
extends AbstractAI {
    private boolean hasDoor;
    private boolean isWaitingAtDoor;
    private int timeUntilMoveReset;
    private Point3D movePoint;
    private int timeUntilTick;

    public AIPatrol(EntityHuman owner) {
        super(owner);
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void onUpdateServer() {
        if (this.timeUntilTick > 0) {
            --this.timeUntilTick;
            return;
        }
        this.timeUntilTick = 20;
        if (this.owner.getProfessionGroup() == EnumProfessionGroup.Guard && !this.owner.field_70170_p.func_72935_r()) {
            if (!this.hasDoor) {
                List nearbyDoors = RadixLogic.getNearbyBlocks((Entity)this.owner, (Block)Blocks.field_180413_ao, (int)15);
                if (!nearbyDoors.isEmpty()) {
                    Point3D doorPoint = (Point3D)nearbyDoors.get(RadixMath.getNumberInRange((int)0, (int)(nearbyDoors.size() - 1)));
                    if (BlockHelper.getBlock((World)this.owner.field_70170_p, (int)doorPoint.iPosX, (int)(doorPoint.iPosY - 1), (int)doorPoint.iPosZ) != Blocks.field_180413_ao) {
                        doorPoint = doorPoint.setPoint(doorPoint.iPosX, doorPoint.iPosY + 1, doorPoint.iPosZ);
                    }
                    this.movePoint = new Point3D(doorPoint.iPosX, doorPoint.iPosY, doorPoint.iPosZ);
                    this.hasDoor = true;
                    Block block = BlockHelper.getBlock((World)this.owner.field_70170_p, (int)doorPoint.iPosX, (int)doorPoint.iPosY, (int)doorPoint.iPosZ);
                    BlockDoor door = null;
                    if (block != Blocks.field_180413_ao) {
                        this.hasDoor = false;
                        return;
                    }
                    door = (BlockDoor)block;
                    int doorState = BlockDoor.func_176515_e((IBlockAccess)this.owner.field_70170_p, (BlockPos)new BlockPos(doorPoint.iPosX, doorPoint.iPosY, doorPoint.iPosZ));
                    boolean isPositive = RadixLogic.getBooleanWithProbability((int)50);
                    int offset = isPositive ? RadixMath.getNumberInRange((int)1, (int)3) : RadixMath.getNumberInRange((int)1, (int)3) * -1;
                    boolean isValid = false;
                    for (int i = 1; i < 3; ++i) {
                        if (doorState == 10 || doorState == 14) {
                            this.movePoint = this.movePoint.setPoint(this.movePoint.dPosX + 1.0, this.movePoint.dPosY, this.movePoint.dPosZ);
                            this.movePoint = this.movePoint.setPoint(this.movePoint.dPosX, this.movePoint.dPosY, this.movePoint.dPosZ + (double)offset);
                        } else if (doorState == 8 || doorState == 12) {
                            this.movePoint = this.movePoint.setPoint(this.movePoint.dPosX - 1.0, this.movePoint.dPosY, this.movePoint.dPosZ);
                            this.movePoint = this.movePoint.setPoint(this.movePoint.dPosX, this.movePoint.dPosY, this.movePoint.dPosZ + (double)offset);
                        } else if (doorState == 11 || doorState == 15) {
                            this.movePoint = this.movePoint.setPoint(this.movePoint.dPosX, this.movePoint.dPosY, this.movePoint.dPosZ + 1.0);
                            this.movePoint = this.movePoint.setPoint(this.movePoint.dPosX + (double)offset, this.movePoint.dPosY, this.movePoint.dPosZ);
                        } else if (doorState == 9 || doorState == 13) {
                            this.movePoint = this.movePoint.setPoint(this.movePoint.dPosX, this.movePoint.dPosY, this.movePoint.dPosZ - 1.0);
                            this.movePoint = this.movePoint.setPoint(this.movePoint.dPosX + (double)offset, this.movePoint.dPosY, this.movePoint.dPosZ);
                        }
                        if (!BlockHelper.canBlockSeeTheSky((World)this.owner.field_70170_p, (int)this.movePoint.iPosX, (int)this.movePoint.iPosY, (int)this.movePoint.iPosZ) || BlockHelper.getBlock((World)this.owner.field_70170_p, (int)this.movePoint.iPosX, (int)this.movePoint.iPosY, (int)this.movePoint.iPosZ) != Blocks.field_150350_a || i == 1 && RadixLogic.getBooleanWithProbability((int)50)) continue;
                        isValid = true;
                        this.movePoint = this.movePointToGround(this.movePoint);
                        break;
                    }
                    if (!isValid) {
                        this.hasDoor = false;
                        this.movePoint = null;
                    }
                }
            } else {
                boolean pathSet;
                if (this.owner.func_70661_as().func_75500_f() && !(pathSet = this.owner.func_70661_as().func_75492_a(this.movePoint.dPosX, this.movePoint.dPosY, this.movePoint.dPosZ, 0.6)) && !this.isWaitingAtDoor) {
                    this.hasDoor = false;
                    this.movePoint = null;
                    return;
                }
                if (this.owner.func_70011_f(this.movePoint.dPosX, this.movePoint.dPosY, this.movePoint.dPosZ) <= 2.0 && !this.isWaitingAtDoor) {
                    this.owner.func_70661_as().func_75499_g();
                    this.isWaitingAtDoor = true;
                    this.timeUntilMoveReset = 20 * RadixMath.getNumberInRange((int)5, (int)15);
                }
                if (this.isWaitingAtDoor) {
                    int n = this.timeUntilMoveReset = this.timeUntilMoveReset > 0 ? this.timeUntilMoveReset - 1 : this.timeUntilMoveReset;
                    if (this.timeUntilMoveReset <= 0) {
                        this.hasDoor = false;
                        this.isWaitingAtDoor = false;
                        this.movePoint = null;
                    }
                }
            }
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
    }

    private Point3D movePointToGround(Point3D point) {
        Point3D returnPoint = new Point3D(point.iPosX, point.iPosY, point.iPosZ);
        Block block = BlockHelper.getBlock((World)this.owner.field_70170_p, (int)returnPoint.iPosX, (int)returnPoint.iPosY, (int)returnPoint.iPosZ);
        boolean lastBlockWasAir = false;
        while (returnPoint.iPosY > 0) {
            if (block == Blocks.field_150350_a) {
                lastBlockWasAir = true;
                --returnPoint.iPosY;
                block = BlockHelper.getBlock((World)this.owner.field_70170_p, (int)returnPoint.iPosX, (int)returnPoint.iPosY, (int)returnPoint.iPosZ);
                continue;
            }
            if (block == Blocks.field_150350_a || !lastBlockWasAir) continue;
            return new Point3D(returnPoint.iPosX, returnPoint.iPosY + 1, returnPoint.iPosZ);
        }
        return point;
    }
}

