/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import java.util.List;
import java.util.Map;
import mca.ai.AIBuild;
import mca.ai.AbstractToggleAI;
import mca.api.MiningEntry;
import mca.api.RegistryMCA;
import mca.api.exception.MappingNotFoundException;
import mca.core.MCA;
import mca.entity.EntityHuman;
import mca.enums.EnumMovementState;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import radixcore.data.WatchedBoolean;
import radixcore.math.Point3D;
import radixcore.util.BlockHelper;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;

public class AIMining
extends AbstractToggleAI {
    private static final int SEARCH_INTERVAL = 200;
    private static final int MINE_INTERVAL = 20;
    private WatchedBoolean isAIActive;
    private Point3D blockMining;
    private int idOfNotifyBlock;
    private int activityInterval;
    private boolean isGathering;
    private boolean isBuildingMine;

    public AIMining(EntityHuman owner) {
        super(owner);
        this.isAIActive = new WatchedBoolean(false, 40, owner.getDataWatcherEx());
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void onUpdateServer() {
        if (!MCA.getConfig().allowMiningChore) {
            this.notifyAssigningPlayer("\u00a7CThis chore is disabled.");
            this.reset();
            return;
        }
        if (this.isGathering) {
            if (this.activityInterval <= 0) {
                this.activityInterval = 20;
                if (!this.isBuildingMine && RadixLogic.getNearbyBlocks((Entity)this.owner, (Block)Blocks.field_180390_bo, (int)8).size() == 0) {
                    int y = RadixLogic.getSpawnSafeTopLevel((World)this.owner.field_70170_p, (int)((int)this.owner.field_70165_t), (int)((int)this.owner.field_70161_v));
                    Block groundBlock = BlockHelper.getBlock((World)this.owner.field_70170_p, (int)((int)this.owner.field_70165_t), (int)(y - 1), (int)((int)this.owner.field_70161_v));
                    this.owner.getAI(AIBuild.class).startBuilding("/assets/mca/schematic/mine1.schematic", true, groundBlock);
                    this.isBuildingMine = true;
                } else if (this.isBuildingMine) {
                    if (!this.owner.getAI(AIBuild.class).getIsActive()) {
                        List nearbyFence = RadixLogic.getNearbyBlocks((Entity)this.owner, (Block)Blocks.field_180390_bo, (int)8);
                        if (nearbyFence.size() >= 1) {
                            this.isBuildingMine = false;
                        } else {
                            this.reset();
                        }
                    }
                } else {
                    this.owner.setMovementState(EnumMovementState.STAY);
                    this.owner.swingItem();
                    ItemStack addStack = this.getHarvestStack();
                    if (addStack != null) {
                        this.owner.getVillagerInventory().addItemStackToInventory(addStack);
                        this.owner.damageHeldItem(2);
                    }
                }
            }
            --this.activityInterval;
        } else {
            try {
                if (this.activityInterval <= 0) {
                    String phraseId;
                    this.activityInterval = 200;
                    Block notifyBlock = RegistryMCA.getMiningEntryById(this.idOfNotifyBlock).getBlock();
                    Point3D ownerPos = new Point3D(this.owner.field_70165_t, this.owner.field_70163_u, this.owner.field_70161_v);
                    int distanceToBlock = -1;
                    for (Point3D point : RadixLogic.getNearbyBlocks((Entity)this.owner, (Block)notifyBlock, (int)20)) {
                        if (distanceToBlock == -1) {
                            distanceToBlock = (int)RadixMath.getDistanceToXYZ((double)point.iPosX, (double)point.iPosY, (double)point.iPosZ, (double)ownerPos.iPosX, (double)ownerPos.iPosY, (double)ownerPos.iPosZ);
                            continue;
                        }
                        double distanceToPoint = RadixMath.getDistanceToXYZ((double)point.iPosX, (double)point.iPosY, (double)point.iPosZ, (double)ownerPos.iPosX, (double)ownerPos.iPosY, (double)ownerPos.iPosZ);
                        if (!(distanceToPoint < (double)distanceToBlock)) continue;
                        distanceToBlock = (int)distanceToPoint;
                    }
                    this.owner.damageHeldItem(5);
                    Object[] arguments = new Object[2];
                    if (distanceToBlock == -1) {
                        phraseId = "mining.search.none";
                        arguments[0] = notifyBlock.func_149732_F().toLowerCase();
                    } else if (distanceToBlock <= 5) {
                        phraseId = "mining.search.nearby";
                        arguments[0] = notifyBlock.func_149732_F().toLowerCase();
                    } else {
                        phraseId = "mining.search.value";
                        arguments[0] = notifyBlock.func_149732_F().toLowerCase();
                        arguments[1] = distanceToBlock;
                    }
                    EntityPlayer player = RadixLogic.getPlayerByUUID((String)this.assigningPlayer, (World)this.owner.field_70170_p);
                    if (player != null) {
                        this.owner.say(phraseId, player, arguments);
                    }
                }
                --this.activityInterval;
            }
            catch (MappingNotFoundException e) {
                this.reset();
            }
        }
    }

    @Override
    public void reset() {
        this.isAIActive.setValue((Object)false);
        new Throwable().printStackTrace();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("isMiningActive", this.isAIActive.getBoolean().booleanValue());
        nbt.func_74768_a("idOfNotifyBlock", this.idOfNotifyBlock);
        nbt.func_74768_a("activityInterval", this.activityInterval);
        nbt.func_74778_a("assigningPlayer", this.assigningPlayer);
        nbt.func_74757_a("isGathering", this.isGathering);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.isAIActive.setValue((Object)nbt.func_74767_n("isMiningActive"));
        this.idOfNotifyBlock = nbt.func_74762_e("idOfNotifyBlock");
        this.activityInterval = nbt.func_74762_e("activityInterval");
        this.assigningPlayer = nbt.func_74779_i("assigningPlayer");
        this.isGathering = nbt.func_74767_n("isGathering");
    }

    public void startSearching(EntityPlayer assigningPlayer, int notifyBlockId) {
        this.assigningPlayer = assigningPlayer.getPersistentID().toString();
        this.idOfNotifyBlock = notifyBlockId;
        this.isGathering = false;
        this.isAIActive.setValue((Object)true);
        this.activityInterval = 200;
        ItemStack pickaxe = this.owner.getVillagerInventory().getBestItemOfType(ItemPickaxe.class);
        if (pickaxe != null) {
            this.owner.setHeldItem(pickaxe.func_77973_b());
        } else {
            this.owner.say("interaction.mining.fail.nopickaxe", assigningPlayer);
            this.reset();
        }
    }

    public void startGathering(EntityPlayer player) {
        if (this.owner.field_70163_u <= 12.0) {
            this.owner.say("interaction.mining.fail.toolow", player);
            return;
        }
        this.assigningPlayer = player.getPersistentID().toString();
        this.isGathering = true;
        this.isAIActive.setValue((Object)true);
        this.activityInterval = 0;
        ItemStack pickaxe = this.owner.getVillagerInventory().getBestItemOfType(ItemPickaxe.class);
        if (pickaxe != null) {
            this.owner.setHeldItem(pickaxe.func_77973_b());
        } else {
            this.owner.say("interaction.mining.fail.nopickaxe", player);
            this.reset();
        }
    }

    @Override
    public void setIsActive(boolean value) {
        this.isAIActive.setValue((Object)value);
    }

    @Override
    public boolean getIsActive() {
        return this.isAIActive.getBoolean();
    }

    @Override
    protected String getName() {
        return "Mining";
    }

    public ItemStack getHarvestStack() {
        boolean doHarvest = RadixLogic.getBooleanWithProbability((int)25);
        if (doHarvest) {
            ItemStack addStack = null;
            boolean getSpecialOre = RadixLogic.getBooleanWithProbability((int)3);
            if (getSpecialOre) {
                Map<Integer, MiningEntry> entries = RegistryMCA.getMiningEntryMap();
                float totalWeight = 0.0f;
                int index = -1;
                for (MiningEntry entry : entries.values()) {
                    totalWeight += entry.getWeight();
                }
                float random = (float)(Math.random() * (double)totalWeight);
                for (Map.Entry<Integer, MiningEntry> entry : entries.entrySet()) {
                    if (!((random -= entry.getValue().getWeight()) <= 0.0f)) continue;
                    index = entry.getKey();
                    break;
                }
                addStack = entries.get(index).getMinedItemStack();
            } else {
                addStack = new ItemStack(Blocks.field_150347_e, 1);
            }
            return addStack;
        }
        return null;
    }
}

