/*
 * Decompiled with CFR 0.152.
 */
package mca.ai;

import java.util.List;
import mca.ai.AISleep;
import mca.ai.AbstractAI;
import mca.entity.EntityHuman;
import mca.enums.EnumCombatBehaviors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import radixcore.data.DataWatcherEx;
import radixcore.data.WatchedInt;
import radixcore.util.RadixLogic;
import radixcore.util.RadixMath;

public class AICombat
extends AbstractAI {
    private WatchedInt attackMethodInt;
    private WatchedInt attackTriggerInt;
    private WatchedInt attackTargetInt;
    private EntityLivingBase attackTarget;
    private int rangedAttackTime;

    public AICombat(EntityHuman owner) {
        super(owner);
        this.attackMethodInt = new WatchedInt(EnumCombatBehaviors.METHOD_DO_NOT_FIGHT.getNumericId(), 52, owner.getDataWatcherEx());
        this.attackTriggerInt = new WatchedInt(EnumCombatBehaviors.TRIGGER_PLAYER_TAKE_DAMAGE.getNumericId(), 53, owner.getDataWatcherEx());
        this.attackTargetInt = new WatchedInt(EnumCombatBehaviors.TARGET_HOSTILE_MOBS.getNumericId(), 54, owner.getDataWatcherEx());
    }

    @Override
    public void onUpdateCommon() {
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void onUpdateServer() {
        if (this.owner.getAI(AISleep.class).getIsSleeping() || this.owner.getIsInteracting()) {
            return;
        }
        if (this.attackTarget != null && this.getMethodBehavior() == EnumCombatBehaviors.METHOD_DO_NOT_FIGHT) {
            this.attackTarget = null;
            return;
        }
        if (this.attackTarget != null && (this.attackTarget.field_70128_L || this.attackTarget.func_110143_aJ() <= 0.0f)) {
            this.attackTarget = null;
        }
        if (this.attackTarget == null && this.getTriggerBehavior() == EnumCombatBehaviors.TRIGGER_ALWAYS) {
            this.findAttackTarget();
        } else if (this.attackTarget != null) {
            double distanceToTarget = RadixMath.getDistanceToEntity((Entity)this.owner, (Entity)this.attackTarget);
            if (this.getMethodBehavior() == EnumCombatBehaviors.METHOD_MELEE_ONLY || this.getMethodBehavior() == EnumCombatBehaviors.METHOD_MELEE_AND_RANGED && distanceToTarget < 5.0) {
                this.moveToAttackTarget();
                if (distanceToTarget < 1.5) {
                    this.owner.swingItem();
                    ItemStack heldItem = this.owner.func_184586_b(EnumHand.MAIN_HAND);
                    Item.ToolMaterial swordMaterial = null;
                    if (heldItem != null && heldItem.func_77973_b() instanceof ItemSword) {
                        ItemSword sword = (ItemSword)heldItem.func_77973_b();
                        swordMaterial = Item.ToolMaterial.valueOf((String)sword.func_150932_j());
                    }
                    float damage = swordMaterial != null ? 4.0f + swordMaterial.func_78000_c() : 0.5f;
                    this.attackTarget.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.owner), damage);
                }
            } else if (this.getMethodBehavior() == EnumCombatBehaviors.METHOD_RANGED_ONLY || this.getMethodBehavior() == EnumCombatBehaviors.METHOD_MELEE_AND_RANGED && distanceToTarget >= 5.0) {
                this.owner.func_70671_ap().func_75650_a(this.attackTarget.field_70165_t, this.attackTarget.field_70163_u + (double)this.attackTarget.func_70047_e(), this.attackTarget.field_70161_v, 10.0f, (float)this.owner.func_70646_bf());
                if (this.rangedAttackTime <= 0) {
                    EntityTippedArrow arrow = new EntityTippedArrow(this.owner.field_70170_p, (EntityLivingBase)this.owner);
                    double dX = this.attackTarget.field_70165_t - this.owner.field_70165_t;
                    double dY = this.attackTarget.func_174813_aQ().field_72338_b + (double)(this.attackTarget.field_70131_O / 3.0f) - arrow.field_70163_u;
                    double dZ = this.attackTarget.field_70161_v - this.owner.field_70161_v;
                    double d3 = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
                    arrow.func_70186_c(dX, dY + d3 * (double)0.2f, dZ, 1.6f, (float)(14 - this.owner.field_70170_p.func_175659_aa().func_151525_a() * 4));
                    arrow.func_70239_b(5.0 + this.owner.func_70681_au().nextGaussian() * 0.25 + (double)((float)this.owner.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
                    this.owner.func_184185_a(SoundEvents.field_187866_fi, 1.0f, 1.0f / (this.owner.func_70681_au().nextFloat() * 0.4f + 0.8f));
                    this.owner.field_70170_p.func_72838_d((Entity)arrow);
                    this.rangedAttackTime = 60;
                } else {
                    --this.rangedAttackTime;
                }
            }
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("attackMethod", this.attackMethodInt.getInt());
        nbt.func_74768_a("attackTrigger", this.attackTriggerInt.getInt());
        nbt.func_74768_a("attackTarget", this.attackTargetInt.getInt());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.setMethodBehavior(nbt.func_74762_e("attackMethod"));
        this.setTriggerBehavior(nbt.func_74762_e("attackTrigger"));
        this.setTargetBehavior(nbt.func_74762_e("attackTarget"));
    }

    public EnumCombatBehaviors getMethodBehavior() {
        return EnumCombatBehaviors.getById(this.attackMethodInt.getInt());
    }

    public EnumCombatBehaviors getTriggerBehavior() {
        return EnumCombatBehaviors.getById(this.attackTriggerInt.getInt());
    }

    public EnumCombatBehaviors getTargetBehavior() {
        return EnumCombatBehaviors.getById(this.attackTargetInt.getInt());
    }

    public void setMethodBehavior(int value) {
        DataWatcherEx.allowClientSideModification = true;
        this.attackMethodInt.setValue((Object)value);
        DataWatcherEx.allowClientSideModification = false;
    }

    public void setTriggerBehavior(int value) {
        DataWatcherEx.allowClientSideModification = true;
        this.attackTriggerInt.setValue((Object)value);
        DataWatcherEx.allowClientSideModification = false;
    }

    public void setTargetBehavior(int value) {
        DataWatcherEx.allowClientSideModification = true;
        this.attackTargetInt.setValue((Object)value);
        DataWatcherEx.allowClientSideModification = false;
    }

    private void findAttackTarget() {
        List entitiesAroundMe = RadixLogic.getAllEntitiesWithinDistanceOfCoordinates((World)this.owner.field_70170_p, (double)this.owner.field_70165_t, (double)this.owner.field_70163_u, (double)this.owner.field_70161_v, (int)10);
        double distance = 100.0;
        EntityLivingBase target = null;
        for (Entity entity : entitiesAroundMe) {
            if (!(entity instanceof EntityLivingBase)) continue;
            EntityLivingBase livingBase = (EntityLivingBase)entity;
            double distanceTo = RadixMath.getDistanceToEntity((Entity)this.owner, (Entity)livingBase);
            if (!this.isEntityValidToAttack(livingBase) || !(distanceTo < distance)) continue;
            distance = RadixMath.getDistanceToEntity((Entity)this.owner, (Entity)livingBase);
            target = livingBase;
        }
        this.attackTarget = target;
    }

    private void moveToAttackTarget() {
        this.owner.func_70661_as().func_75497_a((Entity)this.attackTarget, (double)0.7f);
    }

    public boolean isEntityValidToAttack(EntityLivingBase entity) {
        if (entity instanceof EntityMob && (this.getTargetBehavior() == EnumCombatBehaviors.TARGET_HOSTILE_MOBS || this.getTargetBehavior() == EnumCombatBehaviors.TARGET_PASSIVE_OR_HOSTILE_MOBS)) {
            return true;
        }
        return entity instanceof EntityAnimal && (this.getTargetBehavior() == EnumCombatBehaviors.TARGET_PASSIVE_MOBS || this.getTargetBehavior() == EnumCombatBehaviors.TARGET_PASSIVE_OR_HOSTILE_MOBS);
    }

    public void setAttackTarget(EntityLivingBase entity) {
        if (entity != this.owner) {
            this.attackTarget = entity;
        }
    }

    public EntityLivingBase getAttackTarget() {
        return this.attackTarget;
    }
}

