/*
 * Decompiled with CFR 0.152.
 */
package mca.tile;

import mca.core.MCA;
import mca.data.PlayerMemory;
import mca.data.VillagerSaveData;
import mca.entity.EntityHuman;
import mca.enums.EnumDialogueType;
import mca.enums.EnumMemorialType;
import mca.enums.EnumRelation;
import mca.packets.PacketMemorialUpdateGet;
import mca.util.MarriageHandler;
import mca.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.world.World;
import radixcore.util.BlockHelper;

public class TileMemorial
extends TileEntity
implements ITickable {
    private EnumMemorialType type;
    private VillagerSaveData data;
    private String ownerName;
    private EnumRelation ownerRelation;
    private int revivalTicks;
    private EntityPlayer player;
    private boolean hasSynced;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K && !this.hasSynced) {
            this.hasSynced = true;
            MCA.getPacketHandler().sendPacketToServer(new PacketMemorialUpdateGet(this));
        }
        if (!this.field_145850_b.field_72995_K) {
            int xCoord = this.field_174879_c.func_177958_n();
            int yCoord = this.field_174879_c.func_177956_o();
            int zCoord = this.field_174879_c.func_177952_p();
            if (this.player == null || this.player.field_70128_L) {
                this.revivalTicks = 0;
            }
            if (this.revivalTicks == 1) {
                EntityHuman human = new EntityHuman(this.field_145850_b);
                this.data.applyToHuman(human);
                human.func_70107_b((double)xCoord + 0.5, yCoord, (double)zCoord + 0.5);
                this.field_145850_b.func_72838_d((Entity)human);
                BlockHelper.setBlock((World)this.field_145850_b, (int)xCoord, (int)yCoord, (int)zCoord, (Block)Blocks.field_150350_a);
                Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.VILLAGER_HAPPY, (Entity)human, 32);
                Utilities.spawnParticlesAroundPointS(EnumParticleTypes.FIREWORKS_SPARK, this.field_145850_b, (double)xCoord + 0.5, yCoord, (double)zCoord + 0.5, 16);
                this.field_145850_b.func_72956_a((Entity)this.player, "fireworks.largeBlast", 3.0f, 1.0f);
                if (this.ownerRelation == EnumRelation.NONE) {
                    return;
                }
                if (this.getType() == EnumMemorialType.BROKEN_RING) {
                    MarriageHandler.startMarriage(this.player, human);
                    human.getPlayerMemory(this.player).setHearts(100);
                } else {
                    PlayerMemory memory = human.getPlayerMemory(this.player);
                    memory.setHearts(100);
                    memory.setDialogueType(EnumDialogueType.CHILDP);
                    memory.setRelation(human.getIsMale() ? EnumRelation.SON : EnumRelation.DAUGHTER);
                }
            } else if (this.revivalTicks > 0) {
                --this.revivalTicks;
                Utilities.spawnParticlesAroundPointS(EnumParticleTypes.SPELL_INSTANT, this.field_145850_b, (double)xCoord + 0.5, yCoord, (double)zCoord + 0.5, 2);
                if (this.revivalTicks == 40 || this.revivalTicks == 20) {
                    this.field_145850_b.func_72956_a((Entity)this.player, "fireworks.largeBlast", 3.0f, 1.0f);
                    Utilities.spawnParticlesAroundPointS(EnumParticleTypes.FIREWORKS_SPARK, this.field_145850_b, (double)xCoord + 0.5, yCoord, (double)zCoord + 0.5, 32);
                }
                if (this.revivalTicks < 40) {
                    Utilities.spawnParticlesAroundPointS(EnumParticleTypes.VILLAGER_HAPPY, this.field_145850_b, (double)xCoord + 0.5, yCoord, (double)zCoord + 0.5, 2);
                }
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("type", this.type.getId());
        this.data.writeDataToNBT(nbt);
        nbt.func_74778_a("ownerName", this.ownerName);
        nbt.func_74768_a("relation", this.ownerRelation.getId());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.type = EnumMemorialType.fromId(nbt.func_74762_e("type"));
        this.data = VillagerSaveData.fromNBT(nbt);
        this.ownerName = nbt.func_74779_i("ownerName");
        this.ownerRelation = EnumRelation.getById(nbt.func_74762_e("relation"));
    }

    public void setType(EnumMemorialType type) {
        this.type = type;
    }

    public EnumMemorialType getType() {
        return this.type;
    }

    public VillagerSaveData getVillagerSaveData() {
        return this.data;
    }

    public void setVillagerSaveData(VillagerSaveData data) {
        this.data = data;
    }

    public void setRevivalTicks(int value) {
        this.revivalTicks = value;
    }

    public void setPlayer(EntityPlayer player) {
        this.player = player;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public void setRelation(EnumRelation relation) {
        this.ownerRelation = relation;
    }

    public EnumRelation getRelation() {
        return this.ownerRelation;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public int getRevivalTicks() {
        return this.revivalTicks;
    }
}

