/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import io.netty.buffer.ByteBuf;
import mca.core.MCA;
import mca.data.PlayerMemory;
import mca.entity.EntityHuman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import radixcore.network.ByteBufIO;
import radixcore.packets.AbstractPacket;
import radixcore.util.RadixExcept;

public class PacketSyncPlayerMemory
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketSyncPlayerMemory, IMessage> {
    private int entityId;
    private PlayerMemory memory;

    public PacketSyncPlayerMemory() {
    }

    public PacketSyncPlayerMemory(int entityId, PlayerMemory memory) {
        this.entityId = entityId;
        this.memory = memory;
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.entityId = byteBuf.readInt();
        this.memory = (PlayerMemory)ByteBufIO.readObject((ByteBuf)byteBuf);
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.entityId);
        ByteBufIO.writeObject((ByteBuf)byteBuf, (Object)this.memory);
    }

    public IMessage onMessage(PacketSyncPlayerMemory packet, MessageContext context) {
        MCA.getPacketHandler().addPacketForProcessing(context.side, packet, context);
        return null;
    }

    public void processOnGameThread(IMessageHandler message, MessageContext context) {
        try {
            PacketSyncPlayerMemory packet = (PacketSyncPlayerMemory)message;
            EntityPlayer player = this.getPlayer(context);
            EntityHuman human = (EntityHuman)player.field_70170_p.func_73045_a(packet.entityId);
            if (human != null && packet.memory != null) {
                human.setPlayerMemory(player, packet.memory);
            }
        }
        catch (Exception e) {
            RadixExcept.logErrorCatch((Throwable)e, (String)"Unexpected error while syncing player memory.");
        }
    }
}

