/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import io.netty.buffer.ByteBuf;
import mca.core.MCA;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import radixcore.network.ByteBufIO;
import radixcore.packets.AbstractPacket;

public class PacketPlaySoundOnPlayer
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketPlaySoundOnPlayer, IMessage> {
    private String soundName;
    private float volume;
    private float pitch;

    public PacketPlaySoundOnPlayer() {
    }

    public PacketPlaySoundOnPlayer(String soundName) {
        this.soundName = soundName;
        this.volume = 1.0f;
        this.pitch = 1.0f;
    }

    public PacketPlaySoundOnPlayer(String soundName, float volume, float pitch) {
        this(soundName);
        this.volume = volume;
        this.pitch = pitch;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufIO.writeObject((ByteBuf)buf, (Object)this.soundName);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
    }

    public void fromBytes(ByteBuf buf) {
        this.soundName = (String)ByteBufIO.readObject((ByteBuf)buf);
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
    }

    public IMessage onMessage(PacketPlaySoundOnPlayer packet, MessageContext ctx) {
        MCA.getPacketHandler().addPacketForProcessing(ctx.side, packet, ctx);
        return null;
    }

    public void processOnGameThread(IMessageHandler message, MessageContext context) {
        PacketPlaySoundOnPlayer packet = (PacketPlaySoundOnPlayer)message;
        this.getPlayerClient().func_85030_a(packet.soundName, packet.pitch, packet.volume);
    }
}

