/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import io.netty.buffer.ByteBuf;
import mca.client.gui.GuiPrompt;
import mca.core.MCA;
import mca.enums.EnumInteraction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import radixcore.packets.AbstractPacket;

public class PacketOpenPrompt
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketOpenPrompt, IMessage> {
    private int senderId;
    private int targetId;
    private int interactionId;

    public PacketOpenPrompt() {
    }

    public PacketOpenPrompt(EntityPlayer sender, EntityPlayer target, EnumInteraction interaction) {
        this.senderId = sender.func_145782_y();
        this.targetId = target.func_145782_y();
        this.interactionId = interaction.getId();
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.senderId = byteBuf.readInt();
        this.targetId = byteBuf.readInt();
        this.interactionId = byteBuf.readInt();
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.senderId);
        byteBuf.writeInt(this.targetId);
        byteBuf.writeInt(this.interactionId);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketOpenPrompt packet, MessageContext context) {
        MCA.getPacketHandler().addPacketForProcessing(context.side, packet, context);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void processOnGameThread(IMessageHandler message, MessageContext context) {
        PacketOpenPrompt packet = (PacketOpenPrompt)message;
        EntityPlayer target = this.getPlayer(context);
        EntityPlayer sender = (EntityPlayer)target.field_70170_p.func_73045_a(packet.senderId);
        EnumInteraction interaction = EnumInteraction.fromId(packet.interactionId);
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPrompt(sender, target, interaction));
    }
}

