/*
 * Decompiled with CFR 0.152.
 */
package mca.packets;

import io.netty.buffer.ByteBuf;
import mca.client.gui.GuiPlayerMenu;
import mca.core.MCA;
import mca.data.NBTPlayerData;
import mca.entity.EntityHuman;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import radixcore.network.ByteBufIO;
import radixcore.packets.AbstractPacket;

public class PacketInteractWithPlayerC
extends AbstractPacket
implements IMessage,
IMessageHandler<PacketInteractWithPlayerC, IMessage> {
    private int targetEntityId;
    private boolean targetIsMarried;
    private boolean targetIsEngaged;
    private boolean isMarriedToInitiator;
    private String targetSpouseName;

    public PacketInteractWithPlayerC() {
    }

    public PacketInteractWithPlayerC(EntityPlayer initiator, EntityPlayer target) {
        this.targetEntityId = target.func_145782_y();
        NBTPlayerData initData = MCA.getPlayerData(initiator);
        NBTPlayerData targetData = MCA.getPlayerData(target);
        this.targetIsMarried = targetData.getSpousePermanentId() != 0;
        this.targetIsEngaged = targetData.getIsEngaged();
        this.isMarriedToInitiator = targetData.getSpousePermanentId() == initData.getPermanentId();
        for (Object obj : initiator.field_70170_p.field_72996_f) {
            EntityHuman human;
            if (!(obj instanceof EntityHuman) || (human = (EntityHuman)((Object)obj)).getSpouseId() != targetData.getPermanentId()) continue;
            this.targetSpouseName = human.func_70005_c_();
        }
        if (this.targetSpouseName == null || this.targetSpouseName.isEmpty()) {
            this.targetSpouseName = "?";
        }
    }

    public void fromBytes(ByteBuf byteBuf) {
        this.targetEntityId = byteBuf.readInt();
        this.targetIsMarried = byteBuf.readBoolean();
        this.targetIsEngaged = byteBuf.readBoolean();
        this.isMarriedToInitiator = byteBuf.readBoolean();
        this.targetSpouseName = (String)ByteBufIO.readObject((ByteBuf)byteBuf);
    }

    public void toBytes(ByteBuf byteBuf) {
        byteBuf.writeInt(this.targetEntityId);
        byteBuf.writeBoolean(this.targetIsMarried);
        byteBuf.writeBoolean(this.targetIsEngaged);
        byteBuf.writeBoolean(this.isMarriedToInitiator);
        ByteBufIO.writeObject((ByteBuf)byteBuf, (Object)this.targetSpouseName);
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketInteractWithPlayerC packet, MessageContext context) {
        MCA.getPacketHandler().addPacketForProcessing(context.side, packet, context);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void processOnGameThread(IMessageHandler message, MessageContext context) {
        PacketInteractWithPlayerC packet = (PacketInteractWithPlayerC)message;
        EntityPlayer recipient = this.getPlayerClient();
        EntityPlayer target = (EntityPlayer)recipient.field_70170_p.func_73045_a(packet.targetEntityId);
        if (target != null) {
            if (MCA.getConfig().shiftClickForPlayerMarriage && !Keyboard.isKeyDown((int)42)) {
                return;
            }
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiPlayerMenu(recipient, target, packet.targetIsMarried, packet.targetIsEngaged, packet.isMarriedToInitiator, packet.targetSpouseName));
        }
    }
}

