/*
 * Decompiled with CFR 0.152.
 */
package mca.items;

import java.util.List;
import mca.blocks.BlockVillagerBed;
import mca.core.MCA;
import mca.core.minecraft.ModBlocks;
import mca.enums.EnumBedColor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemVillagerBed
extends Item {
    private EnumBedColor color;

    public ItemVillagerBed(EnumBedColor color) {
        String itemName = "ItemVillagerBed" + color.toString();
        this.color = color;
        this.func_77637_a(MCA.getCreativeTabMain());
        this.func_77625_d(1);
        this.func_77655_b(itemName);
        GameRegistry.registerItem((Item)this, (String)itemName);
    }

    private BlockVillagerBed getBedBlock() {
        switch (this.color) {
            case BLUE: {
                return ModBlocks.bedBlue;
            }
            case GREEN: {
                return ModBlocks.bedGreen;
            }
            case PINK: {
                return ModBlocks.bedPink;
            }
            case PURPLE: {
                return ModBlocks.bedPurple;
            }
            case RED: {
                return ModBlocks.bedRed;
            }
        }
        return null;
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World worldObj, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean offsetIsAir;
        if (worldObj.field_72995_K) {
            return true;
        }
        if (side != EnumFacing.UP) {
            return false;
        }
        IBlockState state = worldObj.func_180495_p(pos);
        Block block = state.func_177230_c();
        boolean isReplaceable = block.func_176200_f(worldObj, pos);
        if (!isReplaceable) {
            pos = pos.func_177972_a(EnumFacing.UP);
        }
        int metaCalc = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        EnumFacing horizontalFacing = EnumFacing.func_176731_b((int)metaCalc);
        BlockPos offsetPos = pos.func_177972_a(horizontalFacing);
        boolean offsetIsReplaceable = block.func_176200_f(worldObj, offsetPos);
        boolean posIsAir = worldObj.func_175623_d(pos) || isReplaceable;
        boolean bl = offsetIsAir = worldObj.func_175623_d(offsetPos) || offsetIsReplaceable;
        if (player.func_175151_a(pos, side, stack) && player.func_175151_a(offsetPos, side, stack)) {
            if (posIsAir && offsetIsAir && World.func_175683_a((IBlockAccess)worldObj, (BlockPos)pos.func_177972_a(EnumFacing.DOWN)) && World.func_175683_a((IBlockAccess)worldObj, (BlockPos)offsetPos.func_177972_a(EnumFacing.DOWN))) {
                int facingIndex = horizontalFacing.func_176736_b();
                IBlockState footState = this.getBedBlock().func_176223_P().func_177226_a((IProperty)BlockBed.field_176471_b, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockBed.field_176387_N, (Comparable)horizontalFacing).func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT);
                if (worldObj.func_180501_a(pos, footState, 3)) {
                    IBlockState headState = footState.func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD);
                    worldObj.func_180501_a(offsetPos, headState, 3);
                }
                --stack.field_77994_a;
                return true;
            }
            return false;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemStack, EntityPlayer entityPlayer, List informationList, boolean unknown) {
        informationList.add(MCA.getLanguageManager().getString("information.villagerbed.line1"));
        informationList.add(MCA.getLanguageManager().getString("information.villagerbed.line2"));
        informationList.add(MCA.getLanguageManager().getString("information.villagerbed.line3"));
    }
}

