/*
 * Decompiled with CFR 0.152.
 */
package mca.entity;

import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import mca.ai.AIBlink;
import mca.ai.AIBuild;
import mca.ai.AICombat;
import mca.ai.AIConverse;
import mca.ai.AICooking;
import mca.ai.AIDefend;
import mca.ai.AIEat;
import mca.ai.AIFarming;
import mca.ai.AIFishing;
import mca.ai.AIFollow;
import mca.ai.AIGreet;
import mca.ai.AIGrow;
import mca.ai.AIHunting;
import mca.ai.AIIdle;
import mca.ai.AIManager;
import mca.ai.AIMining;
import mca.ai.AIMood;
import mca.ai.AIPatrol;
import mca.ai.AIProcreate;
import mca.ai.AIProgressStory;
import mca.ai.AIRegenerate;
import mca.ai.AIRespondToAttack;
import mca.ai.AISleep;
import mca.ai.AIWoodcutting;
import mca.ai.AIWorkday;
import mca.ai.AbstractAI;
import mca.core.MCA;
import mca.core.minecraft.ModItems;
import mca.data.NBTPlayerData;
import mca.data.PlayerMemory;
import mca.data.PlayerMemoryHandler;
import mca.data.VillagerSaveData;
import mca.enums.EnumBabyState;
import mca.enums.EnumCombatBehaviors;
import mca.enums.EnumDialogueType;
import mca.enums.EnumMovementState;
import mca.enums.EnumPersonality;
import mca.enums.EnumProfession;
import mca.enums.EnumProfessionGroup;
import mca.enums.EnumProgressionStep;
import mca.enums.EnumRelation;
import mca.enums.EnumSleepingState;
import mca.items.ItemBaby;
import mca.items.ItemMemorial;
import mca.items.ItemVillagerEditor;
import mca.packets.PacketOpenGUIOnEntity;
import mca.packets.PacketSetSize;
import mca.util.MarriageHandler;
import mca.util.Utilities;
import net.minecraft.block.Block;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITradePlayer;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import radixcore.data.DataWatcherEx;
import radixcore.data.IPermanent;
import radixcore.data.IWatchable;
import radixcore.data.WatchedBoolean;
import radixcore.data.WatchedFloat;
import radixcore.data.WatchedInt;
import radixcore.data.WatchedString;
import radixcore.inventory.Inventory;
import radixcore.math.Point3D;
import radixcore.network.ByteBufIO;
import radixcore.util.BlockHelper;
import radixcore.util.RadixLogic;

public class EntityHuman
extends EntityVillager
implements IWatchable,
IPermanent,
IEntityAdditionalSpawnData {
    private static final int ENTITY_VILLAGER_TIME_UNTIL_RESET_FIELD_INDEX = 6;
    private static final int ENTITY_VILLAGER_NEEDS_INITIALIZATION = 7;
    private static final int ENTITY_VILLAGER_BUYING_PLAYER = 4;
    private static final int ENTITY_VILLAGER_LAST_BUYING_PLAYER = 10;
    private static final int ENTITY_VILLAGER_WEALTH = 9;
    private static final int ENTITY_VILLAGER_CAREER_ID = 11;
    public static final int ENTITY_VILLAGER_CAREER_LEVEL = 12;
    private final WatchedString name;
    private final WatchedString headTexture;
    private final WatchedString clothesTexture;
    private final WatchedInt professionId;
    private final WatchedInt personalityId;
    private final WatchedInt permanentId;
    private final WatchedBoolean isMale;
    private final WatchedBoolean isEngaged;
    private final WatchedInt spouseId;
    private final WatchedString spouseName;
    private final WatchedInt babyState;
    private final WatchedInt movementState;
    private final WatchedBoolean isChild;
    private final WatchedInt age;
    private final WatchedString parentNames;
    private final WatchedString parentIDs;
    private final WatchedString parentsGenders;
    private final WatchedBoolean isInteracting;
    private final WatchedFloat scaleHeight;
    private final WatchedFloat scaleGirth;
    private final WatchedBoolean doDisplay;
    private final WatchedBoolean isSwinging;
    private final WatchedInt heldItem;
    private final WatchedBoolean isInfected;
    private final WatchedBoolean doOpenInventory;
    private final WatchedString playerSkinUsername;
    private final Inventory inventory;
    @SideOnly(value=Side.CLIENT)
    public boolean displayNameForPlayer;
    public int timesWarnedForLowHearts;
    protected int ticksAlive;
    protected int swingProgressTicks;
    protected AIManager aiManager;
    protected Map<String, PlayerMemory> playerMemories;
    protected DataWatcherEx dataWatcherEx;
    private ResourceLocation playerSkinResourceLocation;
    private ThreadDownloadImageData imageDownloadThread;

    public EntityHuman(World world) {
        super(world);
        Random rand = world != null ? world.field_73012_v : new Random();
        this.dataWatcherEx = new DataWatcherEx((Entity)this, "MCA");
        this.playerMemories = new HashMap<String, PlayerMemory>();
        this.isMale = new WatchedBoolean(RadixLogic.getBooleanWithProbability((int)50), 5, this.dataWatcherEx);
        this.name = new WatchedString(this.getRandomName(), 1, this.dataWatcherEx);
        this.professionId = new WatchedInt(EnumProfession.getAtRandom().getId(), 2, this.dataWatcherEx);
        this.personalityId = new WatchedInt(EnumPersonality.getAtRandom().getId(), 28, this.dataWatcherEx);
        this.permanentId = new WatchedInt(RadixLogic.generatePermanentEntityId((Entity)this), 6, this.dataWatcherEx);
        this.headTexture = new WatchedString(this.getRandomSkin(), 3, this.dataWatcherEx);
        this.clothesTexture = new WatchedString(this.headTexture.getString(), 47, this.dataWatcherEx);
        this.isEngaged = new WatchedBoolean(false, 37, this.dataWatcherEx);
        this.spouseId = new WatchedInt(0, 8, this.dataWatcherEx);
        this.spouseName = new WatchedString("null", 15, this.dataWatcherEx);
        this.babyState = new WatchedInt(EnumBabyState.NONE.getId(), 9, this.dataWatcherEx);
        this.movementState = new WatchedInt(EnumMovementState.MOVE.getId(), 10, this.dataWatcherEx);
        this.isChild = new WatchedBoolean(false, 11, this.dataWatcherEx);
        this.age = new WatchedInt(0, 12, this.dataWatcherEx);
        this.parentNames = new WatchedString("null", 13, this.dataWatcherEx);
        this.parentIDs = new WatchedString("null", 14, this.dataWatcherEx);
        this.parentsGenders = new WatchedString("null", 51, this.dataWatcherEx);
        this.isInteracting = new WatchedBoolean(false, 27, this.dataWatcherEx);
        this.scaleHeight = new WatchedFloat((float)Utilities.getNumberInRange(rand, 0.03f, 0.09f), 29, this.dataWatcherEx);
        this.scaleGirth = new WatchedFloat((float)Utilities.getNumberInRange(rand, -0.03f, 0.05f), 30, this.dataWatcherEx);
        this.doDisplay = new WatchedBoolean(false, 38, this.dataWatcherEx);
        this.isSwinging = new WatchedBoolean(false, 45, this.dataWatcherEx);
        this.heldItem = new WatchedInt(-1, 23, this.dataWatcherEx);
        this.isInfected = new WatchedBoolean(false, 48, this.dataWatcherEx);
        this.doOpenInventory = new WatchedBoolean(false, 49, this.dataWatcherEx);
        this.playerSkinUsername = new WatchedString("null", 50, this.dataWatcherEx);
        this.aiManager = new AIManager(this);
        this.aiManager.addAI(new AIIdle(this));
        this.aiManager.addAI(new AIRegenerate(this));
        this.aiManager.addAI(new AISleep(this));
        this.aiManager.addAI(new AIFollow(this));
        this.aiManager.addAI(new AIEat(this));
        this.aiManager.addAI(new AIGreet(this, this.playerMemories));
        this.aiManager.addAI(new AIProgressStory(this));
        this.aiManager.addAI(new AIProcreate(this));
        this.aiManager.addAI(new AIRespondToAttack(this));
        this.aiManager.addAI(new AIPatrol(this));
        this.aiManager.addAI(new AIGrow(this));
        this.aiManager.addAI(new AIMood(this));
        this.aiManager.addAI(new AIConverse(this));
        this.aiManager.addAI(new AIBlink(this));
        this.aiManager.addAI(new AIBuild(this));
        this.aiManager.addAI(new AIMining(this));
        this.aiManager.addAI(new AIWoodcutting(this));
        this.aiManager.addAI(new AIHunting(this));
        this.aiManager.addAI(new AICooking(this));
        this.aiManager.addAI(new AIFarming(this));
        this.aiManager.addAI(new AIFishing(this));
        this.aiManager.addAI(new AIDefend(this));
        this.aiManager.addAI(new AIWorkday(this));
        this.aiManager.addAI(new AICombat(this));
        this.addAI();
        if (world != null && !world.field_72995_K) {
            this.doDisplay.setValue((Object)true);
        }
        this.inventory = new Inventory("Villager Inventory", false, 41);
    }

    public EntityHuman(World world, boolean isMale) {
        this(world);
        this.setIsMale(isMale);
        this.name.setValue((Object)this.getRandomName());
        this.headTexture.setValue((Object)this.getRandomSkin());
        this.clothesTexture.setValue((Object)this.headTexture.getString());
    }

    public EntityHuman(World world, boolean isMale, int profession, boolean isOverwrite) {
        this(world, isMale);
        if (isOverwrite) {
            this.setProfessionId(EnumProfession.getNewProfessionFromVanilla(profession).getId());
        } else {
            this.setProfessionId(profession);
        }
        this.headTexture.setValue((Object)this.getRandomSkin());
        this.clothesTexture.setValue((Object)this.headTexture.getString());
    }

    private EntityHuman(World world, boolean isMale, boolean isChild) {
        this(world, isMale);
        this.isChild.setValue((Object)isChild);
    }

    public EntityHuman(World world, boolean isMale, boolean isChild, String motherName, String fatherName, int motherId, int fatherId, boolean isPlayerChild) {
        this(world, isMale, isChild);
        EntityHuman father = MCA.getHumanByPermanentId(fatherId);
        EntityHuman mother = MCA.getHumanByPermanentId(motherId);
        boolean fatherIsMale = father != null ? father.getIsMale() : true;
        boolean motherIsMale = mother != null ? mother.getIsMale() : false;
        this.parentNames.setValue((Object)(fatherName + "|" + motherName));
        this.parentIDs.setValue((Object)(fatherId + "|" + motherId));
        this.parentsGenders.setValue((Object)(fatherIsMale + "|" + motherIsMale));
        if (isPlayerChild) {
            this.setProfessionId(EnumProfession.Child.getId());
            this.headTexture.setValue((Object)this.getRandomSkin());
            this.clothesTexture.setValue((Object)this.headTexture.getString());
        }
    }

    public void addAI() {
        this.field_70714_bg.field_75782_a.clear();
        ((PathNavigateGround)this.func_70661_as()).func_179690_a(false);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAITradePlayer((EntityVillager)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        int maxHealth = MCA.isTesting ? 20 : (this.getProfessionGroup() == EnumProfessionGroup.Guard ? MCA.getConfig().guardMaxHealth : MCA.getConfig().villagerMaxHealth);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)maxHealth);
        if (this.func_110143_aJ() > (float)maxHealth || this.getProfessionGroup() == EnumProfessionGroup.Guard) {
            this.func_70606_j(maxHealth);
        }
        if (this.getProfessionGroup() != EnumProfessionGroup.Guard) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoors((EntityCreature)this));
        }
    }

    public String getRandomSkin() {
        if (MCA.isTesting) {
            return "testing.png";
        }
        EnumProfessionGroup professionGroup = EnumProfession.getProfessionById(this.professionId.getInt()).getSkinGroup();
        return this.isMale.getBoolean() != false ? professionGroup.getMaleSkin() : professionGroup.getFemaleSkin();
    }

    private String getRandomName() {
        if (MCA.isTesting) {
            return this.isMale.getBoolean() != false ? "Adam" : "Eve";
        }
        if (this.isMale.getBoolean().booleanValue()) {
            return MCA.getLanguageManager().getString("name.male");
        }
        return MCA.getLanguageManager().getString("name.female");
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.aiManager.onUpdate();
        if (!this.field_70170_p.field_72995_K) {
            EntityPlayer nearestPlayer;
            ++this.ticksAlive;
            if (this.isInteracting.getBoolean().booleanValue() && (nearestPlayer = this.field_70170_p.func_72890_a((Entity)this, 10.0)) == null) {
                this.isInteracting.setValue((Object)false);
            }
            for (PlayerMemory memory : this.playerMemories.values()) {
                memory.doTick();
            }
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof ItemBaby)) continue;
                ItemBaby item = (ItemBaby)stack.func_77973_b();
                item.func_77663_a(stack, this.field_70170_p, (Entity)this, 1, false);
            }
            if (this.doOpenInventory.getBoolean().booleanValue()) {
                EntityPlayer player = this.field_70170_p.func_72890_a((Entity)this, 10.0);
                if (player != null) {
                    player.openGui((Object)MCA.getInstance(), 5, this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v);
                }
                this.setDoOpenInventory(false);
            }
        } else {
            this.updateSwinging();
        }
    }

    private void updateSwinging() {
        if (this.isSwinging.getBoolean().booleanValue()) {
            ++this.swingProgressTicks;
            if (this.swingProgressTicks >= 8) {
                this.swingProgressTicks = 0;
                if (!DataWatcherEx.allowClientSideModification) {
                    DataWatcherEx.allowClientSideModification = true;
                    this.isSwinging.setValue((Object)false);
                    DataWatcherEx.allowClientSideModification = false;
                } else {
                    this.isSwinging.setValue((Object)false);
                }
            }
        } else {
            this.swingProgressTicks = 0;
        }
        this.field_70733_aJ = (float)this.swingProgressTicks / 8.0f;
    }

    public boolean func_70085_c(EntityPlayer player) {
        if (this.field_70154_o == player) {
            this.func_70078_a(null);
            this.func_110145_l((Entity)player);
            return true;
        }
        if (!this.field_70170_p.field_72995_K) {
            Item playerItem;
            ItemStack playerItemStack = player.field_71071_by.func_70448_g();
            Item item = playerItem = playerItemStack != null ? playerItemStack.func_77973_b() : null;
            if (player.field_71075_bZ.field_75098_d && playerItem instanceof ItemMemorial && !playerItemStack.func_77942_o()) {
                ItemMemorial memorial = (ItemMemorial)playerItem;
                VillagerSaveData data = VillagerSaveData.fromVillager(this, null, player.func_110124_au());
                playerItemStack.func_77982_d(new NBTTagCompound());
                playerItemStack.func_77978_p().func_74778_a("ownerName", player.func_70005_c_());
                playerItemStack.func_77978_p().func_74768_a("relation", this.getPlayerMemory(player).getRelation().getId());
                data.writeDataToNBT(playerItemStack.func_77978_p());
                player.func_146105_b((IChatComponent)new ChatComponentText("\u00a7AVillager captured in memorial object."));
                this.func_70106_y();
            } else {
                int guiId = playerItemStack != null && playerItem instanceof ItemVillagerEditor ? 6 : 7;
                MCA.getPacketHandler().sendPacketToPlayer(new PacketOpenGUIOnEntity(this.func_145782_y(), guiId), (EntityPlayerMP)player);
            }
        }
        return true;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        this.aiManager.writeToNBT(nbt);
        nbt.func_74778_a("name", this.name.getString());
        nbt.func_74778_a("skin", this.headTexture.getString());
        nbt.func_74778_a("clothesTexture", this.clothesTexture.getString());
        nbt.func_74768_a("professionId", this.professionId.getInt());
        nbt.func_74768_a("personalityId", this.personalityId.getInt());
        nbt.func_74768_a("permanentId", this.getPermanentId());
        nbt.func_74757_a("isMale", this.isMale.getBoolean().booleanValue());
        nbt.func_74757_a("isEngaged", this.getIsEngaged());
        nbt.func_74768_a("spouseId", this.spouseId.getInt());
        nbt.func_74778_a("spouseName", this.spouseName.getString());
        nbt.func_74768_a("babyState", this.babyState.getInt());
        nbt.func_74768_a("movementState", this.movementState.getInt());
        nbt.func_74757_a("isChild", this.isChild.getBoolean().booleanValue());
        nbt.func_74768_a("age", this.age.getInt());
        nbt.func_74778_a("parentNames", this.parentNames.getString());
        nbt.func_74778_a("parentIDs", this.parentIDs.getString());
        nbt.func_74778_a("parentsGenders", this.parentsGenders.getString());
        nbt.func_74757_a("isInteracting", this.isInteracting.getBoolean().booleanValue());
        nbt.func_74776_a("scaleHeight", this.scaleHeight.getFloat().floatValue());
        nbt.func_74776_a("scaleGirth", this.scaleGirth.getFloat().floatValue());
        nbt.func_74768_a("ticksAlive", this.ticksAlive);
        nbt.func_74757_a("isInfected", this.isInfected.getBoolean().booleanValue());
        nbt.func_74778_a("playerSkinUsername", this.playerSkinUsername.getString());
        nbt.func_74768_a("timesWarnedForLowHearts", this.timesWarnedForLowHearts);
        PlayerMemoryHandler.writePlayerMemoryToNBT(this.playerMemories, nbt);
        this.dataWatcherEx.writeDataWatcherToNBT(nbt);
        nbt.func_74782_a("inventory", (NBTBase)this.inventory.saveInventoryToNBT());
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.aiManager.readFromNBT(nbt);
        this.name.setValue((Object)nbt.func_74779_i("name"));
        this.headTexture.setValue((Object)nbt.func_74779_i("skin"));
        this.clothesTexture.setValue((Object)nbt.func_74779_i("clothesTexture"));
        this.setProfessionId(nbt.func_74762_e("professionId"));
        this.personalityId.setValue((Object)nbt.func_74762_e("personalityId"));
        this.permanentId.setValue((Object)nbt.func_74762_e("permanentId"));
        this.isMale.setValue((Object)nbt.func_74767_n("isMale"));
        this.isEngaged.setValue((Object)nbt.func_74767_n("isEngaged"));
        this.spouseId.setValue((Object)nbt.func_74762_e("spouseId"));
        this.spouseName.setValue((Object)nbt.func_74779_i("spouseName"));
        this.babyState.setValue((Object)nbt.func_74762_e("babyState"));
        this.movementState.setValue((Object)nbt.func_74762_e("movementState"));
        this.isChild.setValue((Object)nbt.func_74767_n("isChild"));
        this.age.setValue((Object)nbt.func_74762_e("age"));
        this.parentNames.setValue((Object)nbt.func_74779_i("parentNames"));
        this.parentIDs.setValue((Object)nbt.func_74779_i("parentIDs"));
        this.parentsGenders.setValue((Object)nbt.func_74779_i("parentsGenders"));
        this.isInteracting.setValue((Object)nbt.func_74767_n("isInteracting"));
        this.scaleHeight.setValue((Object)Float.valueOf(nbt.func_74760_g("scaleHeight")));
        this.scaleGirth.setValue((Object)Float.valueOf(nbt.func_74760_g("scaleGirth")));
        this.ticksAlive = nbt.func_74762_e("ticksAlive");
        this.isInfected.setValue((Object)nbt.func_74767_n("isInfected"));
        this.playerSkinUsername.setValue((Object)nbt.func_74779_i("playerSkinUsername"));
        this.timesWarnedForLowHearts = nbt.func_74762_e("timesWarnedForLowHearts");
        PlayerMemoryHandler.readPlayerMemoryFromNBT(this, this.playerMemories, nbt);
        this.dataWatcherEx.readDataWatcherFromNBT(nbt);
        this.doDisplay.setValue((Object)true);
        this.addAI();
        NBTTagList tagList = nbt.func_150295_c("inventory", 10);
        this.inventory.loadInventoryFromNBT(tagList);
    }

    public void func_110297_a_(ItemStack itemStack) {
    }

    public IChatComponent func_145748_c_() {
        return new ChatComponentText("");
    }

    public void func_71038_i() {
        if (!this.isSwinging.getBoolean().booleanValue() || this.swingProgressTicks >= 4 || this.swingProgressTicks < 0) {
            this.swingProgressTicks = -1;
            this.isSwinging.setValue((Object)true);
        }
    }

    protected String func_70639_aQ() {
        return null;
    }

    protected String func_70621_aR() {
        return this.getIsInfected() ? "mob.zombie.hurt" : null;
    }

    protected String func_70673_aS() {
        return this.getIsInfected() ? "mob.zombie.death" : null;
    }

    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (!this.field_70170_p.field_72995_K) {
            Object partner;
            EntityPlayerMP killingPlayer = damageSource.func_76364_f() instanceof EntityPlayerMP ? (EntityPlayerMP)damageSource.func_76364_f() : null;
            String source = killingPlayer != null ? killingPlayer.func_70005_c_() : damageSource.func_76355_l();
            boolean memorialDropped = false;
            if (MCA.getConfig().logVillagerDeaths) {
                if (killingPlayer != null && !killingPlayer.func_70005_c_().contains("[CoFH]")) {
                    NBTPlayerData killerData = MCA.getPlayerData((EntityPlayer)killingPlayer);
                    boolean related = this.isPlayerAParent((EntityPlayer)killingPlayer) || this.getSpouseId() == killerData.getPermanentId();
                    MCA.getLog().info("Villager '" + this.name.getString() + "(" + this.getProfessionEnum().toString() + ")' was killed by player " + source + "." + " R:" + related + " M:" + this.getMotherName() + " F:" + this.getFatherName() + " S:" + this.getSpouseName());
                } else {
                    EntityPlayer nearestPlayer = this.field_70170_p.func_72890_a((Entity)this, 25.0);
                    String nearestPlayerString = nearestPlayer != null ? nearestPlayer.func_70005_c_() : "None";
                    MCA.getLog().info("Villager '" + this.name.getString() + "(" + this.getProfessionEnum().toString() + ")' was killed by " + source + ". Nearest player: " + nearestPlayerString);
                }
            }
            this.aiManager.disableAllToggleAIs();
            this.getAI(AISleep.class).transitionSkinState(true);
            if (this.isMarriedToAPlayer()) {
                UUID ownerUUID = null;
                String ownerName = null;
                EnumRelation ownerRelation = null;
                EntityPlayer playerPartner = this.getPlayerSpouse();
                if (playerPartner != null) {
                    ownerUUID = playerPartner.getPersistentID();
                    ownerName = playerPartner.func_70005_c_();
                    ownerRelation = this.getPlayerMemory(playerPartner).getRelation();
                    playerPartner.func_145747_a((IChatComponent)new ChatComponentText("\u00a7C" + this.getTitle(playerPartner) + " has died."));
                    MarriageHandler.forceEndMarriage(playerPartner);
                } else {
                    for (PlayerMemory memory : this.playerMemories.values()) {
                        if (memory.getPermanentId() != this.spouseId.getInt()) continue;
                        NBTPlayerData data = MCA.getPlayerData(this.field_70170_p, UUID.fromString(memory.getUUID()));
                        ownerUUID = UUID.fromString(memory.getUUID());
                        ownerName = memory.getPlayerName();
                        ownerRelation = memory.getRelation();
                        MarriageHandler.forceEndMarriage(data);
                        break;
                    }
                }
                if (ownerUUID != null && MCA.getConfig().allowVillagerRevival) {
                    ItemMemorial memorialItem = null;
                    switch (ownerRelation) {
                        case HUSBAND: 
                        case WIFE: {
                            memorialItem = ModItems.brokenRing;
                            break;
                        }
                        case SON: {
                            memorialItem = ModItems.toyTrain;
                            break;
                        }
                        case DAUGHTER: {
                            memorialItem = ModItems.childsDoll;
                        }
                    }
                    if (memorialItem != null) {
                        VillagerSaveData data = VillagerSaveData.fromVillager(this, null, ownerUUID);
                        ItemStack memorialStack = new ItemStack((Item)memorialItem);
                        memorialStack.func_77982_d(new NBTTagCompound());
                        memorialStack.func_77978_p().func_74778_a("ownerName", ownerName);
                        memorialStack.func_77978_p().func_74768_a("relation", ownerRelation.getId());
                        data.writeDataToNBT(memorialStack.func_77978_p());
                        memorialDropped = true;
                    }
                    this.createMemorialChestForMarriedAdult();
                    memorialDropped = true;
                }
            } else if (this.isMarriedToAVillager() && (partner = this.getVillagerSpouse()) != null) {
                ((EntityHuman)((Object)partner)).setMarriedTo(null);
            }
            for (PlayerMemory memory : this.playerMemories.values()) {
                EntityPlayer playerParent;
                if (!this.isPlayerAParent(memory.getUUID()) || (playerParent = this.field_70170_p.func_152378_a(UUID.fromString(memory.getUUID()))) == null) continue;
                playerParent.func_145747_a((IChatComponent)new ChatComponentText("\u00a7C" + this.getTitle(playerParent) + " has died."));
                if (memorialDropped) continue;
                VillagerSaveData data = VillagerSaveData.fromVillager(this, null, UUID.fromString(memory.getUUID()));
                ItemStack memorialStack = new ItemStack((Item)(this.isMale.getBoolean() != false ? ModItems.toyTrain : ModItems.childsDoll));
                memorialStack.func_77982_d(new NBTTagCompound());
                memorialStack.func_77978_p().func_74778_a("ownerName", memory.getPlayerName());
                memorialStack.func_77978_p().func_74768_a("relation", memory.getRelation().getId());
                data.writeDataToNBT(memorialStack.func_77978_p());
                this.func_70099_a(memorialStack, 1.0f);
                this.createMemorialChestForChild(memory);
                memorialDropped = true;
            }
            for (Entity entity : RadixLogic.getAllEntitiesOfTypeWithinDistance(EntityHuman.class, (Entity)this, (int)20)) {
                if (!(entity instanceof EntityHuman)) continue;
                EntityHuman human = (EntityHuman)entity;
                human.getAI(AIMood.class).modifyMoodLevel(-2.0f);
            }
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (stack == null) continue;
                this.func_70099_a(stack, 1.0f);
            }
            if (MCA.getConfig().logVillagerDeaths) {
                if (killingPlayer != null && !killingPlayer.func_70005_c_().contains("[CoFH]")) {
                    NBTPlayerData killerData = MCA.getPlayerData((EntityPlayer)killingPlayer);
                    boolean related = this.isPlayerAParent((EntityPlayer)killingPlayer) || this.getSpouseId() == killerData.getPermanentId();
                    MCA.getLog().info("Villager '" + this.name.getString() + "(" + this.getProfessionEnum().toString() + ")' was killed by player " + source + "." + " R:" + related + " M:" + this.getMotherName() + " F:" + this.getFatherName() + " S:" + this.getSpouseName());
                } else {
                    EntityPlayer nearestPlayer = this.field_70170_p.func_72890_a((Entity)this, 25.0);
                    String nearestPlayerString = nearestPlayer != null ? nearestPlayer.func_70005_c_() : "None";
                    MCA.getLog().info("Villager '" + this.name.getString() + "(" + this.getProfessionEnum().toString() + ")' was killed by " + source + ". Nearest player: " + nearestPlayerString);
                }
            }
        }
    }

    public boolean isMarriedToAVillager() {
        return this.spouseId.getInt() > 0;
    }

    protected void func_70619_bc() {
        AISleep sleepAI = this.getAI(AISleep.class);
        EnumMovementState moveState = EnumMovementState.fromId(this.movementState.getInt());
        boolean isSleeping = sleepAI.getIsSleeping();
        if (isSleeping) {
            ObfuscationReflectionHelper.setPrivateValue(EntityAITasks.class, (Object)this.field_70714_bg, (Object)1, (int)4);
        }
        if (!(isSleeping || moveState != EnumMovementState.MOVE && moveState != EnumMovementState.FOLLOW)) {
            super.func_70619_bc();
        }
        if (moveState == EnumMovementState.STAY && !isSleeping) {
            this.field_70714_bg.func_75774_a();
            this.func_70671_ap().func_75649_a();
        }
        if (moveState == EnumMovementState.STAY || isSleeping || this.isInteracting.getBoolean().booleanValue()) {
            this.func_70661_as().func_75499_g();
        }
    }

    protected void func_70665_d(DamageSource damageSource, float damageAmount) {
        AISleep aiSleep;
        super.func_70665_d(damageSource, damageAmount);
        AIRespondToAttack aiRespondToAttack = this.getAI(AIRespondToAttack.class);
        if (!aiRespondToAttack.getIsRetaliating()) {
            aiRespondToAttack.startResponse(damageSource.func_76346_g());
        }
        if ((aiSleep = this.aiManager.getAI(AISleep.class)).getIsSleeping()) {
            aiSleep.setSleepingState(EnumSleepingState.INTERRUPTED);
        }
    }

    public void sayRaw(String text, EntityPlayer target) {
        StringBuilder sb = new StringBuilder();
        if (MCA.getConfig().villagerChatPrefix != null && !MCA.getConfig().villagerChatPrefix.equals("null")) {
            sb.append(MCA.getConfig().villagerChatPrefix);
        }
        sb.append(this.getTitle(target));
        sb.append(": ");
        sb.append(text);
        if (target != null) {
            target.func_145747_a((IChatComponent)new ChatComponentText(sb.toString()));
        }
        this.aiManager.getAI(AIIdle.class).reset();
    }

    public void say(String phraseId, EntityPlayer target, Object ... arguments) {
        if (target == null) {
            return;
        }
        if (this.getIsInfected()) {
            String zombieMoan = RadixLogic.getBooleanWithProbability((int)33) ? "Raagh..." : (RadixLogic.getBooleanWithProbability((int)33) ? "Ughh..." : "Argh-gur...");
            target.func_145747_a((IChatComponent)new ChatComponentText(this.getTitle(target) + ": " + zombieMoan));
            this.field_70170_p.func_72956_a((Entity)this, "mob.zombie.say", 0.5f, this.field_70146_Z.nextFloat() + 0.5f);
        } else {
            StringBuilder sb = new StringBuilder();
            if (MCA.getConfig().villagerChatPrefix != null && !MCA.getConfig().villagerChatPrefix.equals("null")) {
                sb.append(MCA.getConfig().villagerChatPrefix);
            }
            sb.append(this.getTitle(target));
            sb.append(": ");
            sb.append(MCA.getLanguageManager().getString(phraseId, arguments));
            target.func_145747_a((IChatComponent)new ChatComponentText(sb.toString()));
            this.aiManager.getAI(AIIdle.class).reset();
            this.aiManager.getAI(AISleep.class).setSleepingState(EnumSleepingState.INTERRUPTED);
        }
    }

    public void say(String phraseId, EntityPlayer target) {
        this.say(phraseId, target, new Object[]{this, target});
    }

    public String getTitle(EntityPlayer player) {
        PlayerMemory memory = this.getPlayerMemory(player);
        if (memory.isRelatedToPlayer()) {
            return MCA.getLanguageManager().getString(this.isMale.getBoolean() != false ? "title.relative.male" : "title.relative.female", new Object[]{this, player});
        }
        return MCA.getLanguageManager().getString(this.isMale.getBoolean() != false ? "title.nonrelative.male" : "title.nonrelative.female", new Object[]{this, player});
    }

    public boolean isInOverworld() {
        return this.field_70170_p.field_73011_w.func_177502_q() == 0;
    }

    public EnumProfession getProfessionEnum() {
        return EnumProfession.getProfessionById(this.professionId.getInt());
    }

    public EnumProfessionGroup getProfessionGroup() {
        return EnumProfession.getProfessionById(this.professionId.getInt()).getSkinGroup();
    }

    public <T extends AbstractAI> T getAI(Class<T> clazz) {
        return this.aiManager.getAI(clazz);
    }

    public double getBaseAttackDamage() {
        switch (this.getPersonality()) {
            case STRONG: {
                return 2.0;
            }
            case CONFIDENT: {
                return 1.0;
            }
        }
        if (this.getProfessionGroup() == EnumProfessionGroup.Guard) {
            return 5.0;
        }
        return 0.5;
    }

    public boolean getIsMale() {
        return this.isMale.getBoolean();
    }

    public void setHeadTexture(String value) {
        this.headTexture.setValue((Object)value);
    }

    public String getHeadTexture() {
        return this.usesPlayerSkin() ? this.getPlayerSkinResourceLocation().func_110623_a() : this.headTexture.getString();
    }

    public void setClothesTexture(String value) {
        this.clothesTexture.setValue((Object)value);
    }

    public String getClothesTexture() {
        if (this.usesPlayerSkin()) {
            return this.getPlayerSkinResourceLocation().func_110623_a();
        }
        if (this.clothesTexture.getString().isEmpty()) {
            return this.headTexture.getString();
        }
        return this.clothesTexture.getString();
    }

    public boolean getIsChild() {
        return this.isChild.getBoolean();
    }

    public EnumBabyState getBabyState() {
        return EnumBabyState.fromId(this.babyState.getInt());
    }

    public int getTicksAlive() {
        return this.ticksAlive;
    }

    public void setTicksAlive(int value) {
        this.ticksAlive = value;
    }

    public void setPlayerMemory(EntityPlayer player, PlayerMemory memory) {
        this.playerMemories.put(player.func_70005_c_(), memory);
    }

    public PlayerMemory getPlayerMemory(EntityPlayer player) {
        String playerName = player.func_70005_c_();
        PlayerMemory returnMemory = this.playerMemories.get(playerName);
        if (returnMemory == null) {
            returnMemory = new PlayerMemory(this, player);
            this.playerMemories.put(playerName, returnMemory);
        }
        return returnMemory;
    }

    public PlayerMemory getPlayerMemoryWithoutCreating(EntityPlayer player) {
        String playerName = player.func_70005_c_();
        PlayerMemory returnMemory = this.playerMemories.get(playerName);
        return returnMemory;
    }

    public boolean hasMemoryOfPlayer(EntityPlayer player) {
        return this.playerMemories.containsKey(player.func_70005_c_());
    }

    public Map<String, PlayerMemory> getAllPlayerMemories() {
        return this.playerMemories;
    }

    public void setMarriedTo(Entity entity) {
        if (entity instanceof EntityHuman) {
            EntityHuman partner = (EntityHuman)entity;
            this.spouseId.setValue((Object)partner.getPermanentId());
            this.spouseName.setValue((Object)partner.func_70005_c_());
            partner.spouseId.setValue((Object)this.getPermanentId());
            partner.spouseName.setValue((Object)this.func_70005_c_());
            this.getAI(AIProgressStory.class).setProgressionStep(EnumProgressionStep.TRY_FOR_BABY);
        } else if (entity instanceof EntityPlayer) {
            EntityPlayer partner = (EntityPlayer)entity;
            NBTPlayerData data = MCA.getPlayerData(partner);
            this.spouseId.setValue((Object)data.getPermanentId());
            this.spouseName.setValue((Object)partner.func_70005_c_());
            this.getAI(AIProgressStory.class).setProgressionStep(EnumProgressionStep.FINISHED);
        } else {
            this.spouseId.setValue((Object)0);
            this.spouseName.setValue((Object)"none");
            this.isEngaged.setValue((Object)false);
            this.getAI(AIProgressStory.class).reset();
        }
        this.addAI();
    }

    public boolean getIsMarried() {
        return this.spouseId.getInt() != 0 && !this.getIsEngaged();
    }

    public boolean getIsEngaged() {
        return this.isEngaged.getBoolean();
    }

    public void setIsEngaged(boolean value, EntityPlayer partner) {
        this.isEngaged.setValue((Object)value);
        if (value) {
            NBTPlayerData data = MCA.getPlayerData(partner);
            this.spouseId.setValue((Object)data.getPermanentId());
            this.spouseName.setValue((Object)partner.func_70005_c_());
        } else {
            this.spouseId.setValue((Object)0);
            this.spouseName.setValue((Object)"none");
        }
    }

    public int getPermanentId() {
        return this.permanentId.getInt();
    }

    public void setPermanentId(int value) {
        this.permanentId.setValue((Object)value);
    }

    public int func_70654_ax() {
        return this.age.getInt();
    }

    public void setAge(int value) {
        this.age.setValue((Object)value);
    }

    public int getSpouseId() {
        return this.spouseId.getInt();
    }

    public boolean isMarriedToAPlayer() {
        return this.spouseId.getInt() < 0;
    }

    public EntityHuman getVillagerSpouse() {
        for (Object obj : this.field_70170_p.field_72996_f) {
            EntityHuman human;
            if (!(obj instanceof EntityHuman) || (human = (EntityHuman)((Object)obj)).getPermanentId() != this.getSpouseId()) continue;
            return human;
        }
        return null;
    }

    public EntityPlayer getPlayerSpouse() {
        for (PlayerMemory memory : this.playerMemories.values()) {
            if (memory.getPermanentId() != this.spouseId.getInt()) continue;
            for (Object obj : this.field_70170_p.field_73010_i) {
                EntityPlayer player = (EntityPlayer)obj;
                if (!player.func_110124_au().toString().equals(memory.getUUID())) continue;
                return player;
            }
        }
        return null;
    }

    public String getSpouseName() {
        return this.spouseName.getString();
    }

    public EnumPersonality getPersonality() {
        return EnumPersonality.getById(this.personalityId.getInt());
    }

    public ItemStack func_70694_bm() {
        if (this.getIsInfected()) {
            return null;
        }
        if (this.babyState.getInt() > 0) {
            switch (this.babyState.getInt()) {
                case 1: {
                    return new ItemStack((Item)ModItems.babyBoy);
                }
                case 2: {
                    return new ItemStack((Item)ModItems.babyGirl);
                }
            }
        } else {
            if (this.getProfessionEnum() == EnumProfession.Guard) {
                return new ItemStack(Items.field_151040_l);
            }
            if (this.getProfessionEnum() == EnumProfession.Archer) {
                return new ItemStack((Item)Items.field_151031_f);
            }
            if (this.heldItem.getInt() != -1 && this.aiManager.isToggleAIActive()) {
                return new ItemStack(Item.func_150899_d((int)this.heldItem.getInt()));
            }
            if (this.inventory.contains((Item)ModItems.babyBoy) || this.inventory.contains((Item)ModItems.babyGirl)) {
                int slot = this.inventory.getFirstSlotContainingItem((Item)ModItems.babyBoy);
                int n = slot = slot == -1 ? this.inventory.getFirstSlotContainingItem((Item)ModItems.babyGirl) : slot;
                if (slot != -1) {
                    return this.inventory.func_70301_a(slot);
                }
            } else if (this.getProfessionEnum() == EnumProfession.Warrior) {
                AICombat combat = this.getAI(AICombat.class);
                if (combat.getMethodBehavior() == EnumCombatBehaviors.METHOD_RANGED_ONLY) {
                    return this.inventory.getBestItemOfType(ItemBow.class);
                }
                return this.inventory.getBestItemOfType(ItemSword.class);
            }
        }
        return null;
    }

    public void setHeldItem(Item item) {
        if (item != null) {
            this.heldItem.setValue((Object)Item.func_150891_b((Item)item));
        } else {
            this.heldItem.setValue((Object)-1);
        }
    }

    public boolean damageHeldItem(int amount) {
        try {
            Item item;
            int slot;
            ItemStack itemInSlot;
            ItemStack heldItem = this.func_70694_bm();
            if (heldItem != null && (itemInSlot = this.inventory.func_70301_a(slot = this.inventory.getFirstSlotContainingItem(item = heldItem.func_77973_b()))) != null) {
                itemInSlot.func_77972_a(amount, (EntityLivingBase)this);
                if (itemInSlot.field_77994_a == 0) {
                    this.aiManager.disableAllToggleAIs();
                    this.inventory.func_70299_a(slot, null);
                    return true;
                }
                this.inventory.func_70299_a(slot, itemInSlot);
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void setBabyState(EnumBabyState state) {
        this.babyState.setValue((Object)state.getId());
    }

    public void setIsChild(boolean value) {
        this.isChild.setValue((Object)value);
        if (!value) {
            for (PlayerMemory memory : this.playerMemories.values()) {
                if (memory.getDialogueType() != EnumDialogueType.CHILD) continue;
                memory.setDialogueType(EnumDialogueType.ADULT);
            }
        }
    }

    public String getVillagerName() {
        return this.name.getString();
    }

    public String getParentNames() {
        return this.parentNames.getString();
    }

    public DataWatcherEx getDataWatcherEx() {
        return this.dataWatcherEx;
    }

    public void halt() {
        this.func_70661_as().func_75499_g();
        this.field_70701_bs = 0.0f;
        this.field_70702_br = 0.0f;
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    public boolean func_70104_M() {
        AISleep sleepAI = this.aiManager.getAI(AISleep.class);
        return !sleepAI.getIsSleeping();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public float getHeight() {
        return this.scaleHeight.getFloat().floatValue();
    }

    public float getGirth() {
        return this.scaleGirth.getFloat().floatValue();
    }

    public void func_70933_a(MerchantRecipe recipe) {
        recipe.func_77399_f();
        this.field_70757_a = -this.func_70627_aG();
        int i = 3 + this.field_70146_Z.nextInt(4);
        if (recipe.func_180321_e() == 1 || this.field_70146_Z.nextInt(5) == 0) {
            ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)((Object)this), (Object)40, (int)6);
            ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)((Object)this), (Object)true, (int)7);
            EntityPlayer buyingPlayer = (EntityPlayer)ReflectionHelper.getPrivateValue(EntityVillager.class, (Object)((Object)this), (int)4);
            if (buyingPlayer != null) {
                ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)((Object)this), (Object)buyingPlayer.func_70005_c_(), (int)10);
            } else {
                ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)((Object)this), null, (int)10);
            }
            i += 5;
        }
        if (recipe.func_77394_a().func_77973_b() == Items.field_151166_bC) {
            ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)((Object)this), (Object)recipe.func_77394_a().field_77994_a, (int)9);
        }
        if (recipe.func_180322_j()) {
            this.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, i));
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        ByteBufIO.writeObject((ByteBuf)buffer, this.playerMemories);
        ByteBufIO.writeObject((ByteBuf)buffer, (Object)this.playerSkinUsername.getString());
    }

    public void readSpawnData(ByteBuf additionalData) {
        Map recvMemories;
        this.playerMemories = recvMemories = (Map)ByteBufIO.readObject((ByteBuf)additionalData);
        this.setPlayerSkin((String)ByteBufIO.readObject((ByteBuf)additionalData));
    }

    public void setIsInteracting(boolean value) {
        this.isInteracting.setValue((Object)value);
    }

    public boolean getIsInteracting() {
        return this.isInteracting.getBoolean();
    }

    public void setSizeOverride(float width, float height) {
        this.func_70105_a(width, height);
        if (!this.field_70170_p.field_72995_K) {
            MCA.getPacketHandler().sendPacketToAllPlayers(new PacketSetSize(this, width, height));
        }
    }

    public String getFatherName() {
        try {
            return this.parentNames.getString().substring(0, this.parentNames.getString().indexOf("|"));
        }
        catch (Exception e) {
            return "?";
        }
    }

    public String getMotherName() {
        try {
            return this.parentNames.getString().substring(this.parentNames.getString().indexOf("|") + 1, this.parentNames.getString().length());
        }
        catch (Exception e) {
            return "?";
        }
    }

    public int getFatherId() {
        try {
            return Integer.parseInt(this.parentIDs.getString().substring(0, this.parentIDs.getString().indexOf("|")));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setMovementState(EnumMovementState state) {
        this.movementState.setValue((Object)state.getId());
    }

    public EnumMovementState getMovementState() {
        return EnumMovementState.fromId(this.movementState.getInt());
    }

    public int getMotherId() {
        try {
            return Integer.parseInt(this.parentIDs.getString().substring(this.parentIDs.getString().indexOf("|") + 1, this.parentIDs.getString().length()));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean getDoDisplay() {
        return this.doDisplay.getBoolean();
    }

    public void setName(String string) {
        this.name.setValue((Object)string);
    }

    public boolean allowIntimateInteractions(EntityPlayer player) {
        return !this.getIsChild() && !this.isPlayerAParent(player);
    }

    public boolean isPlayerAParent(EntityPlayer player) {
        NBTPlayerData data = MCA.getPlayerData(player);
        if (data != null) {
            return this.getMotherId() == data.getPermanentId() || this.getFatherId() == data.getPermanentId();
        }
        return false;
    }

    public boolean isPlayerAParent(String uuid) {
        NBTPlayerData data = MCA.getPlayerData(this.field_70170_p, UUID.fromString(uuid));
        if (data != null) {
            return this.getMotherId() == data.getPermanentId() || this.getFatherId() == data.getPermanentId();
        }
        return false;
    }

    public boolean allowControllingInteractions(EntityPlayer player) {
        NBTPlayerData data = MCA.getPlayerData(player);
        if (data.getIsSuperUser()) {
            return true;
        }
        if (this.isMarriedToAPlayer() && this.getSpouseId() != data.getPermanentId()) {
            return false;
        }
        if (this.getIsChild()) {
            if (this.isPlayerAParent(player)) {
                return true;
            }
            return this.isChildOfAVillager();
        }
        return true;
    }

    public boolean allowWorkInteractions(EntityPlayer player) {
        NBTPlayerData data = MCA.getPlayerData(player);
        PlayerMemory memory = this.getPlayerMemory(player);
        if (data.getIsSuperUser()) {
            return true;
        }
        if (this.getIsInfected()) {
            return false;
        }
        if (memory.getIsHiredBy()) {
            return true;
        }
        return this.isPlayerAParent(player);
    }

    public void openInventory(EntityPlayer player) {
        MCA.getPacketHandler().sendPacketToPlayer(new PacketOpenGUIOnEntity(this.func_145782_y(), 5), (EntityPlayerMP)player);
    }

    public boolean isChildOfAVillager() {
        return this.getMotherId() >= 0 && this.getFatherId() >= 0;
    }

    public Inventory getVillagerInventory() {
        return this.inventory;
    }

    public AIManager getAIManager() {
        return this.aiManager;
    }

    public float getSpeed() {
        return this.getPersonality() == EnumPersonality.ATHLETIC ? 0.7f : 0.6f;
    }

    public boolean getCanBeHired(EntityPlayer player) {
        return this.getPlayerSpouse() != player && (this.getProfessionGroup() == EnumProfessionGroup.Farmer || this.getProfessionGroup() == EnumProfessionGroup.Miner || this.getProfessionGroup() == EnumProfessionGroup.Warrior);
    }

    public void setIsMale(boolean value) {
        this.isMale.setValue((Object)value);
        this.setHeadTexture(this.getRandomSkin());
    }

    public void setHeight(float f) {
        this.scaleHeight.setValue((Object)Float.valueOf(f));
    }

    public void setGirth(float f) {
        this.scaleGirth.setValue((Object)Float.valueOf(f));
    }

    public void setProfessionId(int profession) {
        this.professionId.setValue((Object)profession);
        int vanillaProfId = this.getProfessionGroup().getVanillaProfessionId();
        this.func_70938_b(vanillaProfId);
        ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)((Object)this), (Object)this.getProfessionEnum().getVanillaCareerId(), (int)11);
        ReflectionHelper.setPrivateValue(EntityVillager.class, (Object)((Object)this), (Object)1, (int)12);
    }

    public void setPersonality(int personalityId) {
        this.personalityId.setValue((Object)personalityId);
    }

    public void setParentNames(String parentNames) {
        this.parentNames.setValue((Object)parentNames);
    }

    public void setParentIDs(String parentIDs) {
        this.parentIDs.setValue((Object)parentIDs);
    }

    public void setParentsGenders(String parentsGenders) {
        this.parentsGenders.setValue((Object)parentsGenders);
    }

    public int func_70946_n() {
        return this.getProfessionGroup().getVanillaProfessionId();
    }

    public String func_70005_c_() {
        return this.name.getString();
    }

    private MerchantRecipeList getBuyingList() {
        return (MerchantRecipeList)ObfuscationReflectionHelper.getPrivateValue(EntityVillager.class, (Object)((Object)this), (int)5);
    }

    public void setSpouseId(int value) {
        this.spouseId.setValue((Object)value);
    }

    public void setSpouseName(String value) {
        this.spouseName.setValue((Object)value);
    }

    public void setIsEngaged(boolean value) {
        this.isEngaged.setValue((Object)value);
    }

    public boolean getIsInfected() {
        return this.isInfected.getBoolean();
    }

    public void setIsInfected(boolean value) {
        this.isInfected.setValue((Object)value);
    }

    public void setDoOpenInventory(boolean value) {
        this.doOpenInventory.setValue((Object)value);
    }

    public ItemStack func_71124_b(int slot) {
        switch (slot) {
            case 0: {
                return this.func_70694_bm();
            }
            case 1: {
                return this.inventory.func_70301_a(39);
            }
            case 2: {
                return this.inventory.func_70301_a(38);
            }
            case 3: {
                return this.inventory.func_70301_a(37);
            }
            case 4: {
                return this.inventory.func_70301_a(36);
            }
        }
        return null;
    }

    public int func_70658_aO() {
        int value = 0;
        for (int i = 36; i < 40; ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemArmor)) continue;
            value += ((ItemArmor)stack.func_77973_b()).field_77879_b;
        }
        return value;
    }

    public void func_70675_k(float amount) {
        boolean value = false;
        for (int i = 36; i < 40; ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof ItemArmor)) continue;
            stack.func_77972_a((int)amount, (EntityLivingBase)this);
        }
    }

    public void setPlayerSkin(String username) {
        if (!username.isEmpty() && !username.equals("null")) {
            if (username.equals("SheWolfDeadly")) {
                username = "TheSheWolfDeadly";
            }
            boolean previous = DataWatcherEx.allowClientSideModification;
            DataWatcherEx.allowClientSideModification = true;
            this.playerSkinUsername.setValue((Object)username);
            DataWatcherEx.allowClientSideModification = previous;
            this.playerSkinResourceLocation = AbstractClientPlayer.func_110311_f((String)this.playerSkinUsername.getString());
            this.imageDownloadThread = AbstractClientPlayer.func_110304_a((ResourceLocation)this.playerSkinResourceLocation, (String)this.playerSkinUsername.getString());
        } else {
            boolean previous = DataWatcherEx.allowClientSideModification;
            DataWatcherEx.allowClientSideModification = true;
            this.playerSkinUsername.setValue((Object)"null");
            DataWatcherEx.allowClientSideModification = previous;
            this.playerSkinResourceLocation = null;
            this.imageDownloadThread = null;
        }
    }

    public boolean usesPlayerSkin() {
        return this.getPlayerSkinResourceLocation() != null;
    }

    public ResourceLocation getPlayerSkinResourceLocation() {
        return this.playerSkinResourceLocation;
    }

    public String getPlayerSkinUsername() {
        return this.playerSkinUsername.getString();
    }

    public void cureInfection() {
        this.setIsInfected(false);
        this.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 200, 0));
        this.field_70170_p.func_180498_a((EntityPlayer)null, 1017, new BlockPos((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v), 0);
        Utilities.spawnParticlesAroundEntityS(EnumParticleTypes.VILLAGER_HAPPY, (Entity)this, 16);
    }

    public boolean getFatherIsMale() {
        try {
            return Boolean.parseBoolean(this.parentsGenders.getString().split("\\|")[0]);
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean getMotherIsMale() {
        try {
            return Boolean.parseBoolean(this.parentsGenders.getString().split("\\|")[1]);
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getParentIds() {
        return this.parentIDs.getString();
    }

    public String getParentsGenders() {
        return this.parentsGenders.getString();
    }

    public void setDoDisplay(boolean value) {
        this.doDisplay.setValue((Object)value);
    }

    public void facePosition(Point3D position) {
        double midX = position.dPosX - this.field_70165_t;
        double midZ = position.dPosZ - this.field_70161_v;
        double d1 = 0.0;
        double d3 = MathHelper.func_76133_a((double)(midX * midX + midZ * midZ));
        float f2 = (float)(Math.atan2(midZ, midX) * 180.0 / Math.PI) - 90.0f;
        float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
        this.field_70125_A = this.updateRotation(this.field_70125_A, f3, 16.0f);
        this.field_70177_z = this.updateRotation(this.field_70177_z, f2, 16.0f);
    }

    private float updateRotation(float p_70663_1_, float p_70663_2_, float p_70663_3_) {
        float f3 = MathHelper.func_76142_g((float)(p_70663_2_ - p_70663_1_));
        if (f3 > p_70663_3_) {
            f3 = p_70663_3_;
        }
        if (f3 < -p_70663_3_) {
            f3 = -p_70663_3_;
        }
        return p_70663_1_ + f3;
    }

    private void createMemorialChestForChild(PlayerMemory memory) {
        VillagerSaveData data = VillagerSaveData.fromVillager(this, null, UUID.fromString(memory.getUUID()));
        ItemStack memorialStack = new ItemStack((Item)(this.isMale.getBoolean() != false ? ModItems.toyTrain : ModItems.childsDoll));
        memorialStack.func_77982_d(new NBTTagCompound());
        memorialStack.func_77978_p().func_74778_a("ownerName", memory.getPlayerName());
        memorialStack.func_77978_p().func_74768_a("relation", memory.getRelation().getId());
        data.writeDataToNBT(memorialStack.func_77978_p());
        this.createMemorialChestAtCurrentLocation(memorialStack);
    }

    private void createMemorialChestForMarriedAdult() {
        UUID ownerUUID = null;
        String ownerName = null;
        EnumRelation ownerRelation = null;
        ItemMemorial memorialItem = null;
        EntityPlayer playerPartner = this.getPlayerSpouse();
        if (playerPartner == null) {
            return;
        }
        ownerUUID = playerPartner.getPersistentID();
        ownerName = playerPartner.func_70005_c_();
        ownerRelation = this.getPlayerMemory(playerPartner).getRelation();
        switch (ownerRelation) {
            case HUSBAND: 
            case WIFE: {
                memorialItem = ModItems.brokenRing;
                break;
            }
            case SON: {
                memorialItem = ModItems.toyTrain;
                break;
            }
            case DAUGHTER: {
                memorialItem = ModItems.childsDoll;
            }
        }
        if (memorialItem != null) {
            VillagerSaveData data = VillagerSaveData.fromVillager(this, null, ownerUUID);
            ItemStack memorialStack = new ItemStack((Item)memorialItem);
            memorialStack.func_77982_d(new NBTTagCompound());
            memorialStack.func_77978_p().func_74778_a("ownerName", ownerName);
            memorialStack.func_77978_p().func_74768_a("relation", ownerRelation.getId());
            data.writeDataToNBT(memorialStack.func_77978_p());
            this.createMemorialChestAtCurrentLocation(memorialStack);
        }
    }

    private void createMemorialChestAtCurrentLocation(ItemStack memorialItem) {
        Point3D nearestAir = RadixLogic.getFirstNearestBlock((Entity)this, (Block)Blocks.field_150350_a, (int)3);
        if (nearestAir == null) {
            MCA.getLog().warn("No available location to spawn villager death chest for " + this.func_70005_c_());
        } else {
            int y = nearestAir.iPosY;
            Block block = Blocks.field_150350_a;
            while (block == Blocks.field_150350_a) {
                block = BlockHelper.getBlock((World)this.field_70170_p, (int)nearestAir.iPosX, (int)(--y), (int)nearestAir.iPosZ);
            }
            BlockHelper.setBlock((World)this.field_70170_p, (int)nearestAir.iPosX, (int)(++y), (int)nearestAir.iPosZ, (Block)Blocks.field_150486_ae);
            try {
                TileEntityChest chest = (TileEntityChest)this.field_70170_p.func_175625_s(new BlockPos(nearestAir.iPosX, y, nearestAir.iPosZ));
                chest.func_70299_a(0, memorialItem);
                MCA.getLog().info("Spawned villager death chest at: " + nearestAir.iPosX + ", " + y + ", " + nearestAir.iPosZ);
            }
            catch (Exception e) {
                MCA.getLog().error("Error spawning villager death chest: " + e.getMessage());
                return;
            }
        }
    }
}

