/*
 * Decompiled with CFR 0.152.
 */
package mca.data;

import java.io.Serializable;
import java.util.UUID;
import mca.core.MCA;
import mca.data.PlayerDataCollection;
import mca.packets.PacketPlayerDataC;
import mca.packets.PacketPlayerDataS;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public final class NBTPlayerData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int permanentId;
    private int spousePermanentId;
    private int genderPreference;
    private boolean isMale;
    private boolean shouldHaveBaby;
    private boolean isEngaged;
    private boolean hasChosenDestiny;
    private String mcaName;
    private String spouseName;
    private boolean isSuperUser;
    private boolean isNobility;
    private boolean happinessThresholdMet;
    public boolean ignoreBroadcast;

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("permanentId", this.permanentId);
        nbt.func_74768_a("spousePermanentId", this.spousePermanentId);
        nbt.func_74768_a("genderPreference", this.genderPreference);
        nbt.func_74757_a("isMale", this.isMale);
        nbt.func_74757_a("shouldHaveBaby", this.shouldHaveBaby);
        nbt.func_74757_a("isEngaged", this.isEngaged);
        nbt.func_74757_a("hasChosenDestiny", this.hasChosenDestiny);
        nbt.func_74778_a("mcaName", this.mcaName == null || this.mcaName.isEmpty() ? "none" : this.mcaName);
        nbt.func_74778_a("spouseName", this.spouseName == null || this.spouseName.isEmpty() ? "none" : this.spouseName);
        nbt.func_74757_a("isSuperUser", this.isSuperUser);
        nbt.func_74757_a("isNobility", this.isNobility);
        nbt.func_74757_a("happinessThresholdMet", this.happinessThresholdMet);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.permanentId = nbt.func_74762_e("permanentId");
        this.spousePermanentId = nbt.func_74762_e("spousePermanentId");
        this.genderPreference = nbt.func_74762_e("genderPreference");
        this.isMale = nbt.func_74767_n("isMale");
        this.shouldHaveBaby = nbt.func_74767_n("shouldHaveBaby");
        this.isEngaged = nbt.func_74767_n("isEngaged");
        this.hasChosenDestiny = nbt.func_74767_n("hasChosenDestiny");
        this.mcaName = nbt.func_74779_i("mcaName");
        this.spouseName = nbt.func_74779_i("spouseName");
        this.isSuperUser = nbt.func_74767_n("isSuperUser");
        this.isNobility = nbt.func_74767_n("isNobility");
        this.happinessThresholdMet = nbt.func_74767_n("happinessThresholdMet");
    }

    public int getPermanentId() {
        return this.permanentId;
    }

    public void setPermanentId(int value) {
        this.permanentId = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.PERMANENT_ID, TypeID.INT, value));
    }

    public int getSpousePermanentId() {
        return this.spousePermanentId;
    }

    public int getGenderPreference() {
        return this.genderPreference;
    }

    public void setGenderPreference(int value) {
        this.genderPreference = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.GENDER_PREFERENCE, TypeID.INT, value));
    }

    public boolean getIsMale() {
        return this.isMale;
    }

    public void setIsMale(boolean value) {
        this.isMale = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.IS_MALE, TypeID.BOOLEAN, value));
    }

    public boolean getShouldHaveBaby() {
        return this.shouldHaveBaby;
    }

    public void setShouldHaveBaby(boolean value) {
        this.shouldHaveBaby = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.SHOULD_HAVE_BABY, TypeID.BOOLEAN, value));
    }

    public void setSpousePermanentId(int value) {
        this.spousePermanentId = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.SPOUSE_PERMANENT_ID, TypeID.INT, value));
    }

    public boolean getIsEngaged() {
        return this.isEngaged;
    }

    public boolean getHasChosenDestiny() {
        return this.hasChosenDestiny;
    }

    public void setHasChosenDestiny(boolean value) {
        this.hasChosenDestiny = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.HAS_CHOSEN_DESTINY, TypeID.BOOLEAN, value));
    }

    public String getMcaName() {
        return this.mcaName;
    }

    public void setMcaName(String value) {
        this.mcaName = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.MCA_NAME, TypeID.STRING, value));
    }

    public String getSpouseName() {
        return this.spouseName;
    }

    public void setSpouseName(String value) {
        this.spouseName = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.SPOUSE_NAME, TypeID.STRING, value));
    }

    public boolean getIsSuperUser() {
        return this.isSuperUser;
    }

    public void setIsSuperUser(boolean value) {
        this.isSuperUser = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.IS_SUPER_USER, TypeID.BOOLEAN, value));
    }

    public boolean getIsMarried() {
        return this.spousePermanentId != 0 && !this.getIsEngaged();
    }

    public void setIsEngaged(boolean value) {
        this.isEngaged = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.IS_ENGAGED, TypeID.BOOLEAN, value));
    }

    public boolean getIsNobility() {
        return this.isNobility;
    }

    public void setIsNobility(boolean value) {
        this.isNobility = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.IS_NOBILITY, TypeID.BOOLEAN, value));
    }

    public boolean getHappinessThresholdMet() {
        return this.happinessThresholdMet;
    }

    public void setHappinessThresholdMet(boolean value) {
        this.happinessThresholdMet = value;
        this.broadcastValueChange(FieldUpdateObj.get(FieldID.HAPPINESS_THRESHOLD_MET, TypeID.BOOLEAN, value));
    }

    private void broadcastValueChange(FieldUpdateObj fieldUpdate) {
        if (this.ignoreBroadcast) {
            this.ignoreBroadcast = false;
            return;
        }
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            MCA.getPacketHandler().sendPacketToServer(new PacketPlayerDataS(fieldUpdate));
        } else {
            PlayerDataCollection.get().func_76185_a();
            UUID ownerUUID = PlayerDataCollection.get().getUUIDByReference(this);
            if (ownerUUID != null) {
                EntityPlayer player = null;
                for (WorldServer server : MinecraftServer.func_71276_C().field_71305_c) {
                    EntityPlayer foundPlayer = server.func_152378_a(ownerUUID);
                    if (foundPlayer == null) continue;
                    player = foundPlayer;
                    break;
                }
                if (player != null) {
                    MCA.getPacketHandler().sendPacketToPlayer(new PacketPlayerDataC(fieldUpdate), (EntityPlayerMP)player);
                } else {
                    MCA.getLog().error("Error getting player instance by UUID");
                }
            } else {
                MCA.getLog().error("Error looking up player by UUID");
            }
        }
    }

    public void setByFieldUpdateObj(FieldUpdateObj obj) {
        this.ignoreBroadcast = true;
        switch (obj.fieldId) {
            case PERMANENT_ID: {
                this.setPermanentId((Integer)obj.value);
                break;
            }
            case SPOUSE_PERMANENT_ID: {
                this.setSpousePermanentId((Integer)obj.value);
                break;
            }
            case IS_MALE: {
                this.setIsMale((Boolean)obj.value);
                break;
            }
            case SHOULD_HAVE_BABY: {
                this.setShouldHaveBaby((Boolean)obj.value);
                break;
            }
            case IS_ENGAGED: {
                this.setIsEngaged((Boolean)obj.value);
                break;
            }
            case IS_NOBILITY: {
                this.setIsNobility((Boolean)obj.value);
                break;
            }
            case MCA_NAME: {
                this.setMcaName((String)obj.value);
                break;
            }
            case HAS_CHOSEN_DESTINY: {
                this.setHasChosenDestiny((Boolean)obj.value);
                break;
            }
            case GENDER_PREFERENCE: {
                this.setGenderPreference((Integer)obj.value);
                break;
            }
            case IS_SUPER_USER: {
                this.setIsSuperUser((Boolean)obj.value);
                break;
            }
            case SPOUSE_NAME: {
                this.setSpouseName((String)obj.value);
                break;
            }
            case HAPPINESS_THRESHOLD_MET: {
                this.setHappinessThresholdMet((Boolean)obj.value);
            }
        }
        this.ignoreBroadcast = false;
    }

    public void dumpToConsole() {
        MCA.getLog().info("--------PLAYER DATA DUMP--------");
        MCA.getLog().info("Permanent ID: " + this.getPermanentId());
        MCA.getLog().info("Spouse Permanent ID: " + this.getSpousePermanentId());
        MCA.getLog().info("Is Male: " + this.getIsMale());
        MCA.getLog().info("Should Have Baby: " + this.getShouldHaveBaby());
        MCA.getLog().info("Is Engaged: " + this.getIsEngaged());
        MCA.getLog().info("Is Nobility: " + this.getIsNobility());
        MCA.getLog().info("MCA Name: " + this.getMcaName());
        MCA.getLog().info("Has Chosen Destiny: " + this.getHasChosenDestiny());
    }

    public static class FieldUpdateObj {
        private static FieldUpdateObj instance;
        public TypeID typeId;
        public FieldID fieldId;
        public Object value;

        private FieldUpdateObj() {
        }

        public static FieldUpdateObj get(FieldID fieldId, TypeID typeId, Object value) {
            if (instance == null) {
                instance = new FieldUpdateObj();
            }
            FieldUpdateObj.instance.fieldId = fieldId;
            FieldUpdateObj.instance.typeId = typeId;
            FieldUpdateObj.instance.value = value;
            return instance;
        }
    }

    public static enum TypeID {
        STRING(1),
        BOOLEAN(2),
        INT(3);

        private int id;

        private TypeID(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static TypeID fromId(int id) {
            for (TypeID value : TypeID.values()) {
                if (value.id != id) continue;
                return value;
            }
            return null;
        }
    }

    public static enum FieldID {
        PERMANENT_ID(1),
        SPOUSE_PERMANENT_ID(2),
        HEIR_PERMANENT_ID(3),
        IS_MALE(4),
        SHOULD_HAVE_BABY(5),
        IS_ENGAGED(6),
        IS_IN_LITE_MODE(7),
        IS_NOBILITY(8),
        MCA_NAME(9),
        UNUSED_10(10),
        HAS_CHOSEN_DESTINY(11),
        GENDER_PREFERENCE(12),
        IS_SUPER_USER(13),
        SPOUSE_NAME(14),
        HAPPINESS_THRESHOLD_MET(15);

        private int id;

        private FieldID(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static FieldID fromId(int id) {
            for (FieldID value : FieldID.values()) {
                if (value.id != id) continue;
                return value;
            }
            return null;
        }
    }
}

